/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.shell.Converter;
import org.eclipse.virgo.shell.internal.CommandDescriptor;
import org.eclipse.virgo.shell.internal.CommandInvoker;
import org.eclipse.virgo.shell.internal.CommandNotFoundException;
import org.eclipse.virgo.shell.internal.CommandRegistry;
import org.eclipse.virgo.shell.internal.ParametersMismatchException;
import org.eclipse.virgo.shell.internal.converters.ConverterRegistry;
import org.eclipse.virgo.shell.internal.parsing.ParsedCommand;
import org.springframework.util.ReflectionUtils;

final class CommandRegistryCommandInvoker
implements CommandInvoker {
    private final CommandRegistry commandRegistry;
    private final ConverterRegistry converterRegistry;

    CommandRegistryCommandInvoker(CommandRegistry commandRegistry, ConverterRegistry converterRegistry) {
        this.commandRegistry = commandRegistry;
        this.converterRegistry = converterRegistry;
    }

    @Override
    public List<String> invokeCommand(ParsedCommand command) throws CommandNotFoundException, ParametersMismatchException {
        List<CommandDescriptor> commands = CommandRegistryCommandInvoker.commandsOfCommandName(this.commandRegistry, command.getCommand());
        if (commands.isEmpty()) {
            throw new CommandNotFoundException();
        }
        String[] arguments = command.getArguments();
        String subcommandName = CommandRegistryCommandInvoker.extractSubcommand(arguments);
        String[] subcommandArguments = CommandRegistryCommandInvoker.extractSubcommandArguments(arguments);
        ParametersMismatchException lastException = null;
        for (CommandDescriptor commandDescriptor : commands) {
            List<String> objResult = null;
            String commandSubcommandName = commandDescriptor.getSubCommandName();
            String commandString = commandDescriptor.getCommandName();
            try {
                if (commandSubcommandName != null && !commandSubcommandName.equals("")) {
                    if (!CommandRegistryCommandInvoker.isSubcommandMatch(commandSubcommandName, subcommandName)) continue;
                    commandString = String.valueOf(commandString) + " " + subcommandName;
                    objResult = this.attemptExecution(commandDescriptor, subcommandArguments);
                    return objResult;
                }
                objResult = this.attemptExecution(commandDescriptor, arguments);
                return objResult;
            }
            catch (ParametersMismatchException e) {
                lastException = new ParametersMismatchException("Command " + commandString + ": " + e.getMessage());
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new ParametersMismatchException("Command '" + command.getCommand() + "' expects a subcommand; try help vsh:" + command.getCommand());
    }

    private static boolean isSubcommandMatch(String commandSubcommandName, String subcommandName) {
        if (subcommandName == null) {
            return false;
        }
        return commandSubcommandName != null && commandSubcommandName.equals(subcommandName);
    }

    private static String[] extractSubcommandArguments(String[] arguments) {
        if (arguments.length > 0) {
            String[] result = new String[arguments.length - 1];
            System.arraycopy(arguments, 1, result, 0, result.length);
            return result;
        }
        return null;
    }

    private static String extractSubcommand(String[] arguments) {
        if (arguments.length > 0) {
            return arguments[0];
        }
        return null;
    }

    private List<String> attemptExecution(CommandDescriptor commandDescriptor, String[] arguments) throws ParametersMismatchException {
        Method method = commandDescriptor.getMethod();
        Object[] convertedArguments = this.convertArguments(method, arguments);
        ReflectionUtils.makeAccessible((Method)method);
        return (List)ReflectionUtils.invokeMethod((Method)method, (Object)commandDescriptor.getTarget(), (Object[])convertedArguments);
    }

    private static List<CommandDescriptor> commandsOfCommandName(CommandRegistry commandRegistry, String commandName) {
        ArrayList<CommandDescriptor> commands = new ArrayList<CommandDescriptor>();
        for (CommandDescriptor commandDescriptor : commandRegistry.getCommandDescriptors()) {
            if (!commandDescriptor.getCommandName().equals(commandName)) continue;
            commands.add(commandDescriptor);
        }
        return commands;
    }

    private Object[] convertArguments(Method method, String[] arguments) throws ParametersMismatchException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != arguments.length) {
            throw new ParametersMismatchException("Incorrect number of parameters");
        }
        Object[] parameters = new Object[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            Object convertedParameter = this.convertArgument(arguments[i], parameterTypes[i]);
            if (convertedParameter == null) {
                throw new ParametersMismatchException("Cannot convert parameter " + i + ".");
            }
            parameters[i] = convertedParameter;
            ++i;
        }
        return parameters;
    }

    private Object convertArgument(String argument, Class<?> type) {
        Converter converter = this.converterRegistry.getConverter(type);
        if (converter == null) {
            return null;
        }
        try {
            return converter.convert(type, argument);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

