/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OwbParametrizedTypeImpl
implements ParameterizedType {
    private final Type owner;
    private final Type rawType;
    private final List<Type> types = new ArrayList<Type>();

    public OwbParametrizedTypeImpl(Type owner, Type raw) {
        this.owner = owner;
        this.rawType = raw;
    }

    public Type[] getActualTypeArguments() {
        return this.types.toArray(new Type[this.types.size()]);
    }

    public void addTypeArgument(Type type) {
        this.types.add(type);
    }

    public Type getOwnerType() {
        return this.owner;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getActualTypeArguments());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.rawType == null ? 0 : this.rawType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OwbParametrizedTypeImpl other = (OwbParametrizedTypeImpl)obj;
        if (!Arrays.equals(this.getActualTypeArguments(), other.getActualTypeArguments())) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        return !(this.rawType == null ? other.rawType != null : !this.rawType.equals(other.rawType));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Class)this.rawType).getSimpleName());
        Type[] actualTypes = this.getActualTypeArguments();
        if (actualTypes.length > 0) {
            buffer.append("<");
            int length = actualTypes.length;
            for (int i = 0; i < length; ++i) {
                buffer.append(actualTypes[i].toString());
                if (i == actualTypes.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(">");
        }
        return buffer.toString();
    }
}

