/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.core.WebContainer;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.osgi.extensions.equinox.hooks.PluggableDelegatingClassLoaderDelegateHook;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.web.core.WebApplicationRegistry;
import org.eclipse.virgo.web.core.internal.WebAppClassLoaderDelegateHook;
import org.eclipse.virgo.web.core.internal.WebDeploymentEnvironment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

final class WebBundleLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private static final String EMPTY_CONTEXT_PATH = "";
    private static final String ROOT_CONTEXT_PATH = "/";
    private final Map<InstallArtifact, WebApplication> webApplications;
    private final Map<Bundle, BundleInstallArtifact> webBundleInstallArtifacts;
    private final WebAppClassLoaderDelegateHook classLoaderDelegateHook;
    private final EventHandler webBundleDeployedEventHandler;
    private final WebDeploymentEnvironment environment;
    private final BundleContext bundleContext;
    private volatile ServiceRegistration<EventHandler> eventHandlerRegistration;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    WebBundleLifecycleListener(WebDeploymentEnvironment environment, BundleContext bundleContext) {
        try {
            this.webApplications = new ConcurrentHashMap<InstallArtifact, WebApplication>();
            this.webBundleInstallArtifacts = new ConcurrentHashMap<Bundle, BundleInstallArtifact>();
            this.classLoaderDelegateHook = new WebAppClassLoaderDelegateHook();
            this.webBundleDeployedEventHandler = new WebBundleDeployedEventHandler(this, null);
            this.environment = environment;
            this.bundleContext = bundleContext;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void init() {
        try {
            PluggableDelegatingClassLoaderDelegateHook.getInstance().addDelegate((ClassLoaderDelegateHook)this.classLoaderDelegateHook);
            this.registerEventHandler();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void registerEventHandler() {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("event.topics", "org/osgi/service/web/DEPLOYED");
            this.eventHandlerRegistration = this.bundleContext.registerService(EventHandler.class, (Object)this.webBundleDeployedEventHandler, properties);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void destroy() {
        try {
            PluggableDelegatingClassLoaderDelegateHook.getInstance().removeDelegate((ClassLoaderDelegateHook)this.classLoaderDelegateHook);
            this.unregisterEventHandler();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void unregisterEventHandler() {
        try {
            ServiceRegistration<EventHandler> localRegistration = this.eventHandlerRegistration;
            if (localRegistration != null) {
                this.eventHandlerRegistration = null;
                localRegistration.unregister();
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onStarting(InstallArtifact installArtifact) throws DeploymentException {
        try {
            if (WebBundleLifecycleListener.isWebBundle(installArtifact)) {
                try {
                    this.webApplications.put(installArtifact, this.getWebContainer().createWebApplication(((BundleInstallArtifact)installArtifact).getBundle()));
                }
                catch (BundleException be) {
                    throw new DeploymentException("Failed to create new web application for web bundle '" + installArtifact + "'.", (Throwable)be);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onStarted(InstallArtifact installArtifact) throws DeploymentException {
        try {
            WebApplication webApplication = this.webApplications.get(installArtifact);
            if (webApplication != null) {
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                Bundle bundle = bundleInstallArtifact.getBundle();
                this.webBundleInstallArtifacts.put(bundle, bundleInstallArtifact);
                try {
                    webApplication.start();
                    this.classLoaderDelegateHook.addWebApplication(webApplication, bundle);
                    String contextPath = this.getContextPath(webApplication);
                    this.getApplicationRegistry().registerWebApplication(contextPath, this.getApplicationName(installArtifact));
                    installArtifact.setProperty("org.eclipse.virgo.web.contextPath", contextPath);
                    installArtifact.setProperty("artifact-type", "Web Bundle");
                }
                catch (WebApplicationStartFailedException wasfe) {
                    throw new DeploymentException("Web application failed to start", (Throwable)wasfe);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected void webBundleDeployed(Bundle webBundle) {
        try {
            BundleInstallArtifact installArtifact = this.webBundleInstallArtifacts.get(webBundle);
            if (installArtifact != null) {
                WebApplication webApplication = this.webApplications.get(installArtifact);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onStopping(InstallArtifact installArtifact) {
        try {
            WebApplication webApplication = this.webApplications.remove(installArtifact);
            if (webApplication != null) {
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                Bundle bundle = bundleInstallArtifact.getBundle();
                this.getApplicationRegistry().unregisterWebApplication(this.getContextPath(webApplication));
                this.classLoaderDelegateHook.removeWebApplication(bundle);
                webApplication.stop();
                this.webBundleInstallArtifacts.remove(((BundleInstallArtifact)installArtifact).getBundle());
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean isWebBundle(InstallArtifact installArtifact) throws DeploymentException {
        try {
            if (installArtifact instanceof BundleInstallArtifact) {
                try {
                    BundleManifest bundleManifest = ((BundleInstallArtifact)installArtifact).getBundleManifest();
                    return "web-bundle".equals(bundleManifest.getModuleType());
                }
                catch (IOException ioe) {
                    throw new DeploymentException("Failed to get bundle manifest from '" + installArtifact + "'", (Throwable)ioe);
                }
            }
            return false;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getContextPath(WebApplication webApplication) {
        try {
            String contextPath = webApplication.getServletContext().getContextPath();
            if (EMPTY_CONTEXT_PATH.equals(contextPath)) {
                return ROOT_CONTEXT_PATH;
            }
            return contextPath;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private WebContainer getWebContainer() {
        try {
            return this.environment.getWebContainer();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private WebApplicationRegistry getApplicationRegistry() {
        try {
            return this.environment.getApplicationRegistry();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getApplicationName(InstallArtifact installArtifact) {
        try {
            return String.valueOf(installArtifact.getName()) + "-" + installArtifact.getVersion();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WebBundleLifecycleListener");
    }

    private final class WebBundleDeployedEventHandler
    implements EventHandler {
        final /* synthetic */ WebBundleLifecycleListener this$0;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private WebBundleDeployedEventHandler(WebBundleLifecycleListener webBundleLifecycleListener) {
            this.this$0 = webBundleLifecycleListener;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void handleEvent(Event event) {
            try {
                if ("org/osgi/service/web/DEPLOYED".equals(event.getTopic())) {
                    this.this$0.webBundleDeployed((Bundle)event.getProperty("bundle"));
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ WebBundleDeployedEventHandler(WebBundleLifecycleListener webBundleLifecycleListener, WebBundleDeployedEventHandler webBundleDeployedEventHandler) {
            WebBundleLifecycleListener webBundleLifecycleListener2 = webBundleLifecycleListener;
            WebBundleDeployedEventHandler ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = webBundleLifecycleListener2;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.core.internal.WebBundleLifecycleListener$WebBundleDeployedEventHandler");
        }
    }
}

