/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.deploy.SecurityCollection;

public class SecurityConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(boolean authConstraint) {
        this.authConstraint = authConstraint;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public void setUserConstraint(String userConstraint) {
        if (userConstraint != null) {
            this.userConstraint = userConstraint;
        }
    }

    public void addAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        if ("*".equals(authRole)) {
            this.allRoles = true;
            return;
        }
        String[] results = new String[this.authRoles.length + 1];
        for (int i = 0; i < this.authRoles.length; ++i) {
            results[i] = this.authRoles[i];
        }
        results[this.authRoles.length] = authRole;
        this.authRoles = results;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        SecurityCollection[] results = new SecurityCollection[this.collections.length + 1];
        for (int i = 0; i < this.collections.length; ++i) {
            results[i] = this.collections[i];
        }
        results[this.collections.length] = collection;
        this.collections = results;
    }

    public boolean findAuthRole(String role) {
        if (role == null) {
            return false;
        }
        for (int i = 0; i < this.authRoles.length; ++i) {
            if (!role.equals(this.authRoles[i])) continue;
            return true;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.collections.length; ++i) {
            if (!name.equals(this.collections[i].getName())) continue;
            return this.collections[i];
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean included(String uri, String method) {
        if (method == null) {
            return false;
        }
        for (int i = 0; i < this.collections.length; ++i) {
            if (!this.collections[i].findMethod(method)) continue;
            String[] patterns = this.collections[i].findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                if (!this.matchPattern(uri, patterns[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAuthRole(String authRole) {
        if (authRole == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.authRoles.length; ++i) {
            if (!this.authRoles[i].equals(authRole)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.authRoles.length - 1];
            for (int i = 0; i < this.authRoles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.authRoles[i];
            }
            this.authRoles = results;
        }
    }

    public void removeCollection(SecurityCollection collection) {
        if (collection == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.collections.length; ++i) {
            if (!this.collections[i].equals(collection)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            SecurityCollection[] results = new SecurityCollection[this.collections.length - 1];
            for (int i = 0; i < this.collections.length; ++i) {
                if (i == n) continue;
                results[j++] = this.collections[i];
            }
            this.collections = results;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SecurityConstraint[");
        for (int i = 0; i < this.collections.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.collections[i].getName());
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public static SecurityConstraint[] createConstraints(ServletSecurityElement element, String urlPattern) {
        HashSet<SecurityConstraint> result = new HashSet<SecurityConstraint>();
        Collection methods = element.getHttpMethodConstraints();
        for (HttpMethodConstraintElement methodElement : methods) {
            SecurityConstraint constraint = SecurityConstraint.createConstraint((HttpConstraintElement)methodElement, urlPattern, true);
            SecurityCollection collection = constraint.findCollections()[0];
            collection.addMethod(methodElement.getMethodName());
            result.add(constraint);
        }
        SecurityConstraint constraint = SecurityConstraint.createConstraint((HttpConstraintElement)element, urlPattern, false);
        if (constraint != null) {
            SecurityCollection collection = constraint.findCollections()[0];
            Iterator ommittedMethod = element.getMethodNames().iterator();
            while (ommittedMethod.hasNext()) {
                collection.addOmittedMethod((String)ommittedMethod.next());
            }
            result.add(constraint);
        }
        return result.toArray(new SecurityConstraint[result.size()]);
    }

    private static SecurityConstraint createConstraint(HttpConstraintElement element, String urlPattern, boolean alwaysCreate) {
        SecurityConstraint constraint = new SecurityConstraint();
        SecurityCollection collection = new SecurityCollection();
        boolean create = alwaysCreate;
        if (element.getTransportGuarantee() != ServletSecurity.TransportGuarantee.NONE) {
            constraint.setUserConstraint(element.getTransportGuarantee().name());
            create = true;
        }
        if (element.getRolesAllowed().length > 0) {
            String[] roles;
            for (String role : roles = element.getRolesAllowed()) {
                constraint.addAuthRole(role);
            }
            create = true;
        }
        if (element.getEmptyRoleSemantic() != ServletSecurity.EmptyRoleSemantic.PERMIT) {
            constraint.setAuthConstraint(true);
            create = true;
        }
        if (create) {
            collection.addPattern(urlPattern);
            constraint.addCollection(collection);
            return constraint;
        }
        return null;
    }
}

