/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.virgo.kernel.userregion.internal.equinox.UsesAnalyser;
import org.eclipse.virgo.kernel.userregion.internal.quasi.ResolutionFailureDetective;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public final class StandardResolutionFailureDetective
implements ResolutionFailureDetective {
    private final UsesAnalyser usesAnalyser = new UsesAnalyser();
    private final PlatformAdmin platformAdmin;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardResolutionFailureDetective(PlatformAdmin platformAdmin) {
        this.platformAdmin = platformAdmin;
    }

    @Override
    public String generateFailureDescription(State state, BundleDescription bundleDescription, ResolutionFailureDetective.ResolverErrorsHolder resolverErrorsHolder) {
        StringBuilder sb;
        block4: {
            block3: {
                sb = new StringBuilder();
                sb.append("Cannot resolve: ").append(bundleDescription.getSymbolicName()).append("\n");
                ResolverError[] resolverErrors = this.gatherResolverErrors(bundleDescription, state);
                resolverErrorsHolder.setResolverErrors(resolverErrors);
                if (resolverErrors.length <= 0) break block3;
                this.indent(sb, 1);
                sb.append("Resolver report:\n");
                ResolverError[] resolverErrorArray = resolverErrors;
                int n = resolverErrors.length;
                int n2 = 0;
                while (n2 < n) {
                    ResolverError resolverError = resolverErrorArray[n2];
                    this.indent(sb, 2);
                    this.formatResolverError(resolverError, sb, state);
                    sb.append("\n");
                    ++n2;
                }
                break block4;
            }
            VersionConstraint[] unsatisfiedLeaves = this.platformAdmin.getStateHelper().getUnsatisfiedLeaves(new BundleDescription[]{bundleDescription});
            if (unsatisfiedLeaves.length <= 0) break block4;
            this.indent(sb, 1);
            sb.append("Unsatisfied leaf constraints:\n");
            VersionConstraint[] versionConstraintArray = unsatisfiedLeaves;
            int n = unsatisfiedLeaves.length;
            int n3 = 0;
            while (n3 < n) {
                VersionConstraint versionConstraint = versionConstraintArray[n3];
                if (!this.isOptional(versionConstraint)) {
                    this.indent(sb, 2);
                    this.formatConstraint(versionConstraint, sb);
                    sb.append("\n");
                }
                ++n3;
            }
        }
        return sb.toString();
    }

    private ResolverError[] gatherResolverErrors(BundleDescription bundleDescription, State state) {
        BundleDescription[] bundles;
        LinkedHashSet resolverErrors = new LinkedHashSet();
        Collections.addAll(resolverErrors, state.getResolverErrors(bundleDescription));
        BundleDescription[] bundleDescriptionArray = bundles = state.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bd = bundleDescriptionArray[n2];
            if (!bd.isResolved()) {
                Collections.addAll(resolverErrors, state.getResolverErrors(bd));
            }
            ++n2;
        }
        return resolverErrors.toArray(new ResolverError[resolverErrors.size()]);
    }

    private String nearestMatch(String match) {
        Set<String> candidates = this.gatherExports();
        int nearestDistance = Integer.MAX_VALUE;
        String nearestMatch = null;
        for (String candidate : candidates) {
            int distance = StandardResolutionFailureDetective.calculateStringDistance(match, candidate);
            if (distance >= nearestDistance) continue;
            nearestDistance = distance;
            nearestMatch = candidate;
        }
        return nearestMatch;
    }

    private static final int calculateStringDistance(String s1, String s2) {
        if (s1.isEmpty()) {
            return s2.length();
        }
        if (s2.isEmpty()) {
            return s1.length();
        }
        int s2len = s2.length();
        int s1len = s1.length();
        int[][] d = new int[s1len + 1][s2len + 1];
        int i = 0;
        while (i <= s1len) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= s2len) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= s1len) {
            char s_i = s1.charAt(i - 1);
            int j2 = 1;
            while (j2 <= s2len) {
                char t_j = s2.charAt(j2 - 1);
                int cost = Character.toLowerCase(s_i) == Character.toLowerCase(t_j) ? 0 : 1;
                d[i][j2] = Math.min(Math.min(d[i - 1][j2] + 1, d[i][j2 - 1] + 1), d[i - 1][j2 - 1] + cost);
                ++j2;
            }
            ++i;
        }
        return d[s1len][s2len];
    }

    private Set<String> gatherExports() {
        State state = this.platformAdmin.getState(false);
        ExportPackageDescription[] exportedPackages = state.getExportedPackages();
        HashSet<String> exports = new HashSet<String>(exportedPackages.length);
        ExportPackageDescription[] exportPackageDescriptionArray = exportedPackages;
        int n = exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription epd = exportPackageDescriptionArray[n2];
            exports.add(epd.getName());
            ++n2;
        }
        return exports;
    }

    private void formatResolverError(ResolverError resolverError, StringBuilder sb, State state) {
        if (resolverError.getType() == 32) {
            this.formatUsesConflict(resolverError, sb, state);
        } else if (resolverError.getType() == 4) {
            this.formatMissingFragment(resolverError, sb);
        } else if (resolverError.getType() == 16) {
            this.formatFragmentConflict(resolverError, sb, state);
        } else {
            this.formatBasicResolverError(resolverError, sb);
        }
    }

    private void formatBasicResolverError(ResolverError resolverError, StringBuilder sb) {
        sb.append(this.getTypeDescription(resolverError.getType()));
        VersionConstraint unsatisfiedConstraint = resolverError.getUnsatisfiedConstraint();
        if (unsatisfiedConstraint != null) {
            this.formatMissingConstraintWithAttributes(resolverError, sb, unsatisfiedConstraint);
        } else {
            sb.append(" In bundle <").append(resolverError.getBundle()).append(">");
        }
    }

    private void formatMissingFragment(ResolverError resolverError, StringBuilder sb) {
        sb.append(this.getTypeDescription(resolverError.getType()));
        sb.append(" The affected fragment is ").append(resolverError.getBundle());
    }

    private void formatUsesConflict(ResolverError resolverError, StringBuilder sb, State state) {
        VersionConstraint unsatisfiedConstraint = resolverError.getUnsatisfiedConstraint();
        BundleDescription bundle = resolverError.getBundle();
        sb.append("Uses violation: <").append(unsatisfiedConstraint).append("> in bundle <").append(bundle).append("[").append(bundle.getBundleId()).append("]").append(">\n");
        UsesAnalyser.AnalysedUsesConflict[] usesConflicts = this.usesAnalyser.getUsesConflicts(state, resolverError);
        if (usesConflicts == null || usesConflicts.length == 0) {
            this.indent(sb, 3);
            sb.append(" Resolver reported uses conflict for import");
            this.formatConstraintAttributes(sb, unsatisfiedConstraint);
        } else {
            this.formatConflictsFound(sb, usesConflicts);
        }
    }

    private void formatMissingConstraintWithAttributes(ResolverError resolverError, StringBuilder sb, VersionConstraint unsatisfiedConstraint) {
        sb.append(" Caused by missing constraint in bundle <").append(resolverError.getBundle()).append(">\n");
        this.indent(sb, 3);
        sb.append(" constraint: <").append(unsatisfiedConstraint).append(">");
        this.formatConstraintAttributes(sb, unsatisfiedConstraint);
    }

    private void formatConstraintAttributes(StringBuilder sb, VersionConstraint unsatisfiedConstraint) {
        if (unsatisfiedConstraint instanceof ImportPackageSpecification) {
            ImportPackageSpecification importPackageSpecification = (ImportPackageSpecification)unsatisfiedConstraint;
            this.formatConstrainedBundleAttributes(sb, importPackageSpecification);
            Map attributes = importPackageSpecification.getAttributes();
            if (attributes != null && !attributes.isEmpty()) {
                sb.append("\n");
                this.indent(sb, 3);
                sb.append("with attributes ").append(attributes).append("\n");
            }
        }
    }

    private void formatConstrainedBundleAttributes(StringBuilder sb, ImportPackageSpecification importPackageSpecification) {
        String bundleSymbolicName = importPackageSpecification.getBundleSymbolicName();
        if (bundleSymbolicName != null) {
            sb.append(" constrained to bundle <").append(bundleSymbolicName).append(">");
            VersionRange versionRange = importPackageSpecification.getBundleVersionRange();
            if (versionRange != null) {
                sb.append(" constrained bundle version range \"").append(versionRange).append("\"");
            }
        }
    }

    private void formatConflictsFound(StringBuilder sb, UsesAnalyser.AnalysedUsesConflict[] usesConflicts) {
        this.indent(sb, 3);
        sb.append("Found conflicts:\n");
        UsesAnalyser.AnalysedUsesConflict[] analysedUsesConflictArray = usesConflicts;
        int n = usesConflicts.length;
        int n2 = 0;
        while (n2 < n) {
            UsesAnalyser.AnalysedUsesConflict conflict = analysedUsesConflictArray[n2];
            String[] stringArray = conflict.getConflictStatement();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray[n4];
                this.indent(sb, 4);
                sb.append(line).append("\n");
                ++n4;
            }
            ++n2;
        }
    }

    private void formatFragmentConflict(ResolverError resolverError, StringBuilder sb, State state) {
        this.formatMissingFragment(resolverError, sb);
        List<BundleDescription> possibleHosts = this.findPossibleHosts((VersionConstraint)resolverError.getUnsatisfiedConstraint().getBundle().getHost(), state);
        if (!possibleHosts.isEmpty()) {
            sb.append("\n");
            this.indent(sb, 3);
            sb.append("Possible hosts:\n");
            for (BundleDescription possibleHost : possibleHosts) {
                this.indent(sb, 4);
                sb.append(possibleHost).append(" ").append(possibleHost.isResolved() ? "(resolved)" : "(not resolved)").append("\n");
            }
            this.indent(sb, 3);
            sb.append("Constraint conflict:\n");
            this.indent(sb, 4);
            sb.append(resolverError.getUnsatisfiedConstraint());
        }
    }

    private List<BundleDescription> findPossibleHosts(VersionConstraint hostSpecification, State state) {
        ArrayList<BundleDescription> possibleHosts = new ArrayList<BundleDescription>();
        BundleDescription[] bundles = state.getBundles(hostSpecification.getName());
        if (bundles != null) {
            BundleDescription[] bundleDescriptionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                if (hostSpecification.getVersionRange().isIncluded(bundle.getVersion())) {
                    possibleHosts.add(bundle);
                }
                ++n2;
            }
        }
        return possibleHosts;
    }

    private void formatConstraint(VersionConstraint versionConstraint, StringBuilder sb) {
        String constraintInformation = versionConstraint.toString();
        String bundleInQuestion = versionConstraint.getBundle().toString();
        sb.append("Bundle: ").append(bundleInQuestion).append(" - ").append(constraintInformation);
        if (versionConstraint instanceof ImportPackageSpecification) {
            sb.append("\n");
            this.indent(sb, 3);
            sb.append("Did you mean: '").append(this.nearestMatch(versionConstraint.getName())).append("'?");
        }
    }

    private boolean isOptional(VersionConstraint versionConstraint) {
        if (versionConstraint instanceof ImportPackageSpecification) {
            ImportPackageSpecification ips = (ImportPackageSpecification)versionConstraint;
            return !"static".equals(ips.getDirective("resolution"));
        }
        return false;
    }

    private void indent(StringBuilder out, int level) {
        int n = 0;
        while (n < level) {
            out.append("    ");
            ++n;
        }
    }

    private String getTypeDescription(int type) {
        switch (type) {
            case 1: {
                return "An Import-Package could not be resolved.";
            }
            case 2: {
                return "A Require-Bundle could not be resolved.";
            }
            case 4: {
                return "A Fragment-Host could not be resolved.";
            }
            case 8: {
                return "The bundle could not be resolved because another singleton bundle was selected.";
            }
            case 16: {
                return "The fragment could not be resolved because of a constraint conflict with a host, possibly because the host is already resolved.";
            }
            case 32: {
                return "An Import-Package could not be resolved because of a uses directive conflict.";
            }
            case 64: {
                return "A Require-Bundle could not be resolved because of a uses directive conflict.";
            }
            case 128: {
                return "An Import-Package could not be resolved because the importing bundle does not have the correct permissions to import the package.";
            }
            case 256: {
                return "An Import-Package could not be resolved because no exporting bundle has the correct permissions to export the package.";
            }
            case 512: {
                return "A Require-Bundle could not be resolved because the requiring bundle does not have the correct permissions to require the bundle.";
            }
            case 1024: {
                return "A Require-Bundle could not be resolved because no bundle with the required symbolic name has the correct permissions to provied the required symbolic name.";
            }
            case 2048: {
                return "A Fragment-Host could not be resolved because no bundle with the required symbolic name has the correct permissions to host a fragment.";
            }
            case 4096: {
                return "A Fragment-Host could not be resolved because the fragment bundle does not have the correct permissions to be a fragment.";
            }
            case 8192: {
                return "A bundle could not be resolved because a platform filter did not match the runtime environment.";
            }
            case 16384: {
                return "A bundle could not be resolved because the required execution enviroment did not match the runtime environment.";
            }
            case 32768: {
                return "A bundle could not be resolved because the required generic capability could not be resolved.";
            }
            case 65536: {
                return "A bundle could not be resolved because no match was found for the native code specification.";
            }
            case 131072: {
                return "A bundle could not be resolved because the matching native code paths are invalid.";
            }
            case 262144: {
                return "A bundle could not be resolved because the bundle was disabled.";
            }
        }
        return "Unknown Error.";
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.StandardResolutionFailureDetective");
    }
}

