/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.jpa.unit;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.jpa.unit.PropertiesAdapter;
import org.apache.openejb.jee.jpa.unit.TransactionType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"description", "provider", "jtaDataSource", "nonJtaDataSource", "mappingFile", "jarFile", "clazz", "excludeUnlistedClasses", "sharedCacheMode", "validationMode", "properties"})
public class PersistenceUnit {
    @XmlTransient
    private String id;
    protected String description;
    protected String provider;
    @XmlElement(name="jta-data-source")
    protected String jtaDataSource;
    @XmlElement(name="non-jta-data-source")
    protected String nonJtaDataSource;
    @XmlElement(name="mapping-file", required=true)
    protected List<String> mappingFile;
    @XmlElement(name="jar-file", required=true)
    protected List<String> jarFile;
    @XmlElement(name="class", required=true)
    protected List<String> clazz;
    @XmlElement(name="exclude-unlisted-classes", defaultValue="false")
    protected Boolean excludeUnlistedClasses;
    @XmlElement(name="shared-cache-mode")
    protected SharedCacheMode sharedCacheMode;
    @XmlElement(name="validation-mode")
    protected ValidationMode validationMode;
    @XmlElement(name="properties")
    @XmlJavaTypeAdapter(value=PropertiesAdapter.class)
    protected Properties properties;
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute(name="transaction-type")
    protected TransactionType transactionType;

    public PersistenceUnit(String name, String provider) {
        this.name = name;
        this.provider = provider;
    }

    public PersistenceUnit() {
    }

    public PersistenceUnit(String unitName) {
        this.name = unitName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public void setProvider(Class value) {
        this.setProvider(value == null ? null : value.getName());
    }

    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(String value) {
        this.jtaDataSource = value;
    }

    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(String value) {
        this.nonJtaDataSource = value;
    }

    public List<String> getMappingFile() {
        if (this.mappingFile == null) {
            this.mappingFile = new ArrayList<String>();
        }
        return this.mappingFile;
    }

    public List<String> getJarFile() {
        if (this.jarFile == null) {
            this.jarFile = new ArrayList<String>();
        }
        return this.jarFile;
    }

    public List<String> getClazz() {
        if (this.clazz == null) {
            this.clazz = new ArrayList<String>();
        }
        return this.clazz;
    }

    public boolean addClass(String s) {
        return this.getClazz().add(s);
    }

    public boolean addClass(Class clazz) {
        return this.addClass(clazz.getName());
    }

    public Boolean isExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(Boolean value) {
        this.excludeUnlistedClasses = value;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperties().getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.getProperties().setProperty(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public TransactionType getTransactionType() {
        return this.transactionType == null ? TransactionType.JTA : this.transactionType;
    }

    public void setTransactionType(TransactionType value) {
        this.transactionType = value;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode == null ? SharedCacheMode.NONE : this.sharedCacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode == null ? ValidationMode.AUTO : this.validationMode;
    }
}

