/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.CascadeOnDelete;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.Noncacheable;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;

public abstract class DirectCollectionAccessor
extends DirectAccessor {
    private Boolean m_cascadeOnDelete;
    private Boolean m_nonCacheable;
    private String m_joinFetch;
    private String m_batchFetch;
    private Integer m_batchFetchSize;
    private CollectionTableMetadata m_collectionTable;

    protected DirectCollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected DirectCollectionAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation batchFetch;
        MetadataAnnotation joinFetch;
        if (annotation != null) {
            this.setFetch((String)annotation.getAttribute("fetch"));
        }
        if ((joinFetch = this.getAnnotation(JoinFetch.class)) != null) {
            this.m_joinFetch = (String)joinFetch.getAttribute("value");
        }
        if ((batchFetch = this.getAnnotation(BatchFetch.class)) != null) {
            this.m_batchFetch = (String)batchFetch.getAttributeString("value");
            this.m_batchFetchSize = (Integer)batchFetch.getAttribute("size");
        }
        this.m_cascadeOnDelete = this.isAnnotationPresent(CascadeOnDelete.class);
        this.m_nonCacheable = this.isAnnotationPresent(Noncacheable.class);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DirectCollectionAccessor) {
            DirectCollectionAccessor directCollectionAccessor = (DirectCollectionAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_joinFetch, directCollectionAccessor.getJoinFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetch, directCollectionAccessor.getBatchFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetchSize, directCollectionAccessor.getBatchFetchSize())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeOnDelete, directCollectionAccessor.getCascadeOnDelete())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nonCacheable, directCollectionAccessor.getNonCacheable())) {
                return false;
            }
            return this.valuesMatch(this.m_collectionTable, directCollectionAccessor.getCollectionTable());
        }
        return false;
    }

    public String getBatchFetch() {
        return this.m_batchFetch;
    }

    public Boolean getCascadeOnDelete() {
        return this.m_cascadeOnDelete;
    }

    public Integer getBatchFetchSize() {
        return this.m_batchFetchSize;
    }

    public void setBatchFetchSize(Integer batchFetchSize) {
        this.m_batchFetchSize = batchFetchSize;
    }

    public CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected String getDefaultCollectionTableName() {
        return String.valueOf(this.getOwningDescriptor().getAlias()) + "_" + this.getDefaultAttributeName();
    }

    @Override
    public String getDefaultFetchType() {
        return "LAZY";
    }

    public String getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    protected DatabaseTable getReferenceDatabaseTable() {
        if (this.m_collectionTable == null) {
            return null;
        }
        return this.m_collectionTable.getDatabaseTable();
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    protected abstract String getKeyConverter();

    public Boolean getNonCacheable() {
        return this.m_nonCacheable;
    }

    protected String getValueConverter() {
        return this.getConvert();
    }

    protected boolean hasMapKeyClass() {
        return false;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_collectionTable, accessibleObject);
    }

    public Boolean isCascadeOnDelete() {
        if (this.m_cascadeOnDelete != null && this.m_cascadeOnDelete.booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirectCollection() {
        return true;
    }

    public boolean isNonCacheable() {
        return this.m_nonCacheable != null && this.m_nonCacheable != false;
    }

    protected boolean isValidDirectCollectionType() {
        return this.getAccessibleObject().isSupportedCollectionClass(this.getRawClass());
    }

    protected boolean isValidDirectMapType() {
        return this.getAccessibleObject().isSupportedMapClass(this.getRawClass());
    }

    protected void process(DatabaseMapping mapping) {
        this.setMapping(mapping);
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        if (mapping instanceof CollectionMapping) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            collectionMapping.setReferenceClassName(this.getReferenceClassName());
            this.processJoinFetch(this.getJoinFetch(), (ForeignReferenceMapping)collectionMapping);
            this.processBatchFetch(this.getBatchFetch(), (ForeignReferenceMapping)collectionMapping);
            this.processCollectionTable(collectionMapping);
            collectionMapping.setShouldExtendPessimisticLockScope(true);
            collectionMapping.setIsCascadeOnDeleteSetOnDatabase(this.isCascadeOnDelete().booleanValue());
        } else if (mapping instanceof AggregateMapping) {
            AggregateMapping aggregateMapping = (AggregateMapping)mapping;
            aggregateMapping.setReferenceClassName(this.getReferenceClassName());
        }
        mapping.setIsCacheable(!this.isNonCacheable());
        this.processReturnInsertAndUpdate();
        this.processPartitioning();
    }

    protected void processCollectionTable(CollectionMapping mapping) {
        if (this.m_collectionTable == null) {
            this.m_collectionTable = new CollectionTableMetadata(this);
        }
        this.processTable(this.m_collectionTable, this.getDefaultCollectionTableName());
        if (this.isDirectEmbeddableCollection()) {
            ((AggregateCollectionMapping)mapping).setDefaultSourceTable(this.m_collectionTable.getDatabaseTable());
        } else {
            ((DirectCollectionMapping)mapping).setReferenceTable(this.m_collectionTable.getDatabaseTable());
        }
    }

    protected void processDirectCollectionMapping() {
        DatabaseMapping mapping = this.getOwningDescriptor().getClassDescriptor().newDirectCollectionMapping();
        this.process(mapping);
        this.processContainerPolicyAndIndirection((ContainerMapping)mapping);
        if (mapping instanceof DirectCollectionMapping) {
            DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)mapping;
            directCollectionMapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
            if (this.hasAttributeType() || this.getAccessibleObject().isGenericCollectionType()) {
                directCollectionMapping.setDirectFieldClassificationName(this.getJavaClassName(this.getReferenceClass()));
            }
        } else if (mapping.isAbstractCompositeDirectCollectionMapping()) {
            ((AbstractCompositeDirectCollectionMapping)mapping).setField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column"));
        }
        this.processMappingValueConverter(mapping, this.getValueConverter(), this.getReferenceClass());
    }

    protected void processDirectMapMapping() {
        DirectMapMapping mapping = new DirectMapMapping();
        this.process((DatabaseMapping)mapping);
        this.processContainerPolicyAndIndirection((ContainerMapping)mapping);
        mapping.setDirectKeyField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column"));
        if (this.isBasicMap()) {
            if (this.hasAttributeType() || this.getAccessibleObject().isGenericCollectionType()) {
                mapping.setDirectKeyFieldClassificationName(this.getJavaClassName(this.getMapKeyReferenceClass()));
            }
            this.processMappingKeyConverter((DatabaseMapping)mapping, this.getKeyConverter(), this.getMapKeyReferenceClass());
        }
        mapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        if (this.hasAttributeType() || this.getAccessibleObject().isGenericCollectionType()) {
            mapping.setDirectFieldClassificationName(this.getJavaClassName(this.getReferenceClass()));
        }
        this.processMappingValueConverter((DatabaseMapping)mapping, this.getValueConverter(), this.getReferenceClass());
    }

    public void setBatchFetch(String batchFetch) {
        this.m_batchFetch = batchFetch;
    }

    public void setCascadeOnDelete(Boolean cascadeOnDelete) {
        this.m_cascadeOnDelete = cascadeOnDelete;
    }

    public void setCollectionTable(CollectionTableMetadata collectionTable) {
        this.m_collectionTable = collectionTable;
    }

    public void setNonCacheable(Boolean nonCacheable) {
        this.m_nonCacheable = nonCacheable;
    }

    public void setJoinFetch(String joinFetch) {
        this.m_joinFetch = joinFetch;
    }
}

