/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.Arrays;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.SqlException;

class LOBStateTracker {
    public static final LOBStateTracker NO_OP_TRACKER = new LOBStateTracker(new int[0], new boolean[0], false);
    private final int[] columns;
    private final boolean[] isBlob;
    private final boolean[] published;
    private final boolean doRelease;
    private final int[] lastLocatorSeen;

    LOBStateTracker(int[] nArray, boolean[] blArray, boolean bl) {
        this.columns = nArray;
        this.isBlob = blArray;
        this.published = new boolean[this.columns.length];
        this.doRelease = bl;
        this.lastLocatorSeen = new int[this.columns.length];
    }

    void checkCurrentRow(Cursor cursor) throws SqlException {
        if (this.doRelease) {
            CallableLocatorProcedures callableLocatorProcedures = cursor.getLocatorProcedures();
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.published[i] || cursor.isNull_[this.columns[i] - 1]) continue;
                int n = cursor.locator(this.columns[i]);
                if (n == this.lastLocatorSeen[i]) {
                    return;
                }
                if (n == -1) {
                    return;
                }
                this.lastLocatorSeen[i] = n;
                if (this.isBlob[i]) {
                    callableLocatorProcedures.blobReleaseLocator(n);
                    continue;
                }
                callableLocatorProcedures.clobReleaseLocator(n);
            }
            Arrays.fill(this.published, false);
        }
    }

    void discardState() {
        if (this.doRelease) {
            Arrays.fill(this.published, true);
        }
    }

    void markAsPublished(int n) {
        if (this.doRelease) {
            int n2 = Arrays.binarySearch(this.columns, n);
            this.published[n2] = true;
        }
    }
}

