/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingMarshalRecord
extends MarshalRecord {
    private MarshalRecord marshalRecord;
    private ContentHandlerRecord validatingRecord;

    public ValidatingMarshalRecord(MarshalRecord marshalRecord, XMLMarshaller xmlMarshaller) {
        this.marshalRecord = marshalRecord;
        Schema schema = xmlMarshaller.getSchema();
        ValidatorHandler validatorHandler = schema.newValidatorHandler();
        validatorHandler.setErrorHandler(new ValidatingMarshalRecordErrorHandler(marshalRecord, xmlMarshaller.getErrorHandler()));
        if (xmlMarshaller.isFragment()) {
            try {
                validatorHandler.startDocument();
            }
            catch (SAXException sAXException) {}
        }
        this.validatingRecord = new ContentHandlerRecord();
        this.validatingRecord.setMarshaller(xmlMarshaller);
        this.validatingRecord.setContentHandler(validatorHandler);
        this.validatingRecord.setEqualNamespaceResolvers(marshalRecord.hasEqualNamespaceResolvers());
    }

    @Override
    public void startDocument(String encoding, String version) {
        this.validatingRecord.startDocument(encoding, version);
        this.marshalRecord.startDocument(encoding, version);
    }

    @Override
    public void endDocument() {
        this.validatingRecord.endDocument();
        this.marshalRecord.endDocument();
    }

    @Override
    public void element(XPathFragment frag) {
        this.validatingRecord.element(frag);
        this.marshalRecord.element(frag);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.validatingRecord.attribute(xPathFragment, namespaceResolver, value);
        this.marshalRecord.attribute(xPathFragment, namespaceResolver, value);
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        this.validatingRecord.attribute(namespaceURI, localName, qName, value);
        this.marshalRecord.attribute(namespaceURI, localName, qName, value);
    }

    @Override
    public void closeStartElement() {
        this.validatingRecord.closeStartElement();
        this.marshalRecord.closeStartElement();
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.endElement(xPathFragment, namespaceResolver);
        this.marshalRecord.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public HashMap getPositionalNodes() {
        return this.marshalRecord.getPositionalNodes();
    }

    @Override
    public void addGroupingElement(XPathNode xPathNode) {
        this.validatingRecord.addGroupingElement(xPathNode);
        this.marshalRecord.addGroupingElement(xPathNode);
    }

    @Override
    public void removeGroupingElement(XPathNode xPathNode) {
        this.validatingRecord.removeGroupingElement(xPathNode);
        this.marshalRecord.removeGroupingElement(xPathNode);
    }

    @Override
    public void add(DatabaseField key, Object value) {
        this.validatingRecord.add(key, value);
        this.marshalRecord.add(key, value);
    }

    @Override
    public Object put(DatabaseField key, Object value) {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        this.validatingRecord.namespaceDeclarations(namespaceResolver);
        this.marshalRecord.namespaceDeclarations(namespaceResolver);
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
        this.validatingRecord.startPrefixMapping(prefix, namespaceURI);
        this.marshalRecord.startPrefixMapping(prefix, namespaceURI);
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.validatingRecord.startPrefixMappings(namespaceResolver);
        this.marshalRecord.startPrefixMappings(namespaceResolver);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.validatingRecord.endPrefixMapping(prefix);
        this.marshalRecord.endPrefixMapping(prefix);
    }

    @Override
    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
        this.validatingRecord.endPrefixMappings(namespaceResolver);
        this.marshalRecord.endPrefixMappings(namespaceResolver);
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.openStartElement(xPathFragment, namespaceResolver);
        this.marshalRecord.openStartElement(xPathFragment, namespaceResolver);
    }

    @Override
    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        this.validatingRecord.openStartGroupingElements(namespaceResolver);
        return this.marshalRecord.openStartGroupingElements(namespaceResolver);
    }

    @Override
    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        this.validatingRecord.closeStartGroupingElements(groupingFragment);
        this.marshalRecord.closeStartGroupingElements(groupingFragment);
    }

    @Override
    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.validatingRecord.addPositionalNodes(xPathFragment, namespaceResolver);
        this.marshalRecord.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    @Override
    public void characters(String value) {
        this.validatingRecord.characters(value);
        this.marshalRecord.characters(value);
    }

    @Override
    public void cdata(String value) {
        this.validatingRecord.cdata(value);
        this.marshalRecord.cdata(value);
    }

    @Override
    public void node(Node node, NamespaceResolver resolver) {
        this.validatingRecord.node(node, resolver);
        this.marshalRecord.node(node, resolver);
    }

    @Override
    public String getLocalName() {
        return this.marshalRecord.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.marshalRecord.getNamespaceURI();
    }

    @Override
    public void clear() {
        this.validatingRecord.clear();
        this.marshalRecord.clear();
    }

    @Override
    public Document getDocument() {
        return this.marshalRecord.getDocument();
    }

    @Override
    public Element getDOM() {
        return this.marshalRecord.getDOM();
    }

    @Override
    public String transformToXML() {
        return this.marshalRecord.transformToXML();
    }

    @Override
    public boolean contains(Object value) {
        return this.marshalRecord.contains(value);
    }

    @Override
    public Object get(DatabaseField key) {
        return this.marshalRecord.get(key);
    }

    @Override
    public Object getIndicatingNoEntry(String fieldName) {
        return this.marshalRecord.getIndicatingNoEntry(fieldName);
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        return this.marshalRecord.resolveNamespacePrefix(prefix);
    }

    @Override
    public XMLMarshaller getMarshaller() {
        return this.marshalRecord.getMarshaller();
    }

    @Override
    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.validatingRecord.setMarshaller(marshaller);
        this.marshalRecord.setMarshaller(marshaller);
    }

    @Override
    public XMLUnmarshaller getUnmarshaller() {
        return this.marshalRecord.getUnmarshaller();
    }

    @Override
    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        this.validatingRecord.setUnmarshaller(unmarshaller);
        this.marshalRecord.setUnmarshaller(unmarshaller);
    }

    @Override
    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.validatingRecord.setDocPresPolicy(policy);
        this.marshalRecord.setDocPresPolicy(policy);
    }

    @Override
    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.marshalRecord.getDocPresPolicy();
    }

    @Override
    public Object getOwningObject() {
        return this.marshalRecord.getOwningObject();
    }

    @Override
    public void setOwningObject(Object obj) {
        this.validatingRecord.setOwningObject(obj);
        this.marshalRecord.setOwningObject(obj);
    }

    @Override
    public Object getCurrentObject() {
        return this.marshalRecord.getCurrentObject();
    }

    @Override
    public void setCurrentObject(Object obj) {
        this.marshalRecord.setCurrentObject(obj);
        this.validatingRecord.setCurrentObject(obj);
    }

    @Override
    public XPathQName getLeafElementType() {
        return this.marshalRecord.getLeafElementType();
    }

    @Override
    public void setLeafElementType(QName type) {
        this.validatingRecord.setLeafElementType(type);
        this.marshalRecord.setLeafElementType(type);
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver nr) {
        this.validatingRecord.setNamespaceResolver(nr);
        this.marshalRecord.setNamespaceResolver(nr);
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.marshalRecord.getNamespaceResolver();
    }

    @Override
    public AbstractSession getSession() {
        return this.marshalRecord.getSession();
    }

    @Override
    public void setSession(AbstractSession session) {
        super.setSession(session);
        this.validatingRecord.setSession(session);
        this.marshalRecord.setSession(session);
    }

    @Override
    public boolean isXOPPackage() {
        return this.marshalRecord.isXOPPackage();
    }

    @Override
    public void setXOPPackage(boolean isXOPPackage) {
        this.validatingRecord.setXOPPackage(isXOPPackage);
        this.marshalRecord.setXOPPackage(isXOPPackage);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.marshalRecord.containsKey(key);
    }

    @Override
    public boolean containsKey(String fieldName) {
        return this.marshalRecord.containsKey(fieldName);
    }

    @Override
    public boolean containsKey(DatabaseField key) {
        return this.marshalRecord.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.marshalRecord.containsValue(value);
    }

    @Override
    public Enumeration elements() {
        return this.marshalRecord.elements();
    }

    @Override
    public Set entrySet() {
        return this.marshalRecord.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.marshalRecord.get(key);
    }

    @Override
    public Object get(String fieldName) {
        return this.marshalRecord.get(fieldName);
    }

    @Override
    public Object getValues(DatabaseField key) {
        return this.marshalRecord.getValues(key);
    }

    @Override
    public Object getValues(String key) {
        return this.marshalRecord.getValues(key);
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        return this.marshalRecord.getIndicatingNoEntry(key);
    }

    @Override
    public DatabaseField getField(DatabaseField key) {
        return this.marshalRecord.getField(key);
    }

    @Override
    public Vector getFields() {
        return this.marshalRecord.getFields();
    }

    @Override
    public Vector getValues() {
        return this.marshalRecord.getValues();
    }

    @Override
    public boolean isEmpty() {
        return this.marshalRecord.isEmpty();
    }

    @Override
    public boolean hasNullValueInFields() {
        return this.marshalRecord.hasNullValueInFields();
    }

    @Override
    public Enumeration keys() {
        return this.marshalRecord.keys();
    }

    @Override
    public Set keySet() {
        return this.marshalRecord.keySet();
    }

    @Override
    public void mergeFrom(AbstractRecord row) {
        this.validatingRecord.mergeFrom(row);
        this.marshalRecord.mergeFrom(row);
    }

    @Override
    public Object put(Object key, Object value) throws ValidationException {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    @Override
    public Object put(String key, Object value) {
        this.validatingRecord.put(key, value);
        return this.marshalRecord.put(key, value);
    }

    @Override
    public void putAll(Map map) {
        this.validatingRecord.putAll(map);
        this.marshalRecord.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        this.validatingRecord.remove(key);
        return this.marshalRecord.remove(key);
    }

    @Override
    public Object remove(String fieldName) {
        this.validatingRecord.remove(fieldName);
        return this.marshalRecord.remove(fieldName);
    }

    @Override
    public Object remove(DatabaseField key) {
        this.validatingRecord.remove(key);
        return this.marshalRecord.remove(key);
    }

    @Override
    public void replaceAt(Object value, int index) {
        this.validatingRecord.replaceAt(value, index);
        this.marshalRecord.replaceAt(value, index);
    }

    @Override
    public void setNullValueInFields(boolean nullValueInFields) {
        this.validatingRecord.setNullValueInFields(nullValueInFields);
        this.marshalRecord.setNullValueInFields(nullValueInFields);
    }

    @Override
    public int size() {
        return this.marshalRecord.size();
    }

    @Override
    public Collection values() {
        return this.marshalRecord.values();
    }

    @Override
    public void beforeContainmentMarshal(Object child) {
        this.marshalRecord.beforeContainmentMarshal(child);
    }

    @Override
    public void afterContainmentMarshal(Object parent, Object child) {
        this.marshalRecord.afterContainmentMarshal(parent, child);
    }

    @Override
    public void writeHeader() {
        this.marshalRecord.writeHeader();
    }

    public static class MarshalSAXParseException
    extends SAXParseException {
        private Object object;

        public MarshalSAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber, Exception e, Object object) {
            super(message, publicId, systemId, lineNumber, columnNumber, e);
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }

    private static class ValidatingMarshalRecordErrorHandler
    implements ErrorHandler {
        private MarshalRecord marshalRecord;
        private ErrorHandler errorHandler;

        public ValidatingMarshalRecordErrorHandler(MarshalRecord marshalRecord, ErrorHandler errorHandler) {
            this.marshalRecord = marshalRecord;
            this.errorHandler = errorHandler;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (this.errorHandler == null) {
                throw exception;
            }
            this.errorHandler.warning(this.marshalSAXParseException(exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (this.errorHandler == null) {
                throw exception;
            }
            this.errorHandler.error(this.marshalSAXParseException(exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (this.errorHandler == null) {
                throw exception;
            }
            this.errorHandler.fatalError(this.marshalSAXParseException(exception));
        }

        private MarshalSAXParseException marshalSAXParseException(SAXParseException exception) {
            return new MarshalSAXParseException(exception.getLocalizedMessage(), exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getException(), this.marshalRecord.getOwningObject());
        }
    }
}

