/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;

public class OneToOneAccessor
extends ObjectAccessor {
    public OneToOneAccessor() {
        super("<one-to-one>");
    }

    public OneToOneAccessor(MetadataAnnotation oneToOne, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(oneToOne, annotatedElement, classAccessor);
        if (oneToOne != null) {
            this.setMappedBy((String)oneToOne.getAttribute("mappedBy"));
            this.setOrphanRemoval((Boolean)oneToOne.getAttribute("orphanRemoval"));
        }
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_one_to_one_reference_class";
    }

    @Override
    public boolean isOneToOne() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process() {
        super.process();
        ObjectReferenceMapping mapping = this.initOneToOneMapping();
        if (this.hasMappedBy()) {
            DatabaseMapping owningMapping = this.getOwningMapping();
            if (!owningMapping.isOneToOneMapping()) throw ValidationException.invalidMapping((Object)this.getJavaClass(), (Object)this.getReferenceClass());
            OneToOneMapping ownerMapping = (OneToOneMapping)owningMapping;
            if (ownerMapping.hasRelationTableMechanism()) {
                ((OneToOneMapping)mapping).setRelationTableMechanism(new RelationTableMechanism());
                this.processMappedByRelationTable(ownerMapping.getRelationTableMechanism(), ((OneToOneMapping)mapping).getRelationTableMechanism());
                return;
            } else {
                HashMap<DatabaseField, DatabaseField> sourceToTargetKeyFields;
                HashMap<DatabaseField, DatabaseField> targetToSourceKeyFields;
                if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
                    targetToSourceKeyFields = new HashMap<DatabaseField, DatabaseField>();
                    sourceToTargetKeyFields = new HashMap<DatabaseField, DatabaseField>();
                    for (DatabaseField fkField : ownerMapping.getSourceToTargetKeyFields().keySet()) {
                        DatabaseField pkField = ((DatabaseField)ownerMapping.getSourceToTargetKeyFields().get(fkField)).clone();
                        pkField.setTable(this.getDescriptor().getPrimaryTable());
                        sourceToTargetKeyFields.put(fkField, pkField);
                        targetToSourceKeyFields.put(pkField, fkField);
                    }
                } else {
                    targetToSourceKeyFields = ownerMapping.getTargetToSourceKeyFields();
                    sourceToTargetKeyFields = ownerMapping.getSourceToTargetKeyFields();
                }
                ((OneToOneMapping)mapping).setSourceToTargetKeyFields(targetToSourceKeyFields);
                ((OneToOneMapping)mapping).setTargetToSourceKeyFields(sourceToTargetKeyFields);
            }
            return;
        } else if (mapping instanceof OneToOneMapping) {
            this.processOwningMappingKeys((OneToOneMapping)mapping);
            return;
        } else {
            this.processForeignKeyRelationship((ForeignReferenceMapping)mapping);
        }
    }
}

