/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.services.concurrent;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.services.concurrent.ConcurrentLogEvents;
import org.eclipse.virgo.nano.services.concurrent.DeadlockAnalyser;
import org.eclipse.virgo.util.math.Sets;
import org.osgi.service.component.ComponentContext;

public final class DeadlockMonitor {
    private static final int PERIOD = 10;
    private static final TimeUnit UNIT = TimeUnit.SECONDS;
    private ScheduledExecutorService executorService;
    private DumpGenerator dumpGenerator;
    private EventLogger eventLogger;
    private volatile ScheduledFuture<?> future;

    public void activate(ComponentContext context) {
        this.executorService = new ScheduledThreadPoolExecutor(1);
        this.future = this.executorService.scheduleAtFixedRate(new DeadlockMonitorTask(this.dumpGenerator, this.eventLogger), 10L, 10L, UNIT);
    }

    public void deactivate(ComponentContext context) {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public DeadlockMonitor() {
    }

    public DeadlockMonitor(DumpGenerator dumpGenerator, EventLogger eventLogger) {
        this.dumpGenerator = dumpGenerator;
        this.eventLogger = eventLogger;
    }

    public void bindEventLogger(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    public void unbindEventLogger(EventLogger eventLogger) {
        this.eventLogger = null;
    }

    public void bindDumpGenerator(DumpGenerator dumpGenerator) {
        this.dumpGenerator = dumpGenerator;
    }

    public void unbindDumpGenerator(DumpGenerator dumpGenerator) {
        this.dumpGenerator = null;
    }

    private static class DeadlockMonitorTask
    implements Runnable {
        private final DeadlockAnalyser analyser = new DeadlockAnalyser();
        private final EventLogger eventLogger;
        private final Set<DeadlockAnalyser.Deadlock> lastSeenDeadlocks = new HashSet<DeadlockAnalyser.Deadlock>();
        private final Object monitor = new Object();
        private final DumpGenerator dumpGenerator;

        public DeadlockMonitorTask(DumpGenerator dumpGenerator, EventLogger eventLogger) {
            this.dumpGenerator = dumpGenerator;
            this.eventLogger = eventLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                Object[] deadlocks = this.analyser.findDeadlocks();
                if (deadlocks != null && deadlocks.length > 0) {
                    Set asSet = Sets.asSet((Object[])deadlocks);
                    if (!asSet.equals(this.lastSeenDeadlocks)) {
                        this.eventLogger.log((LogEvent)ConcurrentLogEvents.DEADLOCK_DETECTED, new Object[0]);
                        this.dumpGenerator.generateDump("deadlock", new Throwable[0]);
                        this.lastSeenDeadlocks.clear();
                        this.lastSeenDeadlocks.addAll(asSet);
                    }
                } else {
                    this.lastSeenDeadlocks.clear();
                }
            }
        }
    }
}

