/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.IBeanHasParent;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerFieldBean<T>
extends AbstractProducerBean<T>
implements IBeanHasParent<T> {
    private Field producerField = null;

    public ProducerFieldBean(InjectionTargetBean<?> ownerComponent, Class<T> returnType) {
        super(WebBeansType.PRODUCERFIELD, returnType, ownerComponent);
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        T instance = null;
        instance = this.createDefaultInstance(creationalContext);
        this.checkNullInstance(instance);
        this.checkScopeType();
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected T createDefaultInstance(CreationalContext<T> creationalContext) {
        Object instance = null;
        Object parentInstance = null;
        CreationalContext parentCreational = null;
        try {
            parentCreational = this.getManager().createCreationalContext(this.ownerComponent);
            if (!this.producerField.isAccessible()) {
                this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.producerField, true);
            }
            if (Modifier.isStatic(this.producerField.getModifiers())) {
                instance = this.producerField.get(null);
            } else {
                parentInstance = this.getParentInstanceFromContext(parentCreational);
                instance = this.producerField.get(parentInstance);
            }
            if (!this.ownerComponent.getScope().equals(Dependent.class)) return (T)instance;
        }
        catch (Exception e) {
            try {
                throw new WebBeansException(e);
            }
            catch (Throwable throwable) {
                if (!this.ownerComponent.getScope().equals(Dependent.class)) throw throwable;
                this.destroyBean(this.ownerComponent, parentInstance, parentCreational);
                throw throwable;
            }
        }
        this.destroyBean(this.ownerComponent, parentInstance, parentCreational);
        return (T)instance;
    }

    public Field getCreatorField() {
        return this.producerField;
    }

    public void setProducerField(Field field) {
        this.producerField = field;
    }

    protected void checkNullInstance(Object instance) {
        String errorMessage = "WebBeans producer field : %s return type in the component implementation class : %s scope must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage, this.producerField.getName(), this.ownerComponent.getReturnType().getName());
    }

    protected void checkScopeType() {
        String errorMessage = "WebBeans producer method : %s return type in the component implementation class : %s with passivating scope @%s must be Serializable";
        this.getWebBeansContext().getWebBeansUtil().checkSerializableScopeType(this.getScope(), this.isSerializable(), errorMessage, this.producerField.getName(), this.ownerComponent.getReturnType().getName(), this.getScope().getName());
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable(this.producerField.getType(), this.producerField.getModifiers());
    }

    @Override
    public String getId() {
        if (this.passivatingId == null) {
            String id = super.getId();
            this.passivatingId = id + "#" + this.producerField.toGenericString();
        }
        return this.passivatingId;
    }
}

