/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.app.spring;

import org.eclipse.virgo.kernel.module.Component;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.NoSuchComponentException;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;

final class ModuleContextWrapper
implements ModuleContext {
    private final ConfigurableApplicationContext appCtx;

    ModuleContextWrapper(ConfigurableApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    public Object getApplicationContext() {
        return this.appCtx;
    }

    public Component getComponent(final String componentName) throws NoSuchComponentException {
        try {
            final Object component = this.appCtx.getBean(componentName);
            return new Component(){

                public String getName() {
                    return componentName;
                }

                public String getType() {
                    return component.getClass().getName();
                }

                public boolean isPrototype() {
                    return ModuleContextWrapper.this.appCtx.getBeanFactory().isPrototype(componentName);
                }

                public boolean isSingleton() {
                    return ModuleContextWrapper.this.appCtx.getBeanFactory().isSingleton(componentName);
                }
            };
        }
        catch (BeansException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
    }

    public String[] getComponentNames() {
        return this.appCtx.getBeanDefinitionNames();
    }

    public String getDisplayName() {
        return this.appCtx.getDisplayName();
    }
}

