/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap.client.templates;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ClientTemplate
implements IFileTemplate<InformationModel> {
    private String targetPath;
    private String classPackage;

    public ClientTemplate(String targetPath, String classPackage) {
        this.targetPath = targetPath;
        this.classPackage = classPackage;
    }

    public String getFileName(InformationModel context) {
        return "Client.java";
    }

    public String getPath(InformationModel context) {
        return this.targetPath;
    }

    public String getContent(InformationModel context, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.classPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import com.fasterxml.jackson.core.JsonProcessingException;");
        _builder.newLine();
        _builder.append((Object)"import com.fasterxml.jackson.databind.ObjectMapper;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.CoapResponse;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.MediaTypeRegistry;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.Request;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.californium.core.coap.Response;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class Client {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static int ct = MediaTypeRegistry.APPLICATION_JSON;");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static Response sendRequest(String uri, CoapMethod method, byte[] payload){");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final Request request = newRequest(method);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (request == null) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// TODO: 02.02.16 define error code");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"request.setURI(uri);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"request.setPayload(payload);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"request.getOptions().setContentFormat(ct);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"request.send();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Response response;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"response = request.waitForResponse();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// TODO: 02.02.16 define error handling");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return response;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static Response sendRequest(String uri, CoapMethod method){");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"final Request request = newRequest(method);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if (request == null) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// TODO: 02.02.16 define error code");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"request.setURI(uri);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"request.send();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Response response;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"response = request.waitForResponse();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"// TODO: 02.02.16 define error handling");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return response;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static boolean isValidResponseWithPayload(Response response){");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if(response != null) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"if (response.getCode().value < 100) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"if (response.getPayload() != null) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"if(response.getPayloadSize() >0 ){");
        _builder.newLine();
        _builder.append((Object)"                        ");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static boolean isValidResponseWithPayload(CoapResponse response){");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if(response != null) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"if (response.getCode().value < 100) {");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"if (response.getPayload() != null) {");
        _builder.newLine();
        _builder.append((Object)"                    ");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"private static Request newRequest(CoapMethod method) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"switch (method) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case GET:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return Request.newGet();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case POST:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return Request.newPost();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case PUT:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return Request.newPut();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case DELETE:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return Request.newDelete();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case OBSERVE:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"Request request = Request.newGet();");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"request.setObserve();");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return request;");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"case DISCOVER:");
        _builder.newLine();
        _builder.append((Object)"                ");
        _builder.append((Object)"return Request.newGet();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Collection of available transformer to deserialize payload for CoAP");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param valueType   POJO class");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param payload     serialized data");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return object representation of data");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static Object deserializePayload(Class<?> valueType, byte[] payload) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"ObjectMapper mapper = new ObjectMapper();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object value = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"value = mapper.readValue(payload, valueType);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (IOException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return value;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* Collection of available transformers to serialize payload for CoAP");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @param value       object representation of data");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* @return serialized representation of data");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public static byte[] serializePayload(Object value) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"ObjectMapper mapper = new ObjectMapper();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"byte[] serialized = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"serialized = mapper.writeValueAsBytes(value);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"} catch (JsonProcessingException e) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"e.printStackTrace();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return serialized;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

