/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.DatatypePackage;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelPackage;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.vorto.editor.datatype.validation.AbstractDatatypeValidator;
import org.eclipse.vorto.editor.datatype.validation.ConstraintValidatorFactory;
import org.eclipse.vorto.editor.datatype.validation.PropertyConstraintMappingValidation;
import org.eclipse.vorto.editor.datatype.validation.ValidatorUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DatatypeValidator
extends AbstractDatatypeValidator {
    public final PropertyConstraintMappingValidation propertyValidator = new PropertyConstraintMappingValidation();

    @Check
    public void checkCircularRefInObjectPropertyType(ObjectPropertyType ref) {
        boolean _notEquals;
        Type _type = ref.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            try {
                Type _type_1;
                boolean _hasCircularReference;
                boolean _notEquals_1;
                EObject _parentOfType = ValidatorUtils.getParentOfType((EObject)ref, Model.class);
                Model parent = (Model)_parentOfType;
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)parent, null);
                if (_notEquals_1 && (_hasCircularReference = ValidatorUtils.hasCircularReference(parent, (Model)(_type_1 = ref.getType()), ValidatorUtils.entityTypeToChildrenSupplierFunction))) {
                    this.error("Object property type has circular reference", (EObject)ref, (EStructuralFeature)DatatypePackage.Literals.OBJECT_PROPERTY_TYPE__TYPE);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkCircularRefInSuperType(Entity entity) {
        boolean _notEquals;
        Entity _superType = entity.getSuperType();
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            try {
                Entity _superType_1 = entity.getSuperType();
                boolean _hasCircularReference = ValidatorUtils.hasCircularReference((Model)entity, (Model)_superType_1, ValidatorUtils.entityTypeToChildrenSupplierFunction);
                if (_hasCircularReference) {
                    this.error("Super type has circular reference", (EObject)entity, (EStructuralFeature)DatatypePackage.Literals.ENTITY__SUPER_TYPE);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkConstraint(Property prop) {
        boolean _equals;
        ConstraintRule _constraintRule = prop.getConstraintRule();
        EList constraints = _constraintRule.getConstraints();
        EList _converted_constraints = constraints;
        int _length = ((Object[])Conversions.unwrapArray((Object)_converted_constraints, Object.class)).length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return;
        }
        PropertyType _type = prop.getType();
        PrimitivePropertyType primi = (PrimitivePropertyType)_type;
        boolean isMultiplcity = prop.isMultiplicity();
        for (Constraint constraint : constraints) {
            this.verifyConstraintForType(primi, constraint, isMultiplcity);
        }
    }

    public void verifyConstraintForType(PrimitivePropertyType primitivePropertyType, Constraint constraint, boolean isMultiplcity) {
        boolean _not;
        PrimitiveType _type = primitivePropertyType.getType();
        boolean _isValidConstraintType = this.isValidConstraintType(_type, constraint);
        boolean bl = _not = !_isValidConstraintType;
        if (_not) {
            String _errorMessage = this.propertyValidator.getErrorMessage();
            this.error(_errorMessage, (EObject)constraint, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__TYPE);
        } else {
            boolean _not_1;
            PrimitiveType _type_2;
            ConstraintIntervalType _type_1 = constraint.getType();
            ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator(_type_1);
            boolean _isValidConstraintValue = this.isValidConstraintValue(validator, _type_2 = primitivePropertyType.getType(), constraint);
            boolean bl2 = _not_1 = !_isValidConstraintValue;
            if (_not_1) {
                String _errorMessage_1 = validator.getErrorMessage();
                this.error(_errorMessage_1, (EObject)constraint, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__CONSTRAINT_VALUES);
            }
        }
        PrimitiveType _type_3 = primitivePropertyType.getType();
        String _name = _type_3.getName();
        boolean _isMimeConstraint = this.isMimeConstraint(_name, constraint);
        if (_isMimeConstraint && !isMultiplcity) {
            this.error("MIMEType only applies to byte array, have you forgotten to add 'multiple' ?", (EObject)constraint, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__TYPE);
        }
    }

    public boolean isValidConstraintType(PrimitiveType primitiveType, Constraint constraint) {
        return this.propertyValidator.checkPropertyConstraints(primitiveType, constraint);
    }

    public boolean isValidConstraintValue(ConstraintValueValidator validator, PrimitiveType primitiveType, Constraint constraint) {
        return validator.evaluateValueType(primitiveType, constraint);
    }

    public boolean isMimeConstraint(String primitiveTypeName, Constraint constraint) {
        boolean _equals_1;
        boolean _and = false;
        ConstraintIntervalType _type = constraint.getType();
        String _literal = _type.getLiteral();
        boolean _equals = Objects.equal((Object)"MIMETYPE", (Object)_literal);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)"byte", (Object)primitiveTypeName));
        return _and;
    }

    @Check
    public void checkEnumName_Literal(Enum ent) {
        String name = ent.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Enum name must begin with a capital letter", (EObject)ent, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    @Check
    public void checkDuplicatedLiteral(Enum enu) {
        EList list = enu.getEnums();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)list, Object.class)).length) {
            boolean _not;
            EnumLiteral _get = (EnumLiteral)list.get(i);
            String _name = _get.getName();
            boolean _add = set.add(_name);
            boolean bl = _not = !_add;
            if (_not) {
                EnumLiteral _get_1 = (EnumLiteral)list.get(i);
                this.error("Enumeration literal has been defined", (EObject)_get_1, (EStructuralFeature)DatatypePackage.Literals.ENUM_LITERAL__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkDuplicatedConstraint(Property feature) {
        HashSet<String> set = new HashSet<String>();
        ConstraintRule _constraintRule = feature.getConstraintRule();
        EList list = _constraintRule.getConstraints();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)list, Object.class)).length) {
            boolean _not;
            Constraint con = (Constraint)list.get(i);
            ConstraintIntervalType _type = con.getType();
            String _literal = _type.getLiteral();
            boolean _add = set.add(_literal);
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Constraint Type has been defined", (EObject)con, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__TYPE);
            }
            ++i;
        }
    }

    @Check
    public void checkEntityName(Entity entity) {
        String name = entity.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Entity name must begin with a capital letter", (EObject)entity, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    public boolean isCamelCasedName(String name) {
        char _charAt = name.charAt(0);
        boolean _isUpperCase = Character.isUpperCase(_charAt);
        return !_isUpperCase;
    }

    public void checkDuplicatedProperty(List<Property> props) {
        HashSet<String> set = new HashSet<String>();
        for (Property pp : props) {
            boolean _not;
            String _name = pp.getName();
            boolean _add = set.add(_name);
            boolean bl = _not = !_add;
            if (!_not) continue;
            this.error("Property name has been defined", (EObject)pp, (EStructuralFeature)DatatypePackage.Literals.PROPERTY__NAME);
        }
    }

    @Check
    public void checkPropertyName(Property property) {
        String name = property.getName();
        boolean _endsWith = name.endsWith("TS");
        if (_endsWith) {
            this.error("Invalid property name with suffix \"TS\"", (EObject)property, (EStructuralFeature)DatatypePackage.Literals.PROPERTY__NAME);
        }
    }
}

