/*******************************************************************************
 * Copyright (c) 2015 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *   
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *   
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.examples.coap.common.templates

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.codegen.api.InvocationContext
import org.eclipse.vorto.codegen.examples.coap.CoAPUtils
import org.eclipse.vorto.core.api.model.datatype.Property

class JavaFBPropertyPrimitiveParamWrapperTemplate implements ITemplate<Property>{
		
		var String className;
		var String classPackage;
		
	new(
		String className,
		String classPackage
	) {
		this.className = className;
		this.classPackage = classPackage;
	}
	
	override getContent(Property property,InvocationContext invocationContext) {
		'''
			/*
			*****************************************************************************************
			* The present code has been generated by the Eclipse Vorto CoAP Code Generator.
			*
			* The basis for the generation was the Information Model which is uniquely identified by:
			* Name:			« property.name »
			* Namespace:	«classPackage»
			* Version:		
			*****************************************************************************************
			*/
			
			package «classPackage»;
			
			
			public class «className.toFirstUpper» {
				
				
				private «CoAPUtils.getPropertyTypeAsString(property)» value;
				
				public «CoAPUtils.getPropertyTypeAsString(property)» getValue() {
					return this.value;
				}
				
				public void setValue(«CoAPUtils.getPropertyTypeAsString(property)» value) {
					this.value = value; 
				}
				
			}
			'''
	}
}