/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.aws;

import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.aws.templates.alexa.AlexaIndentSchemaTemplate;
import org.eclipse.vorto.codegen.examples.aws.templates.alexa.AlexaSkillLambdaTemplate;
import org.eclipse.vorto.codegen.examples.aws.templates.alexa.AlexaSlotTypeTemplate;
import org.eclipse.vorto.codegen.examples.aws.templates.alexa.AlexaUtterancesTemplate;
import org.eclipse.vorto.codegen.examples.aws.templates.shadow.ThingShadowForOperationsTask;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class AWSGenerator
implements IVortoCodeGenerator {
    public IGenerationResult generate(InformationModel infomodel, InvocationContext context) {
        String _serviceKey = this.getServiceKey();
        GenerationResultZip output = new GenerationResultZip(infomodel, _serviceKey);
        ChainedCodeGeneratorTask chainedGenerators = new ChainedCodeGeneratorTask();
        ThingShadowForOperationsTask _thingShadowForOperationsTask = new ThingShadowForOperationsTask();
        chainedGenerators.addTask((ICodeGeneratorTask)_thingShadowForOperationsTask);
        AlexaIndentSchemaTemplate _alexaIndentSchemaTemplate = new AlexaIndentSchemaTemplate();
        GeneratorTaskFromFileTemplate _generatorTaskFromFileTemplate = new GeneratorTaskFromFileTemplate((IFileTemplate)_alexaIndentSchemaTemplate);
        chainedGenerators.addTask((ICodeGeneratorTask)_generatorTaskFromFileTemplate);
        AlexaSkillLambdaTemplate _alexaSkillLambdaTemplate = new AlexaSkillLambdaTemplate();
        GeneratorTaskFromFileTemplate _generatorTaskFromFileTemplate_1 = new GeneratorTaskFromFileTemplate((IFileTemplate)_alexaSkillLambdaTemplate);
        chainedGenerators.addTask((ICodeGeneratorTask)_generatorTaskFromFileTemplate_1);
        AlexaUtterancesTemplate _alexaUtterancesTemplate = new AlexaUtterancesTemplate();
        GeneratorTaskFromFileTemplate _generatorTaskFromFileTemplate_2 = new GeneratorTaskFromFileTemplate((IFileTemplate)_alexaUtterancesTemplate);
        chainedGenerators.addTask((ICodeGeneratorTask)_generatorTaskFromFileTemplate_2);
        chainedGenerators.generate((Object)infomodel, context, (IGeneratedWriter)output);
        this.generateCustomSlotTypes(infomodel, context, (IGeneratedWriter)output);
        return output;
    }

    public void generateCustomSlotTypes(InformationModel infomodel, InvocationContext context, IGeneratedWriter output) {
        EList _properties = infomodel.getProperties();
        for (FunctionblockProperty fbModel : _properties) {
            FunctionblockModel _type = fbModel.getType();
            FunctionBlock _functionblock = _type.getFunctionblock();
            EList enums = Utils.getReferencedEnums((FunctionBlock)_functionblock);
            for (Enum enumeration : enums) {
                AlexaSlotTypeTemplate _alexaSlotTypeTemplate = new AlexaSlotTypeTemplate();
                GeneratorTaskFromFileTemplate _template = new GeneratorTaskFromFileTemplate((IFileTemplate)_alexaSlotTypeTemplate);
                _template.generate((Object)enumeration, context, output);
            }
        }
    }

    public String getServiceKey() {
        return "aws";
    }
}

