/*******************************************************************************
 * Copyright (c) 2016 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *  
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *  
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.prosystfi.templates

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.codegen.api.InvocationContext
import org.eclipse.vorto.core.api.model.datatype.Entity
import org.eclipse.vorto.core.api.model.datatype.Enum
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType
import org.eclipse.vorto.codegen.prosystfi.tasks.FunctionalItemImplGeneratorTask

class FunctionalItemImplTemplate implements ITemplate<FunctionblockModel>{
	
	var String fiPackage;
	var String[] imports;
	
	new(String fiPackage, String... imports) {
		this.fiPackage = fiPackage;
		this.imports = imports;
	}
	
	override getContent(FunctionblockModel fbm, InvocationContext ctx) {
		'''
/*
*****************************************************************************************
* The present code has been generated by the Eclipse Vorto ProSyst Code Generator.
*
* The basis for the generation was the Functionblock which is uniquely identified by:
* Name:			«fbm.name»
* Namespace:	«fbm.namespace»
* Version:		«fbm.version»
*****************************************************************************************
*/

package «fiPackage»;

import java.util.Collections;
import java.util.Map;

«FOR imprt : imports»
	import «imprt».*;
«ENDFOR»
import com.prosyst.mbs.services.fim.FunctionalItem;
import com.prosyst.mbs.services.fim.FunctionalItemFactory;
import com.prosyst.mbs.services.fim.spi.AbstractFunctionalItem;

/**
* This is a implementation class for the functional item «fbm.name.toFirstUpper».
*/
public class «fbm.name.toFirstUpper»«FunctionalItemImplGeneratorTask.SUFFIX» extends AbstractFunctionalItem implements «fbm.name.toFirstUpper» {
	
	/**
	* The default UID for this functional item.
	*/
	public static final String UID = "«fbm.namespace»:«fbm.name»:«fbm.version»";
	
	/**
	* This map contains the available attributes.
	*/
	private Map<String, ?> attributes;
	
	«var FunctionBlock fb = fbm.functionblock»
	«IF fb.status != null»
		«FOR property : fb.status.properties»
			/**
			* «property.description»
			*/
			«IF property.type instanceof PrimitivePropertyType»		
				private «(property.type as PrimitivePropertyType).type.getName()» «property.name»;
			«ELSEIF property.type instanceof ObjectPropertyType»
				«var objectProperty = property.type as ObjectPropertyType»
				«IF objectProperty.type instanceof Entity»
					private «(objectProperty.type as Entity).name» «property.name»;
				«ELSEIF objectProperty.type instanceof Enum»
					private «(objectProperty.type as Enum).name» «property.name»;
				«ENDIF»
			«ENDIF»
			
		«ENDFOR»
	«ENDIF»
	«IF fb.configuration != null»
		«FOR property : fb.configuration.properties»
			/**
			* «property.description»
			*/
			«IF property.type instanceof PrimitivePropertyType»		
				private «(property.type as PrimitivePropertyType).type.getName()» «property.name»;
			«ELSEIF property.type instanceof ObjectPropertyType»
				«var objectProperty = property.type as ObjectPropertyType»
				«IF objectProperty.type instanceof Entity»
					private «(objectProperty.type as Entity).name» «property.name»;
				«ELSEIF objectProperty.type instanceof Enum»
					private «(objectProperty.type as Enum).name» «property.name»;
				«ENDIF»
			«ENDIF»
			
		«ENDFOR»
	«ENDIF»
	«IF fb.fault != null»
		«FOR property : fb.fault.properties»
			/**
			* «property.description»
			*/
			«IF property.type instanceof PrimitivePropertyType»		
				private «(property.type as PrimitivePropertyType).type.getName()» «property.name»;
			«ELSEIF property.type instanceof ObjectPropertyType»
				«var objectProperty = property.type as ObjectPropertyType»
				«IF objectProperty.type instanceof Entity»
					private «(objectProperty.type as Entity).name» «property.name»;
				«ELSEIF objectProperty.type instanceof Enum»
					private «(objectProperty.type as Enum).name» «property.name»;
				«ENDIF»
			«ENDIF»
			
		«ENDFOR»
	«ENDIF»
	/**
	* Creates a «fbm.name.toFirstUpper» functional item instance.
	*/
	public «fbm.name.toFirstUpper»«FunctionalItemImplGeneratorTask.SUFFIX»() {
    	this(UID);
  	}
  	
  	/**
	* Creates a «fbm.name.toFirstUpper» functional item instance with a provided unique id.
	*/
	public «fbm.name.toFirstUpper»«FunctionalItemImplGeneratorTask.SUFFIX»(String uid) {
    	super(uid);
    	this.attributes = Collections.emptyMap();
  	}
  	
	«FOR operation : fb.operations»
		/**
		* «operation.description»
		*/
		«IF operation.returnType == null»
			public void «operation.name»() {
				//Add your application code here.
			}
		«ELSE»
			«IF operation.returnType instanceof ReturnObjectType»
				«var type = (operation.returnType as ReturnObjectType).returnType»
				«IF type instanceof Entity»
					public «(type as Entity).name» «operation.name»() {
						//Add your application code here.
						return new «(type as Entity).name»();
					}
				«ELSEIF type instanceof Enum»
					public «(type as Enum).name» «operation.name»() {
						//Add your application code here.
						return «(type as Enum).name».«((type as Enum).enums.get(0) as EnumLiteral).name.toUpperCase»;
					}
				«ENDIF»
			«ELSEIF operation.returnType instanceof ReturnPrimitiveType»
					«var PrimitiveType type = (operation.returnType as ReturnPrimitiveType).returnType»
					public «type.getName» «operation.name»() {
						//Add your application code here.
						«type.getName» value;
						return value;
					}
			«ENDIF»
		«ENDIF»
	«ENDFOR»
}
'''
	}
}