/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.context.IModelProjectContext;
import org.eclipse.vorto.codegen.ui.progresstask.IProgressTask;
import org.eclipse.vorto.codegen.ui.tasks.EclipseProjectGenerator;
import org.eclipse.vorto.codegen.ui.tasks.LocationWrapper;
import org.eclipse.vorto.core.ui.model.IModelProject;

public abstract class ProjectCreationTask
implements IProgressTask {
    public static final String WORK_SPACE = "WorkSpace";
    public static final String PROJECT_NAME = "ProjectName";
    private String errorMessage = "";
    private String projectName;
    private String workspaceLocation;
    public static final String XTEXT_NATURE = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String TARGET_JAVA_CLASS_FOLDER = "target/classes";
    public static final String ADDITIONAL_SOURCES_FOLDER = "target/generated-sources";
    private IModelProjectContext context = null;
    private IProject iproject = null;

    public ProjectCreationTask(IModelProjectContext context) {
        this.projectName = context.getProjectName();
        this.workspaceLocation = context.getWorkspaceLocation();
        this.context = context;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            EclipseProjectGenerator generator = new EclipseProjectGenerator(new LocationWrapper(this.workspaceLocation, this.projectName));
            generator.addNature(XTEXT_NATURE);
            String[] stringArray = this.getProjectNature();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                generator.addNature(nature);
                ++n2;
            }
            generator.addTask(this.getCodeGeneratorTask());
            generator.generate((Object)this.context, InvocationContext.simpleInvocationContext(), monitor);
            this.setIproject(generator.getProject());
            IModelProject modelProject = this.getIotproject(generator.getProject());
            modelProject.refresh(monitor);
            this.fireRefreshEvent(modelProject);
        }
        finally {
            monitor.done();
        }
    }

    private void fireRefreshEvent(IModelProject modelProject) {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public void setWorkspaceLocation(String workspaceLocation) {
        this.workspaceLocation = workspaceLocation;
    }

    protected abstract IModelProject getIotproject(IProject var1);

    protected abstract ICodeGeneratorTask<IModelProjectContext> getCodeGeneratorTask();

    protected abstract String[] getProjectNature();

    public IProject getIproject() {
        return this.iproject;
    }

    protected void setIproject(IProject iproject) {
        this.iproject = iproject;
    }
}

