/*******************************************************************************
 * Copyright (c) 2014 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *
 *******************************************************************************/
/*
 * generated by Xtext
 */
grammar InternalInformationModel;

options {
	superClass=AbstractInternalContentAssistParser;
}

@lexer::header {
package org.eclipse.vorto.editor.infomodel.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package org.eclipse.vorto.editor.infomodel.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.vorto.editor.infomodel.services.InformationModelGrammarAccess;

}
@parser::members {
	private InformationModelGrammarAccess grammarAccess;

	public void setGrammarAccess(InformationModelGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleInformationModel
entryRuleInformationModel
:
{ before(grammarAccess.getInformationModelRule()); }
	 ruleInformationModel
{ after(grammarAccess.getInformationModelRule()); } 
	 EOF 
;

// Rule InformationModel
ruleInformationModel 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInformationModelAccess().getGroup()); }
		(rule__InformationModel__Group__0)
		{ after(grammarAccess.getInformationModelAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionblockProperty
entryRuleFunctionblockProperty
:
{ before(grammarAccess.getFunctionblockPropertyRule()); }
	 ruleFunctionblockProperty
{ after(grammarAccess.getFunctionblockPropertyRule()); } 
	 EOF 
;

// Rule FunctionblockProperty
ruleFunctionblockProperty 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getGroup()); }
		(rule__FunctionblockProperty__Group__0)
		{ after(grammarAccess.getFunctionblockPropertyAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionBlock
entryRuleFunctionBlock
:
{ before(grammarAccess.getFunctionBlockRule()); }
	 ruleFunctionBlock
{ after(grammarAccess.getFunctionBlockRule()); } 
	 EOF 
;

// Rule FunctionBlock
ruleFunctionBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionBlockAccess().getGroup()); }
		(rule__FunctionBlock__Group__0)
		{ after(grammarAccess.getFunctionBlockAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConfiguration
entryRuleConfiguration
:
{ before(grammarAccess.getConfigurationRule()); }
	 ruleConfiguration
{ after(grammarAccess.getConfigurationRule()); } 
	 EOF 
;

// Rule Configuration
ruleConfiguration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConfigurationAccess().getGroup()); }
		(rule__Configuration__Group__0)
		{ after(grammarAccess.getConfigurationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatus
entryRuleStatus
:
{ before(grammarAccess.getStatusRule()); }
	 ruleStatus
{ after(grammarAccess.getStatusRule()); } 
	 EOF 
;

// Rule Status
ruleStatus 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatusAccess().getGroup()); }
		(rule__Status__Group__0)
		{ after(grammarAccess.getStatusAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFault
entryRuleFault
:
{ before(grammarAccess.getFaultRule()); }
	 ruleFault
{ after(grammarAccess.getFaultRule()); } 
	 EOF 
;

// Rule Fault
ruleFault 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFaultAccess().getGroup()); }
		(rule__Fault__Group__0)
		{ after(grammarAccess.getFaultAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOperation
entryRuleOperation
:
{ before(grammarAccess.getOperationRule()); }
	 ruleOperation
{ after(grammarAccess.getOperationRule()); } 
	 EOF 
;

// Rule Operation
ruleOperation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOperationAccess().getGroup()); }
		(rule__Operation__Group__0)
		{ after(grammarAccess.getOperationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnType
entryRuleReturnType
:
{ before(grammarAccess.getReturnTypeRule()); }
	 ruleReturnType
{ after(grammarAccess.getReturnTypeRule()); } 
	 EOF 
;

// Rule ReturnType
ruleReturnType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnTypeAccess().getAlternatives()); }
		(rule__ReturnType__Alternatives)
		{ after(grammarAccess.getReturnTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnDictonaryType
entryRuleReturnDictonaryType
:
{ before(grammarAccess.getReturnDictonaryTypeRule()); }
	 ruleReturnDictonaryType
{ after(grammarAccess.getReturnDictonaryTypeRule()); } 
	 EOF 
;

// Rule ReturnDictonaryType
ruleReturnDictonaryType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnDictonaryTypeAccess().getGroup()); }
		(rule__ReturnDictonaryType__Group__0)
		{ after(grammarAccess.getReturnDictonaryTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnObjectType
entryRuleReturnObjectType
:
{ before(grammarAccess.getReturnObjectTypeRule()); }
	 ruleReturnObjectType
{ after(grammarAccess.getReturnObjectTypeRule()); } 
	 EOF 
;

// Rule ReturnObjectType
ruleReturnObjectType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnObjectTypeAccess().getGroup()); }
		(rule__ReturnObjectType__Group__0)
		{ after(grammarAccess.getReturnObjectTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnPrimitiveType
entryRuleReturnPrimitiveType
:
{ before(grammarAccess.getReturnPrimitiveTypeRule()); }
	 ruleReturnPrimitiveType
{ after(grammarAccess.getReturnPrimitiveTypeRule()); } 
	 EOF 
;

// Rule ReturnPrimitiveType
ruleReturnPrimitiveType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnPrimitiveTypeAccess().getGroup()); }
		(rule__ReturnPrimitiveType__Group__0)
		{ after(grammarAccess.getReturnPrimitiveTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDictonaryParam
entryRuleDictonaryParam
:
{ before(grammarAccess.getDictonaryParamRule()); }
	 ruleDictonaryParam
{ after(grammarAccess.getDictonaryParamRule()); } 
	 EOF 
;

// Rule DictonaryParam
ruleDictonaryParam 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDictonaryParamAccess().getGroup()); }
		(rule__DictonaryParam__Group__0)
		{ after(grammarAccess.getDictonaryParamAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveParam
entryRulePrimitiveParam
:
{ before(grammarAccess.getPrimitiveParamRule()); }
	 rulePrimitiveParam
{ after(grammarAccess.getPrimitiveParamRule()); } 
	 EOF 
;

// Rule PrimitiveParam
rulePrimitiveParam 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveParamAccess().getGroup()); }
		(rule__PrimitiveParam__Group__0)
		{ after(grammarAccess.getPrimitiveParamAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRefParam
entryRuleRefParam
:
{ before(grammarAccess.getRefParamRule()); }
	 ruleRefParam
{ after(grammarAccess.getRefParamRule()); } 
	 EOF 
;

// Rule RefParam
ruleRefParam 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRefParamAccess().getGroup()); }
		(rule__RefParam__Group__0)
		{ after(grammarAccess.getRefParamAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParam
entryRuleParam
:
{ before(grammarAccess.getParamRule()); }
	 ruleParam
{ after(grammarAccess.getParamRule()); } 
	 EOF 
;

// Rule Param
ruleParam 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParamAccess().getAlternatives()); }
		(rule__Param__Alternatives)
		{ after(grammarAccess.getParamAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEvent
entryRuleEvent
:
{ before(grammarAccess.getEventRule()); }
	 ruleEvent
{ after(grammarAccess.getEventRule()); } 
	 EOF 
;

// Rule Event
ruleEvent 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEventAccess().getGroup()); }
		(rule__Event__Group__0)
		{ after(grammarAccess.getEventAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleModelReference
entryRuleModelReference
:
{ before(grammarAccess.getModelReferenceRule()); }
	 ruleModelReference
{ after(grammarAccess.getModelReferenceRule()); } 
	 EOF 
;

// Rule ModelReference
ruleModelReference 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getModelReferenceAccess().getGroup()); }
		(rule__ModelReference__Group__0)
		{ after(grammarAccess.getModelReferenceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleQualifiedName
entryRuleQualifiedName
:
{ before(grammarAccess.getQualifiedNameRule()); }
	 ruleQualifiedName
{ after(grammarAccess.getQualifiedNameRule()); } 
	 EOF 
;

// Rule QualifiedName
ruleQualifiedName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getQualifiedNameAccess().getGroup()); }
		(rule__QualifiedName__Group__0)
		{ after(grammarAccess.getQualifiedNameAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleType
entryRuleType
:
{ before(grammarAccess.getTypeRule()); }
	 ruleType
{ after(grammarAccess.getTypeRule()); } 
	 EOF 
;

// Rule Type
ruleType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeAccess().getAlternatives()); }
		(rule__Type__Alternatives)
		{ after(grammarAccess.getTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEntity
entryRuleEntity
:
{ before(grammarAccess.getEntityRule()); }
	 ruleEntity
{ after(grammarAccess.getEntityRule()); } 
	 EOF 
;

// Rule Entity
ruleEntity 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEntityAccess().getGroup()); }
		(rule__Entity__Group__0)
		{ after(grammarAccess.getEntityAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnum
entryRuleEnum
:
{ before(grammarAccess.getEnumRule()); }
	 ruleEnum
{ after(grammarAccess.getEnumRule()); } 
	 EOF 
;

// Rule Enum
ruleEnum 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumAccess().getGroup()); }
		(rule__Enum__Group__0)
		{ after(grammarAccess.getEnumAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnumLiteral
entryRuleEnumLiteral
:
{ before(grammarAccess.getEnumLiteralRule()); }
	 ruleEnumLiteral
{ after(grammarAccess.getEnumLiteralRule()); } 
	 EOF 
;

// Rule EnumLiteral
ruleEnumLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumLiteralAccess().getGroup()); }
		(rule__EnumLiteral__Group__0)
		{ after(grammarAccess.getEnumLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleProperty
entryRuleProperty
:
{ before(grammarAccess.getPropertyRule()); }
	 ruleProperty
{ after(grammarAccess.getPropertyRule()); } 
	 EOF 
;

// Rule Property
ruleProperty 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyAccess().getGroup()); }
		(rule__Property__Group__0)
		{ after(grammarAccess.getPropertyAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConstraintRule
entryRuleConstraintRule
:
{ before(grammarAccess.getConstraintRuleRule()); }
	 ruleConstraintRule
{ after(grammarAccess.getConstraintRuleRule()); } 
	 EOF 
;

// Rule ConstraintRule
ruleConstraintRule 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConstraintRuleAccess().getGroup()); }
		(rule__ConstraintRule__Group__0)
		{ after(grammarAccess.getConstraintRuleAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyAttribute
entryRulePropertyAttribute
:
{ before(grammarAccess.getPropertyAttributeRule()); }
	 rulePropertyAttribute
{ after(grammarAccess.getPropertyAttributeRule()); } 
	 EOF 
;

// Rule PropertyAttribute
rulePropertyAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyAttributeAccess().getAlternatives()); }
		(rule__PropertyAttribute__Alternatives)
		{ after(grammarAccess.getPropertyAttributeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBooleanPropertyAttribute
entryRuleBooleanPropertyAttribute
:
{ before(grammarAccess.getBooleanPropertyAttributeRule()); }
	 ruleBooleanPropertyAttribute
{ after(grammarAccess.getBooleanPropertyAttributeRule()); } 
	 EOF 
;

// Rule BooleanPropertyAttribute
ruleBooleanPropertyAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBooleanPropertyAttributeAccess().getGroup()); }
		(rule__BooleanPropertyAttribute__Group__0)
		{ after(grammarAccess.getBooleanPropertyAttributeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnumLiteralPropertyAttribute
entryRuleEnumLiteralPropertyAttribute
:
{ before(grammarAccess.getEnumLiteralPropertyAttributeRule()); }
	 ruleEnumLiteralPropertyAttribute
{ after(grammarAccess.getEnumLiteralPropertyAttributeRule()); } 
	 EOF 
;

// Rule EnumLiteralPropertyAttribute
ruleEnumLiteralPropertyAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getGroup()); }
		(rule__EnumLiteralPropertyAttribute__Group__0)
		{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyType
entryRulePropertyType
:
{ before(grammarAccess.getPropertyTypeRule()); }
	 rulePropertyType
{ after(grammarAccess.getPropertyTypeRule()); } 
	 EOF 
;

// Rule PropertyType
rulePropertyType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyTypeAccess().getAlternatives()); }
		(rule__PropertyType__Alternatives)
		{ after(grammarAccess.getPropertyTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitivePropertyType
entryRulePrimitivePropertyType
:
{ before(grammarAccess.getPrimitivePropertyTypeRule()); }
	 rulePrimitivePropertyType
{ after(grammarAccess.getPrimitivePropertyTypeRule()); } 
	 EOF 
;

// Rule PrimitivePropertyType
rulePrimitivePropertyType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitivePropertyTypeAccess().getTypeAssignment()); }
		(rule__PrimitivePropertyType__TypeAssignment)
		{ after(grammarAccess.getPrimitivePropertyTypeAccess().getTypeAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleObjectPropertyType
entryRuleObjectPropertyType
:
{ before(grammarAccess.getObjectPropertyTypeRule()); }
	 ruleObjectPropertyType
{ after(grammarAccess.getObjectPropertyTypeRule()); } 
	 EOF 
;

// Rule ObjectPropertyType
ruleObjectPropertyType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getObjectPropertyTypeAccess().getTypeAssignment()); }
		(rule__ObjectPropertyType__TypeAssignment)
		{ after(grammarAccess.getObjectPropertyTypeAccess().getTypeAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComplexPrimitivePropertyType
entryRuleComplexPrimitivePropertyType
:
{ before(grammarAccess.getComplexPrimitivePropertyTypeRule()); }
	 ruleComplexPrimitivePropertyType
{ after(grammarAccess.getComplexPrimitivePropertyTypeRule()); } 
	 EOF 
;

// Rule ComplexPrimitivePropertyType
ruleComplexPrimitivePropertyType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComplexPrimitivePropertyTypeAccess().getDictionaryPropertyTypeParserRuleCall()); }
		ruleDictionaryPropertyType
		{ after(grammarAccess.getComplexPrimitivePropertyTypeAccess().getDictionaryPropertyTypeParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDictionaryPropertyType
entryRuleDictionaryPropertyType
:
{ before(grammarAccess.getDictionaryPropertyTypeRule()); }
	 ruleDictionaryPropertyType
{ after(grammarAccess.getDictionaryPropertyTypeRule()); } 
	 EOF 
;

// Rule DictionaryPropertyType
ruleDictionaryPropertyType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDictionaryPropertyTypeAccess().getGroup()); }
		(rule__DictionaryPropertyType__Group__0)
		{ after(grammarAccess.getDictionaryPropertyTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePresence
entryRulePresence
:
{ before(grammarAccess.getPresenceRule()); }
	 rulePresence
{ after(grammarAccess.getPresenceRule()); } 
	 EOF 
;

// Rule Presence
rulePresence 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPresenceAccess().getGroup()); }
		(rule__Presence__Group__0)
		{ after(grammarAccess.getPresenceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConstraint
entryRuleConstraint
:
{ before(grammarAccess.getConstraintRule()); }
	 ruleConstraint
{ after(grammarAccess.getConstraintRule()); } 
	 EOF 
;

// Rule Constraint
ruleConstraint 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConstraintAccess().getGroup()); }
		(rule__Constraint__Group__0)
		{ after(grammarAccess.getConstraintAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalType
entryRuleIntervalType
:
{ before(grammarAccess.getIntervalTypeRule()); }
	 ruleIntervalType
{ after(grammarAccess.getIntervalTypeRule()); } 
	 EOF 
;

// Rule IntervalType
ruleIntervalType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalTypeAccess().getAlternatives()); }
		(rule__IntervalType__Alternatives)
		{ after(grammarAccess.getIntervalTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBOOLEAN
entryRuleBOOLEAN
:
{ before(grammarAccess.getBOOLEANRule()); }
	 ruleBOOLEAN
{ after(grammarAccess.getBOOLEANRule()); } 
	 EOF 
;

// Rule BOOLEAN
ruleBOOLEAN 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBOOLEANAccess().getAlternatives()); }
		(rule__BOOLEAN__Alternatives)
		{ after(grammarAccess.getBOOLEANAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCATEGORY
entryRuleCATEGORY
:
{ before(grammarAccess.getCATEGORYRule()); }
	 ruleCATEGORY
{ after(grammarAccess.getCATEGORYRule()); } 
	 EOF 
;

// Rule CATEGORY
ruleCATEGORY 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCATEGORYAccess().getGroup()); }
		(rule__CATEGORY__Group__0)
		{ after(grammarAccess.getCATEGORYAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleValidID
entryRuleValidID
:
{ before(grammarAccess.getValidIDRule()); }
	 ruleValidID
{ after(grammarAccess.getValidIDRule()); } 
	 EOF 
;

// Rule ValidID
ruleValidID 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getValidIDAccess().getAlternatives()); }
		(rule__ValidID__Alternatives)
		{ after(grammarAccess.getValidIDAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleKEYWORD
entryRuleKEYWORD
:
{ before(grammarAccess.getKEYWORDRule()); }
	 ruleKEYWORD
{ after(grammarAccess.getKEYWORDRule()); } 
	 EOF 
;

// Rule KEYWORD
ruleKEYWORD 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getKEYWORDAccess().getAlternatives()); }
		(rule__KEYWORD__Alternatives)
		{ after(grammarAccess.getKEYWORDAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule BooleanPropertyAttributeType
ruleBooleanPropertyAttributeType
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBooleanPropertyAttributeTypeAccess().getAlternatives()); }
		(rule__BooleanPropertyAttributeType__Alternatives)
		{ after(grammarAccess.getBooleanPropertyAttributeTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule VortoLangVersion
ruleVortoLangVersion
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVortoLangVersionAccess().getVersion1EnumLiteralDeclaration()); }
		('1.0')
		{ after(grammarAccess.getVortoLangVersionAccess().getVersion1EnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule EnumLiteralPropertyAttributeType
ruleEnumLiteralPropertyAttributeType
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumLiteralPropertyAttributeTypeAccess().getMeasurementUnitEnumLiteralDeclaration()); }
		('measurementUnit')
		{ after(grammarAccess.getEnumLiteralPropertyAttributeTypeAccess().getMeasurementUnitEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrimitiveType
rulePrimitiveType
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getAlternatives()); }
		(rule__PrimitiveType__Alternatives)
		{ after(grammarAccess.getPrimitiveTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ConstraintIntervalType
ruleConstraintIntervalType
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getAlternatives()); }
		(rule__ConstraintIntervalType__Alternatives)
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnTypeAccess().getReturnDictonaryTypeParserRuleCall_0()); }
		ruleReturnDictonaryType
		{ after(grammarAccess.getReturnTypeAccess().getReturnDictonaryTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getReturnTypeAccess().getReturnObjectTypeParserRuleCall_1()); }
		ruleReturnObjectType
		{ after(grammarAccess.getReturnTypeAccess().getReturnObjectTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getReturnTypeAccess().getReturnPrimitiveTypeParserRuleCall_2()); }
		ruleReturnPrimitiveType
		{ after(grammarAccess.getReturnTypeAccess().getReturnPrimitiveTypeParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Param__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParamAccess().getDictonaryParamParserRuleCall_0()); }
		ruleDictonaryParam
		{ after(grammarAccess.getParamAccess().getDictonaryParamParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getParamAccess().getPrimitiveParamParserRuleCall_1()); }
		rulePrimitiveParam
		{ after(grammarAccess.getParamAccess().getPrimitiveParamParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getParamAccess().getRefParamParserRuleCall_2()); }
		ruleRefParam
		{ after(grammarAccess.getParamAccess().getRefParamParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Type__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeAccess().getEntityParserRuleCall_0()); }
		ruleEntity
		{ after(grammarAccess.getTypeAccess().getEntityParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeAccess().getEnumParserRuleCall_1()); }
		ruleEnum
		{ after(grammarAccess.getTypeAccess().getEnumParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyAttribute__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAttributeAccess().getBooleanPropertyAttributeParserRuleCall_0()); }
		ruleBooleanPropertyAttribute
		{ after(grammarAccess.getPropertyAttributeAccess().getBooleanPropertyAttributeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAttributeAccess().getEnumLiteralPropertyAttributeParserRuleCall_1()); }
		ruleEnumLiteralPropertyAttribute
		{ after(grammarAccess.getPropertyAttributeAccess().getEnumLiteralPropertyAttributeParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBooleanPropertyAttributeAccess().getValueAssignment_2_0()); }
		(rule__BooleanPropertyAttribute__ValueAssignment_2_0)
		{ after(grammarAccess.getBooleanPropertyAttributeAccess().getValueAssignment_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getBooleanPropertyAttributeAccess().getFalseKeyword_2_1()); }
		'false'
		{ after(grammarAccess.getBooleanPropertyAttributeAccess().getFalseKeyword_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyTypeAccess().getObjectPropertyTypeParserRuleCall_0()); }
		ruleObjectPropertyType
		{ after(grammarAccess.getPropertyTypeAccess().getObjectPropertyTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyTypeAccess().getPrimitivePropertyTypeParserRuleCall_1()); }
		rulePrimitivePropertyType
		{ after(grammarAccess.getPropertyTypeAccess().getPrimitivePropertyTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyTypeAccess().getComplexPrimitivePropertyTypeParserRuleCall_2()); }
		ruleComplexPrimitivePropertyType
		{ after(grammarAccess.getPropertyTypeAccess().getComplexPrimitivePropertyTypeParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Presence__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPresenceAccess().getMandatoryAssignment_1_0()); }
		(rule__Presence__MandatoryAssignment_1_0)
		{ after(grammarAccess.getPresenceAccess().getMandatoryAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getPresenceAccess().getOptionalKeyword_1_1()); }
		'optional'
		{ after(grammarAccess.getPresenceAccess().getOptionalKeyword_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeAccess().getINTTerminalRuleCall_0()); }
		RULE_INT
		{ after(grammarAccess.getIntervalTypeAccess().getINTTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getSIGNEDINTTerminalRuleCall_1()); }
		RULE_SIGNEDINT
		{ after(grammarAccess.getIntervalTypeAccess().getSIGNEDINTTerminalRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getFLOATTerminalRuleCall_2()); }
		RULE_FLOAT
		{ after(grammarAccess.getIntervalTypeAccess().getFLOATTerminalRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getDATETIMETerminalRuleCall_3()); }
		RULE_DATETIME
		{ after(grammarAccess.getIntervalTypeAccess().getDATETIMETerminalRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getSTRINGTerminalRuleCall_4()); }
		RULE_STRING
		{ after(grammarAccess.getIntervalTypeAccess().getSTRINGTerminalRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getBOOLEANParserRuleCall_5()); }
		ruleBOOLEAN
		{ after(grammarAccess.getIntervalTypeAccess().getBOOLEANParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BOOLEAN__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBOOLEANAccess().getTrueKeyword_0()); }
		'true'
		{ after(grammarAccess.getBOOLEANAccess().getTrueKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getBOOLEANAccess().getFalseKeyword_1()); }
		'false'
		{ after(grammarAccess.getBOOLEANAccess().getFalseKeyword_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ValidID__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getValidIDAccess().getIDTerminalRuleCall_0()); }
		RULE_ID
		{ after(grammarAccess.getValidIDAccess().getIDTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getValidIDAccess().getKEYWORDParserRuleCall_1()); }
		ruleKEYWORD
		{ after(grammarAccess.getValidIDAccess().getKEYWORDParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__KEYWORD__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getKEYWORDAccess().getBreakableKeyword_0()); }
		'breakable'
		{ after(grammarAccess.getKEYWORDAccess().getBreakableKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getCategoryKeyword_1()); }
		'category'
		{ after(grammarAccess.getKEYWORDAccess().getCategoryKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getConfigurationKeyword_2()); }
		'configuration'
		{ after(grammarAccess.getKEYWORDAccess().getConfigurationKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getDateTimeKeyword_3()); }
		'dateTime'
		{ after(grammarAccess.getKEYWORDAccess().getDateTimeKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getDescriptionKeyword_4()); }
		'description'
		{ after(grammarAccess.getKEYWORDAccess().getDescriptionKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getDictionaryKeyword_5()); }
		'dictionary'
		{ after(grammarAccess.getKEYWORDAccess().getDictionaryKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getDisplaynameKeyword_6()); }
		'displayname'
		{ after(grammarAccess.getKEYWORDAccess().getDisplaynameKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getEventsKeyword_7()); }
		'events'
		{ after(grammarAccess.getKEYWORDAccess().getEventsKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getExtensionKeyword_8()); }
		'extension'
		{ after(grammarAccess.getKEYWORDAccess().getExtensionKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getFaultKeyword_9()); }
		'fault'
		{ after(grammarAccess.getKEYWORDAccess().getFaultKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getFunctionblockKeyword_10()); }
		'functionblock'
		{ after(grammarAccess.getKEYWORDAccess().getFunctionblockKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getFunctionblocksKeyword_11()); }
		'functionblocks'
		{ after(grammarAccess.getKEYWORDAccess().getFunctionblocksKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getInfomodelKeyword_12()); }
		'infomodel'
		{ after(grammarAccess.getKEYWORDAccess().getInfomodelKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getMandatoryKeyword_13()); }
		'mandatory'
		{ after(grammarAccess.getKEYWORDAccess().getMandatoryKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getNamespaceKeyword_14()); }
		'namespace'
		{ after(grammarAccess.getKEYWORDAccess().getNamespaceKeyword_14()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getOperationsKeyword_15()); }
		'operations'
		{ after(grammarAccess.getKEYWORDAccess().getOperationsKeyword_15()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getOptionalKeyword_16()); }
		'optional'
		{ after(grammarAccess.getKEYWORDAccess().getOptionalKeyword_16()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getStatusKeyword_17()); }
		'status'
		{ after(grammarAccess.getKEYWORDAccess().getStatusKeyword_17()); }
	)
	|
	(
		{ before(grammarAccess.getKEYWORDAccess().getVersionKeyword_18()); }
		'version'
		{ after(grammarAccess.getKEYWORDAccess().getVersionKeyword_18()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttributeType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBooleanPropertyAttributeTypeAccess().getReadableEnumLiteralDeclaration_0()); }
		('readable')
		{ after(grammarAccess.getBooleanPropertyAttributeTypeAccess().getReadableEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getBooleanPropertyAttributeTypeAccess().getWritableEnumLiteralDeclaration_1()); }
		('writable')
		{ after(grammarAccess.getBooleanPropertyAttributeTypeAccess().getWritableEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getBooleanPropertyAttributeTypeAccess().getEventableEnumLiteralDeclaration_2()); }
		('eventable')
		{ after(grammarAccess.getBooleanPropertyAttributeTypeAccess().getEventableEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getStringEnumLiteralDeclaration_0()); }
		('string')
		{ after(grammarAccess.getPrimitiveTypeAccess().getStringEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getIntEnumLiteralDeclaration_1()); }
		('int')
		{ after(grammarAccess.getPrimitiveTypeAccess().getIntEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getFloatEnumLiteralDeclaration_2()); }
		('float')
		{ after(grammarAccess.getPrimitiveTypeAccess().getFloatEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getBooleanEnumLiteralDeclaration_3()); }
		('boolean')
		{ after(grammarAccess.getPrimitiveTypeAccess().getBooleanEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getDatetimeEnumLiteralDeclaration_4()); }
		('dateTime')
		{ after(grammarAccess.getPrimitiveTypeAccess().getDatetimeEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getDoubleEnumLiteralDeclaration_5()); }
		('double')
		{ after(grammarAccess.getPrimitiveTypeAccess().getDoubleEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getLongEnumLiteralDeclaration_6()); }
		('long')
		{ after(grammarAccess.getPrimitiveTypeAccess().getLongEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getShortEnumLiteralDeclaration_7()); }
		('short')
		{ after(grammarAccess.getPrimitiveTypeAccess().getShortEnumLiteralDeclaration_7()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getBase64BinaryEnumLiteralDeclaration_8()); }
		('base64Binary')
		{ after(grammarAccess.getPrimitiveTypeAccess().getBase64BinaryEnumLiteralDeclaration_8()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getByteEnumLiteralDeclaration_9()); }
		('byte')
		{ after(grammarAccess.getPrimitiveTypeAccess().getByteEnumLiteralDeclaration_9()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintIntervalType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getMinEnumLiteralDeclaration_0()); }
		('MIN')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getMinEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getMaxEnumLiteralDeclaration_1()); }
		('MAX')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getMaxEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getStrlenEnumLiteralDeclaration_2()); }
		('STRLEN')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getStrlenEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getRegexEnumLiteralDeclaration_3()); }
		('REGEX')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getRegexEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getMimetypeEnumLiteralDeclaration_4()); }
		('MIMETYPE')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getMimetypeEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getScalingEnumLiteralDeclaration_5()); }
		('SCALING')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getScalingEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getDefaultEnumLiteralDeclaration_6()); }
		('DEFAULT')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getDefaultEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getConstraintIntervalTypeAccess().getNullableEnumLiteralDeclaration_7()); }
		('NULLABLE')
		{ after(grammarAccess.getConstraintIntervalTypeAccess().getNullableEnumLiteralDeclaration_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__0__Impl
	rule__InformationModel__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getInformationModelAction_0()); }
	()
	{ after(grammarAccess.getInformationModelAccess().getInformationModelAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__1__Impl
	rule__InformationModel__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getVortolangKeyword_1()); }
	'vortolang'
	{ after(grammarAccess.getInformationModelAccess().getVortolangKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__2__Impl
	rule__InformationModel__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getLangAssignment_2()); }
	(rule__InformationModel__LangAssignment_2)
	{ after(grammarAccess.getInformationModelAccess().getLangAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__3__Impl
	rule__InformationModel__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getNamespaceKeyword_3()); }
	'namespace'
	{ after(grammarAccess.getInformationModelAccess().getNamespaceKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__4__Impl
	rule__InformationModel__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getNamespaceAssignment_4()); }
	(rule__InformationModel__NamespaceAssignment_4)
	{ after(grammarAccess.getInformationModelAccess().getNamespaceAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__5__Impl
	rule__InformationModel__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getVersionKeyword_5()); }
	'version'
	{ after(grammarAccess.getInformationModelAccess().getVersionKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__6__Impl
	rule__InformationModel__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getVersionAssignment_6()); }
	(rule__InformationModel__VersionAssignment_6)
	{ after(grammarAccess.getInformationModelAccess().getVersionAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__7__Impl
	rule__InformationModel__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getUnorderedGroup_7()); }
	(rule__InformationModel__UnorderedGroup_7)
	{ after(grammarAccess.getInformationModelAccess().getUnorderedGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__8__Impl
	rule__InformationModel__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getReferencesAssignment_8()); }
	(rule__InformationModel__ReferencesAssignment_8)*
	{ after(grammarAccess.getInformationModelAccess().getReferencesAssignment_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__9__Impl
	rule__InformationModel__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getInfomodelKeyword_9()); }
	'infomodel'
	{ after(grammarAccess.getInformationModelAccess().getInfomodelKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__10__Impl
	rule__InformationModel__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getNameAssignment_10()); }
	(rule__InformationModel__NameAssignment_10)
	{ after(grammarAccess.getInformationModelAccess().getNameAssignment_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__11__Impl
	rule__InformationModel__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_11()); }
	'{'
	{ after(grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__12__Impl
	rule__InformationModel__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getGroup_12()); }
	(rule__InformationModel__Group_12__0)?
	{ after(grammarAccess.getInformationModelAccess().getGroup_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group__13__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_13()); }
	'}'
	{ after(grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InformationModel__Group_7_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_7_0__0__Impl
	rule__InformationModel__Group_7_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getDisplaynameKeyword_7_0_0()); }
	'displayname'
	{ after(grammarAccess.getInformationModelAccess().getDisplaynameKeyword_7_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_7_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getDisplaynameAssignment_7_0_1()); }
	(rule__InformationModel__DisplaynameAssignment_7_0_1)
	{ after(grammarAccess.getInformationModelAccess().getDisplaynameAssignment_7_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InformationModel__Group_7_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_7_1__0__Impl
	rule__InformationModel__Group_7_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getDescriptionKeyword_7_1_0()); }
	'description'
	{ after(grammarAccess.getInformationModelAccess().getDescriptionKeyword_7_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_7_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getDescriptionAssignment_7_1_1()); }
	(rule__InformationModel__DescriptionAssignment_7_1_1)
	{ after(grammarAccess.getInformationModelAccess().getDescriptionAssignment_7_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InformationModel__Group_7_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_7_2__0__Impl
	rule__InformationModel__Group_7_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getCategoryKeyword_7_2_0()); }
	'category'
	{ after(grammarAccess.getInformationModelAccess().getCategoryKeyword_7_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_7_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_7_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getCategoryAssignment_7_2_1()); }
	(rule__InformationModel__CategoryAssignment_7_2_1)
	{ after(grammarAccess.getInformationModelAccess().getCategoryAssignment_7_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InformationModel__Group_12__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_12__0__Impl
	rule__InformationModel__Group_12__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getFunctionblocksKeyword_12_0()); }
	'functionblocks'
	{ after(grammarAccess.getInformationModelAccess().getFunctionblocksKeyword_12_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_12__1__Impl
	rule__InformationModel__Group_12__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_12_1()); }
	'{'
	{ after(grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_12_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_12__2__Impl
	rule__InformationModel__Group_12__3
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getPropertiesAssignment_12_2()); }
	(rule__InformationModel__PropertiesAssignment_12_2)*
	{ after(grammarAccess.getInformationModelAccess().getPropertiesAssignment_12_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__Group_12__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__Group_12__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_12_3()); }
	'}'
	{ after(grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_12_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionblockProperty__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__0__Impl
	rule__FunctionblockProperty__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getPresenceAssignment_0()); }
	(rule__FunctionblockProperty__PresenceAssignment_0)?
	{ after(grammarAccess.getFunctionblockPropertyAccess().getPresenceAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__1__Impl
	rule__FunctionblockProperty__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getMultiplicityAssignment_1()); }
	(rule__FunctionblockProperty__MultiplicityAssignment_1)?
	{ after(grammarAccess.getFunctionblockPropertyAccess().getMultiplicityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__2__Impl
	rule__FunctionblockProperty__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getNameAssignment_2()); }
	(rule__FunctionblockProperty__NameAssignment_2)
	{ after(grammarAccess.getFunctionblockPropertyAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__3__Impl
	rule__FunctionblockProperty__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getAsKeyword_3()); }
	'as'
	{ after(grammarAccess.getFunctionblockPropertyAccess().getAsKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__4__Impl
	rule__FunctionblockProperty__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getTypeAssignment_4()); }
	(rule__FunctionblockProperty__TypeAssignment_4)
	{ after(grammarAccess.getFunctionblockPropertyAccess().getTypeAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__5__Impl
	rule__FunctionblockProperty__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getGroup_5()); }
	(rule__FunctionblockProperty__Group_5__0)?
	{ after(grammarAccess.getFunctionblockPropertyAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getDescriptionAssignment_6()); }
	(rule__FunctionblockProperty__DescriptionAssignment_6)?
	{ after(grammarAccess.getFunctionblockPropertyAccess().getDescriptionAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionblockProperty__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group_5__0__Impl
	rule__FunctionblockProperty__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getExtendsKeyword_5_0()); }
	'extends'
	{ after(grammarAccess.getFunctionblockPropertyAccess().getExtendsKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group_5__1__Impl
	rule__FunctionblockProperty__Group_5__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getLeftCurlyBracketKeyword_5_1()); }
	'{'
	{ after(grammarAccess.getFunctionblockPropertyAccess().getLeftCurlyBracketKeyword_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group_5__2__Impl
	rule__FunctionblockProperty__Group_5__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getExtendedFunctionBlockAssignment_5_2()); }
	(rule__FunctionblockProperty__ExtendedFunctionBlockAssignment_5_2)
	{ after(grammarAccess.getFunctionblockPropertyAccess().getExtendedFunctionBlockAssignment_5_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionblockProperty__Group_5__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__Group_5__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionblockPropertyAccess().getRightCurlyBracketKeyword_5_3()); }
	'}'
	{ after(grammarAccess.getFunctionblockPropertyAccess().getRightCurlyBracketKeyword_5_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group__0__Impl
	rule__FunctionBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getFunctionBlockAction_0()); }
	()
	{ after(grammarAccess.getFunctionBlockAccess().getFunctionBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1()); }
	(rule__FunctionBlock__UnorderedGroup_1)
	{ after(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionBlock__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_3__0__Impl
	rule__FunctionBlock__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getEventsKeyword_1_3_0()); }
	'events'
	{ after(grammarAccess.getFunctionBlockAccess().getEventsKeyword_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_3__1__Impl
	rule__FunctionBlock__Group_1_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getLeftCurlyBracketKeyword_1_3_1()); }
	'{'
	{ after(grammarAccess.getFunctionBlockAccess().getLeftCurlyBracketKeyword_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_3__2__Impl
	rule__FunctionBlock__Group_1_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getFunctionBlockAccess().getEventsAssignment_1_3_2()); }
		(rule__FunctionBlock__EventsAssignment_1_3_2)
		{ after(grammarAccess.getFunctionBlockAccess().getEventsAssignment_1_3_2()); }
	)
	(
		{ before(grammarAccess.getFunctionBlockAccess().getEventsAssignment_1_3_2()); }
		(rule__FunctionBlock__EventsAssignment_1_3_2)*
		{ after(grammarAccess.getFunctionBlockAccess().getEventsAssignment_1_3_2()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getRightCurlyBracketKeyword_1_3_3()); }
	'}'
	{ after(grammarAccess.getFunctionBlockAccess().getRightCurlyBracketKeyword_1_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionBlock__Group_1_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_4__0__Impl
	rule__FunctionBlock__Group_1_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getOperationsKeyword_1_4_0()); }
	'operations'
	{ after(grammarAccess.getFunctionBlockAccess().getOperationsKeyword_1_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_4__1__Impl
	rule__FunctionBlock__Group_1_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getLeftCurlyBracketKeyword_1_4_1()); }
	'{'
	{ after(grammarAccess.getFunctionBlockAccess().getLeftCurlyBracketKeyword_1_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_4__2__Impl
	rule__FunctionBlock__Group_1_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getFunctionBlockAccess().getOperationsAssignment_1_4_2()); }
		(rule__FunctionBlock__OperationsAssignment_1_4_2)
		{ after(grammarAccess.getFunctionBlockAccess().getOperationsAssignment_1_4_2()); }
	)
	(
		{ before(grammarAccess.getFunctionBlockAccess().getOperationsAssignment_1_4_2()); }
		(rule__FunctionBlock__OperationsAssignment_1_4_2)*
		{ after(grammarAccess.getFunctionBlockAccess().getOperationsAssignment_1_4_2()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__Group_1_4__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__Group_1_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionBlockAccess().getRightCurlyBracketKeyword_1_4_3()); }
	'}'
	{ after(grammarAccess.getFunctionBlockAccess().getRightCurlyBracketKeyword_1_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Configuration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Configuration__Group__0__Impl
	rule__Configuration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConfigurationAccess().getConfigurationAction_0()); }
	()
	{ after(grammarAccess.getConfigurationAccess().getConfigurationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Configuration__Group__1__Impl
	rule__Configuration__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConfigurationAccess().getConfigurationKeyword_1()); }
	'configuration'
	{ after(grammarAccess.getConfigurationAccess().getConfigurationKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Configuration__Group__2__Impl
	rule__Configuration__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConfigurationAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getConfigurationAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Configuration__Group__3__Impl
	rule__Configuration__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConfigurationAccess().getPropertiesAssignment_3()); }
	(rule__Configuration__PropertiesAssignment_3)*
	{ after(grammarAccess.getConfigurationAccess().getPropertiesAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Configuration__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConfigurationAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getConfigurationAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Status__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Status__Group__0__Impl
	rule__Status__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatusAccess().getStatusAction_0()); }
	()
	{ after(grammarAccess.getStatusAccess().getStatusAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Status__Group__1__Impl
	rule__Status__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatusAccess().getStatusKeyword_1()); }
	'status'
	{ after(grammarAccess.getStatusAccess().getStatusKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Status__Group__2__Impl
	rule__Status__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatusAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getStatusAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Status__Group__3__Impl
	rule__Status__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatusAccess().getPropertiesAssignment_3()); }
	(rule__Status__PropertiesAssignment_3)*
	{ after(grammarAccess.getStatusAccess().getPropertiesAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Status__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatusAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getStatusAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Fault__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Fault__Group__0__Impl
	rule__Fault__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFaultAccess().getFaultAction_0()); }
	()
	{ after(grammarAccess.getFaultAccess().getFaultAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Fault__Group__1__Impl
	rule__Fault__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFaultAccess().getFaultKeyword_1()); }
	'fault'
	{ after(grammarAccess.getFaultAccess().getFaultKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Fault__Group__2__Impl
	rule__Fault__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFaultAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getFaultAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Fault__Group__3__Impl
	rule__Fault__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFaultAccess().getPropertiesAssignment_3()); }
	(rule__Fault__PropertiesAssignment_3)*
	{ after(grammarAccess.getFaultAccess().getPropertiesAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Fault__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFaultAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getFaultAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Operation__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__0__Impl
	rule__Operation__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getExtensionAssignment_0()); }
	(rule__Operation__ExtensionAssignment_0)?
	{ after(grammarAccess.getOperationAccess().getExtensionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__1__Impl
	rule__Operation__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getPresenceAssignment_1()); }
	(rule__Operation__PresenceAssignment_1)?
	{ after(grammarAccess.getOperationAccess().getPresenceAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__2__Impl
	rule__Operation__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getBreakableAssignment_2()); }
	(rule__Operation__BreakableAssignment_2)?
	{ after(grammarAccess.getOperationAccess().getBreakableAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__3__Impl
	rule__Operation__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getNameAssignment_3()); }
	(rule__Operation__NameAssignment_3)
	{ after(grammarAccess.getOperationAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__4__Impl
	rule__Operation__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getLeftParenthesisKeyword_4()); }
	'('
	{ after(grammarAccess.getOperationAccess().getLeftParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__5__Impl
	rule__Operation__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getGroup_5()); }
	(rule__Operation__Group_5__0)?
	{ after(grammarAccess.getOperationAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__6__Impl
	rule__Operation__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getRightParenthesisKeyword_6()); }
	')'
	{ after(grammarAccess.getOperationAccess().getRightParenthesisKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__7__Impl
	rule__Operation__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getGroup_7()); }
	(rule__Operation__Group_7__0)?
	{ after(grammarAccess.getOperationAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getDescriptionAssignment_8()); }
	(rule__Operation__DescriptionAssignment_8)?
	{ after(grammarAccess.getOperationAccess().getDescriptionAssignment_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Operation__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group_5__0__Impl
	rule__Operation__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getParamsAssignment_5_0()); }
	(rule__Operation__ParamsAssignment_5_0)
	{ after(grammarAccess.getOperationAccess().getParamsAssignment_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getGroup_5_1()); }
	(rule__Operation__Group_5_1__0)*
	{ after(grammarAccess.getOperationAccess().getGroup_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Operation__Group_5_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group_5_1__0__Impl
	rule__Operation__Group_5_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_5_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getCommaKeyword_5_1_0()); }
	','
	{ after(grammarAccess.getOperationAccess().getCommaKeyword_5_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_5_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group_5_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_5_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getParamsAssignment_5_1_1()); }
	(rule__Operation__ParamsAssignment_5_1_1)
	{ after(grammarAccess.getOperationAccess().getParamsAssignment_5_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Operation__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group_7__0__Impl
	rule__Operation__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getReturnsKeyword_7_0()); }
	'returns'
	{ after(grammarAccess.getOperationAccess().getReturnsKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Operation__Group_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOperationAccess().getReturnTypeAssignment_7_1()); }
	(rule__Operation__ReturnTypeAssignment_7_1)
	{ after(grammarAccess.getOperationAccess().getReturnTypeAssignment_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnDictonaryType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnDictonaryType__Group__0__Impl
	rule__ReturnDictonaryType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityAssignment_0()); }
	(rule__ReturnDictonaryType__MultiplicityAssignment_0)?
	{ after(grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnDictonaryType__Group__1__Impl
	rule__ReturnDictonaryType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnDictonaryTypeAccess().getReturnTypeAssignment_1()); }
	(rule__ReturnDictonaryType__ReturnTypeAssignment_1)
	{ after(grammarAccess.getReturnDictonaryTypeAccess().getReturnTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnDictonaryType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnDictonaryTypeAccess().getGroup_2()); }
	(rule__ReturnDictonaryType__Group_2__0)?
	{ after(grammarAccess.getReturnDictonaryTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnDictonaryType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnDictonaryType__Group_2__0__Impl
	rule__ReturnDictonaryType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnDictonaryTypeAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getReturnDictonaryTypeAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnDictonaryType__Group_2__1__Impl
	rule__ReturnDictonaryType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnDictonaryTypeAccess().getConstraintRuleAssignment_2_1()); }
	(rule__ReturnDictonaryType__ConstraintRuleAssignment_2_1)
	{ after(grammarAccess.getReturnDictonaryTypeAccess().getConstraintRuleAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnDictonaryType__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnDictonaryTypeAccess().getGreaterThanSignKeyword_2_2()); }
	'>'
	{ after(grammarAccess.getReturnDictonaryTypeAccess().getGreaterThanSignKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnObjectType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnObjectType__Group__0__Impl
	rule__ReturnObjectType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnObjectTypeAccess().getMultiplicityAssignment_0()); }
	(rule__ReturnObjectType__MultiplicityAssignment_0)?
	{ after(grammarAccess.getReturnObjectTypeAccess().getMultiplicityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnObjectType__Group__1__Impl
	rule__ReturnObjectType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnObjectTypeAccess().getReturnTypeAssignment_1()); }
	(rule__ReturnObjectType__ReturnTypeAssignment_1)
	{ after(grammarAccess.getReturnObjectTypeAccess().getReturnTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnObjectType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnObjectTypeAccess().getGroup_2()); }
	(rule__ReturnObjectType__Group_2__0)?
	{ after(grammarAccess.getReturnObjectTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnObjectType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnObjectType__Group_2__0__Impl
	rule__ReturnObjectType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnObjectTypeAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getReturnObjectTypeAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnObjectType__Group_2__1__Impl
	rule__ReturnObjectType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnObjectTypeAccess().getConstraintRuleAssignment_2_1()); }
	(rule__ReturnObjectType__ConstraintRuleAssignment_2_1)
	{ after(grammarAccess.getReturnObjectTypeAccess().getConstraintRuleAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnObjectType__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnObjectTypeAccess().getGreaterThanSignKeyword_2_2()); }
	'>'
	{ after(grammarAccess.getReturnObjectTypeAccess().getGreaterThanSignKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnPrimitiveType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnPrimitiveType__Group__0__Impl
	rule__ReturnPrimitiveType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityAssignment_0()); }
	(rule__ReturnPrimitiveType__MultiplicityAssignment_0)?
	{ after(grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnPrimitiveType__Group__1__Impl
	rule__ReturnPrimitiveType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnPrimitiveTypeAccess().getReturnTypeAssignment_1()); }
	(rule__ReturnPrimitiveType__ReturnTypeAssignment_1)
	{ after(grammarAccess.getReturnPrimitiveTypeAccess().getReturnTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnPrimitiveType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnPrimitiveTypeAccess().getGroup_2()); }
	(rule__ReturnPrimitiveType__Group_2__0)?
	{ after(grammarAccess.getReturnPrimitiveTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnPrimitiveType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnPrimitiveType__Group_2__0__Impl
	rule__ReturnPrimitiveType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnPrimitiveTypeAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getReturnPrimitiveTypeAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnPrimitiveType__Group_2__1__Impl
	rule__ReturnPrimitiveType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnPrimitiveTypeAccess().getConstraintRuleAssignment_2_1()); }
	(rule__ReturnPrimitiveType__ConstraintRuleAssignment_2_1)
	{ after(grammarAccess.getReturnPrimitiveTypeAccess().getConstraintRuleAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnPrimitiveType__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnPrimitiveTypeAccess().getGreaterThanSignKeyword_2_2()); }
	'>'
	{ after(grammarAccess.getReturnPrimitiveTypeAccess().getGreaterThanSignKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DictonaryParam__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group__0__Impl
	rule__DictonaryParam__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getMultiplicityAssignment_0()); }
	(rule__DictonaryParam__MultiplicityAssignment_0)?
	{ after(grammarAccess.getDictonaryParamAccess().getMultiplicityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group__1__Impl
	rule__DictonaryParam__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getNameAssignment_1()); }
	(rule__DictonaryParam__NameAssignment_1)
	{ after(grammarAccess.getDictonaryParamAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group__2__Impl
	rule__DictonaryParam__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getAsKeyword_2()); }
	'as'
	{ after(grammarAccess.getDictonaryParamAccess().getAsKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group__3__Impl
	rule__DictonaryParam__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getTypeAssignment_3()); }
	(rule__DictonaryParam__TypeAssignment_3)
	{ after(grammarAccess.getDictonaryParamAccess().getTypeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group__4__Impl
	rule__DictonaryParam__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getGroup_4()); }
	(rule__DictonaryParam__Group_4__0)?
	{ after(grammarAccess.getDictonaryParamAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getDescriptionAssignment_5()); }
	(rule__DictonaryParam__DescriptionAssignment_5)?
	{ after(grammarAccess.getDictonaryParamAccess().getDescriptionAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DictonaryParam__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group_4__0__Impl
	rule__DictonaryParam__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getLessThanSignKeyword_4_0()); }
	'<'
	{ after(grammarAccess.getDictonaryParamAccess().getLessThanSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group_4__1__Impl
	rule__DictonaryParam__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getConstraintRuleAssignment_4_1()); }
	(rule__DictonaryParam__ConstraintRuleAssignment_4_1)
	{ after(grammarAccess.getDictonaryParamAccess().getConstraintRuleAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictonaryParam__Group_4__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictonaryParamAccess().getGreaterThanSignKeyword_4_2()); }
	'>'
	{ after(grammarAccess.getDictonaryParamAccess().getGreaterThanSignKeyword_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveParam__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group__0__Impl
	rule__PrimitiveParam__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getMultiplicityAssignment_0()); }
	(rule__PrimitiveParam__MultiplicityAssignment_0)?
	{ after(grammarAccess.getPrimitiveParamAccess().getMultiplicityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group__1__Impl
	rule__PrimitiveParam__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getNameAssignment_1()); }
	(rule__PrimitiveParam__NameAssignment_1)
	{ after(grammarAccess.getPrimitiveParamAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group__2__Impl
	rule__PrimitiveParam__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getAsKeyword_2()); }
	'as'
	{ after(grammarAccess.getPrimitiveParamAccess().getAsKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group__3__Impl
	rule__PrimitiveParam__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getTypeAssignment_3()); }
	(rule__PrimitiveParam__TypeAssignment_3)
	{ after(grammarAccess.getPrimitiveParamAccess().getTypeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group__4__Impl
	rule__PrimitiveParam__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getGroup_4()); }
	(rule__PrimitiveParam__Group_4__0)?
	{ after(grammarAccess.getPrimitiveParamAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getDescriptionAssignment_5()); }
	(rule__PrimitiveParam__DescriptionAssignment_5)?
	{ after(grammarAccess.getPrimitiveParamAccess().getDescriptionAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveParam__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group_4__0__Impl
	rule__PrimitiveParam__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getLessThanSignKeyword_4_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveParamAccess().getLessThanSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group_4__1__Impl
	rule__PrimitiveParam__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getConstraintRuleAssignment_4_1()); }
	(rule__PrimitiveParam__ConstraintRuleAssignment_4_1)
	{ after(grammarAccess.getPrimitiveParamAccess().getConstraintRuleAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveParam__Group_4__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveParamAccess().getGreaterThanSignKeyword_4_2()); }
	'>'
	{ after(grammarAccess.getPrimitiveParamAccess().getGreaterThanSignKeyword_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__RefParam__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__RefParam__Group__0__Impl
	rule__RefParam__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRefParamAccess().getMultiplicityAssignment_0()); }
	(rule__RefParam__MultiplicityAssignment_0)?
	{ after(grammarAccess.getRefParamAccess().getMultiplicityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__RefParam__Group__1__Impl
	rule__RefParam__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRefParamAccess().getNameAssignment_1()); }
	(rule__RefParam__NameAssignment_1)
	{ after(grammarAccess.getRefParamAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__RefParam__Group__2__Impl
	rule__RefParam__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRefParamAccess().getAsKeyword_2()); }
	'as'
	{ after(grammarAccess.getRefParamAccess().getAsKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__RefParam__Group__3__Impl
	rule__RefParam__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRefParamAccess().getTypeAssignment_3()); }
	(rule__RefParam__TypeAssignment_3)
	{ after(grammarAccess.getRefParamAccess().getTypeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__RefParam__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRefParamAccess().getDescriptionAssignment_4()); }
	(rule__RefParam__DescriptionAssignment_4)?
	{ after(grammarAccess.getRefParamAccess().getDescriptionAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Event__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Event__Group__0__Impl
	rule__Event__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventAccess().getNameAssignment_0()); }
	(rule__Event__NameAssignment_0)
	{ after(grammarAccess.getEventAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Event__Group__1__Impl
	rule__Event__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getEventAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Event__Group__2__Impl
	rule__Event__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventAccess().getPropertiesAssignment_2()); }
	(rule__Event__PropertiesAssignment_2)*
	{ after(grammarAccess.getEventAccess().getPropertiesAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Event__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getEventAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelReference__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelReference__Group__0__Impl
	rule__ModelReference__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelReferenceAccess().getUsingKeyword_0()); }
	'using'
	{ after(grammarAccess.getModelReferenceAccess().getUsingKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelReference__Group__1__Impl
	rule__ModelReference__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelReferenceAccess().getImportedNamespaceAssignment_1()); }
	(rule__ModelReference__ImportedNamespaceAssignment_1)
	{ after(grammarAccess.getModelReferenceAccess().getImportedNamespaceAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelReference__Group__2__Impl
	rule__ModelReference__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelReferenceAccess().getSemicolonKeyword_2()); }
	';'
	{ after(grammarAccess.getModelReferenceAccess().getSemicolonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelReference__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelReferenceAccess().getVersionAssignment_3()); }
	(rule__ModelReference__VersionAssignment_3)
	{ after(grammarAccess.getModelReferenceAccess().getVersionAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__QualifiedName__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QualifiedName__Group__0__Impl
	rule__QualifiedName__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__QualifiedName__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0()); }
	RULE_ID
	{ after(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__QualifiedName__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QualifiedName__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__QualifiedName__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQualifiedNameAccess().getGroup_1()); }
	(rule__QualifiedName__Group_1__0)*
	{ after(grammarAccess.getQualifiedNameAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__QualifiedName__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QualifiedName__Group_1__0__Impl
	rule__QualifiedName__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__QualifiedName__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0()); }
	'.'
	{ after(grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__QualifiedName__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QualifiedName__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__QualifiedName__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1()); }
	RULE_ID
	{ after(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Entity__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__0__Impl
	rule__Entity__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getVortolangKeyword_0()); }
	'vortolang'
	{ after(grammarAccess.getEntityAccess().getVortolangKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__1__Impl
	rule__Entity__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getLangAssignment_1()); }
	(rule__Entity__LangAssignment_1)
	{ after(grammarAccess.getEntityAccess().getLangAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__2__Impl
	rule__Entity__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getNamespaceKeyword_2()); }
	'namespace'
	{ after(grammarAccess.getEntityAccess().getNamespaceKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__3__Impl
	rule__Entity__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getNamespaceAssignment_3()); }
	(rule__Entity__NamespaceAssignment_3)
	{ after(grammarAccess.getEntityAccess().getNamespaceAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__4__Impl
	rule__Entity__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getVersionKeyword_4()); }
	'version'
	{ after(grammarAccess.getEntityAccess().getVersionKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__5__Impl
	rule__Entity__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getVersionAssignment_5()); }
	(rule__Entity__VersionAssignment_5)
	{ after(grammarAccess.getEntityAccess().getVersionAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__6__Impl
	rule__Entity__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getUnorderedGroup_6()); }
	(rule__Entity__UnorderedGroup_6)
	{ after(grammarAccess.getEntityAccess().getUnorderedGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__7__Impl
	rule__Entity__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getReferencesAssignment_7()); }
	(rule__Entity__ReferencesAssignment_7)*
	{ after(grammarAccess.getEntityAccess().getReferencesAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__8__Impl
	rule__Entity__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getEntityKeyword_8()); }
	'entity'
	{ after(grammarAccess.getEntityAccess().getEntityKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__9__Impl
	rule__Entity__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getNameAssignment_9()); }
	(rule__Entity__NameAssignment_9)
	{ after(grammarAccess.getEntityAccess().getNameAssignment_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__10__Impl
	rule__Entity__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getGroup_10()); }
	(rule__Entity__Group_10__0)?
	{ after(grammarAccess.getEntityAccess().getGroup_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__11__Impl
	rule__Entity__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_11()); }
	'{'
	{ after(grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__12__Impl
	rule__Entity__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getPropertiesAssignment_12()); }
	(rule__Entity__PropertiesAssignment_12)*
	{ after(grammarAccess.getEntityAccess().getPropertiesAssignment_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group__13__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_13()); }
	'}'
	{ after(grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Entity__Group_6_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_6_0__0__Impl
	rule__Entity__Group_6_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getDisplaynameKeyword_6_0_0()); }
	'displayname'
	{ after(grammarAccess.getEntityAccess().getDisplaynameKeyword_6_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_6_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getDisplaynameAssignment_6_0_1()); }
	(rule__Entity__DisplaynameAssignment_6_0_1)
	{ after(grammarAccess.getEntityAccess().getDisplaynameAssignment_6_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Entity__Group_6_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_6_1__0__Impl
	rule__Entity__Group_6_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getDescriptionKeyword_6_1_0()); }
	'description'
	{ after(grammarAccess.getEntityAccess().getDescriptionKeyword_6_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_6_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getDescriptionAssignment_6_1_1()); }
	(rule__Entity__DescriptionAssignment_6_1_1)
	{ after(grammarAccess.getEntityAccess().getDescriptionAssignment_6_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Entity__Group_6_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_6_2__0__Impl
	rule__Entity__Group_6_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getCategoryKeyword_6_2_0()); }
	'category'
	{ after(grammarAccess.getEntityAccess().getCategoryKeyword_6_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_6_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_6_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getCategoryAssignment_6_2_1()); }
	(rule__Entity__CategoryAssignment_6_2_1)
	{ after(grammarAccess.getEntityAccess().getCategoryAssignment_6_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Entity__Group_10__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_10__0__Impl
	rule__Entity__Group_10__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_10__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getExtendsKeyword_10_0()); }
	'extends'
	{ after(grammarAccess.getEntityAccess().getExtendsKeyword_10_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_10__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__Group_10__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__Group_10__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEntityAccess().getSuperTypeAssignment_10_1()); }
	(rule__Entity__SuperTypeAssignment_10_1)
	{ after(grammarAccess.getEntityAccess().getSuperTypeAssignment_10_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__0__Impl
	rule__Enum__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getVortolangKeyword_0()); }
	'vortolang'
	{ after(grammarAccess.getEnumAccess().getVortolangKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__1__Impl
	rule__Enum__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getLangAssignment_1()); }
	(rule__Enum__LangAssignment_1)
	{ after(grammarAccess.getEnumAccess().getLangAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__2__Impl
	rule__Enum__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getNamespaceKeyword_2()); }
	'namespace'
	{ after(grammarAccess.getEnumAccess().getNamespaceKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__3__Impl
	rule__Enum__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getNamespaceAssignment_3()); }
	(rule__Enum__NamespaceAssignment_3)
	{ after(grammarAccess.getEnumAccess().getNamespaceAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__4__Impl
	rule__Enum__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getVersionKeyword_4()); }
	'version'
	{ after(grammarAccess.getEnumAccess().getVersionKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__5__Impl
	rule__Enum__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getVersionAssignment_5()); }
	(rule__Enum__VersionAssignment_5)
	{ after(grammarAccess.getEnumAccess().getVersionAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__6__Impl
	rule__Enum__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getUnorderedGroup_6()); }
	(rule__Enum__UnorderedGroup_6)
	{ after(grammarAccess.getEnumAccess().getUnorderedGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__7__Impl
	rule__Enum__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getReferencesAssignment_7()); }
	(rule__Enum__ReferencesAssignment_7)*
	{ after(grammarAccess.getEnumAccess().getReferencesAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__8__Impl
	rule__Enum__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getEnumKeyword_8()); }
	'enum'
	{ after(grammarAccess.getEnumAccess().getEnumKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__9__Impl
	rule__Enum__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getNameAssignment_9()); }
	(rule__Enum__NameAssignment_9)
	{ after(grammarAccess.getEnumAccess().getNameAssignment_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__10__Impl
	rule__Enum__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getLeftCurlyBracketKeyword_10()); }
	'{'
	{ after(grammarAccess.getEnumAccess().getLeftCurlyBracketKeyword_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__11__Impl
	rule__Enum__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getGroup_11()); }
	(rule__Enum__Group_11__0)?
	{ after(grammarAccess.getEnumAccess().getGroup_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group__12__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getRightCurlyBracketKeyword_12()); }
	'}'
	{ after(grammarAccess.getEnumAccess().getRightCurlyBracketKeyword_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__Group_6_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_6_0__0__Impl
	rule__Enum__Group_6_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getDisplaynameKeyword_6_0_0()); }
	'displayname'
	{ after(grammarAccess.getEnumAccess().getDisplaynameKeyword_6_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_6_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getDisplaynameAssignment_6_0_1()); }
	(rule__Enum__DisplaynameAssignment_6_0_1)
	{ after(grammarAccess.getEnumAccess().getDisplaynameAssignment_6_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__Group_6_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_6_1__0__Impl
	rule__Enum__Group_6_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getDescriptionKeyword_6_1_0()); }
	'description'
	{ after(grammarAccess.getEnumAccess().getDescriptionKeyword_6_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_6_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getDescriptionAssignment_6_1_1()); }
	(rule__Enum__DescriptionAssignment_6_1_1)
	{ after(grammarAccess.getEnumAccess().getDescriptionAssignment_6_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__Group_6_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_6_2__0__Impl
	rule__Enum__Group_6_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getCategoryKeyword_6_2_0()); }
	'category'
	{ after(grammarAccess.getEnumAccess().getCategoryKeyword_6_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_6_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_6_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getCategoryAssignment_6_2_1()); }
	(rule__Enum__CategoryAssignment_6_2_1)
	{ after(grammarAccess.getEnumAccess().getCategoryAssignment_6_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__Group_11__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_11__0__Impl
	rule__Enum__Group_11__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_11__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getEnumsAssignment_11_0()); }
	(rule__Enum__EnumsAssignment_11_0)
	{ after(grammarAccess.getEnumAccess().getEnumsAssignment_11_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_11__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_11__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_11__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getGroup_11_1()); }
	(rule__Enum__Group_11_1__0)*
	{ after(grammarAccess.getEnumAccess().getGroup_11_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__Group_11_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_11_1__0__Impl
	rule__Enum__Group_11_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_11_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getCommaKeyword_11_1_0()); }
	','
	{ after(grammarAccess.getEnumAccess().getCommaKeyword_11_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_11_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__Group_11_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__Group_11_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumAccess().getEnumsAssignment_11_1_1()); }
	(rule__Enum__EnumsAssignment_11_1_1)
	{ after(grammarAccess.getEnumAccess().getEnumsAssignment_11_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumLiteral__Group__0__Impl
	rule__EnumLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumLiteralAccess().getNameAssignment_0()); }
	(rule__EnumLiteral__NameAssignment_0)
	{ after(grammarAccess.getEnumLiteralAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumLiteralAccess().getDescriptionAssignment_1()); }
	(rule__EnumLiteral__DescriptionAssignment_1)?
	{ after(grammarAccess.getEnumLiteralAccess().getDescriptionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Property__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__0__Impl
	rule__Property__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getExtensionAssignment_0()); }
	(rule__Property__ExtensionAssignment_0)?
	{ after(grammarAccess.getPropertyAccess().getExtensionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__1__Impl
	rule__Property__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getPresenceAssignment_1()); }
	(rule__Property__PresenceAssignment_1)?
	{ after(grammarAccess.getPropertyAccess().getPresenceAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__2__Impl
	rule__Property__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getMultiplicityAssignment_2()); }
	(rule__Property__MultiplicityAssignment_2)?
	{ after(grammarAccess.getPropertyAccess().getMultiplicityAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__3__Impl
	rule__Property__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getNameAssignment_3()); }
	(rule__Property__NameAssignment_3)
	{ after(grammarAccess.getPropertyAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__4__Impl
	rule__Property__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getAsKeyword_4()); }
	'as'
	{ after(grammarAccess.getPropertyAccess().getAsKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__5__Impl
	rule__Property__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getTypeAssignment_5()); }
	(rule__Property__TypeAssignment_5)
	{ after(grammarAccess.getPropertyAccess().getTypeAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__6__Impl
	rule__Property__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getGroup_6()); }
	(rule__Property__Group_6__0)?
	{ after(grammarAccess.getPropertyAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__7__Impl
	rule__Property__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getGroup_7()); }
	(rule__Property__Group_7__0)?
	{ after(grammarAccess.getPropertyAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getDescriptionAssignment_8()); }
	(rule__Property__DescriptionAssignment_8)?
	{ after(grammarAccess.getPropertyAccess().getDescriptionAssignment_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Property__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6__0__Impl
	rule__Property__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getWithKeyword_6_0()); }
	'with'
	{ after(grammarAccess.getPropertyAccess().getWithKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6__1__Impl
	rule__Property__Group_6__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getLeftCurlyBracketKeyword_6_1()); }
	'{'
	{ after(grammarAccess.getPropertyAccess().getLeftCurlyBracketKeyword_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6__2__Impl
	rule__Property__Group_6__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getPropertyAttributesAssignment_6_2()); }
	(rule__Property__PropertyAttributesAssignment_6_2)
	{ after(grammarAccess.getPropertyAccess().getPropertyAttributesAssignment_6_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6__3__Impl
	rule__Property__Group_6__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getGroup_6_3()); }
	(rule__Property__Group_6_3__0)*
	{ after(grammarAccess.getPropertyAccess().getGroup_6_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getRightCurlyBracketKeyword_6_4()); }
	'}'
	{ after(grammarAccess.getPropertyAccess().getRightCurlyBracketKeyword_6_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Property__Group_6_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6_3__0__Impl
	rule__Property__Group_6_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getCommaKeyword_6_3_0()); }
	','
	{ after(grammarAccess.getPropertyAccess().getCommaKeyword_6_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_6_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_6_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getPropertyAttributesAssignment_6_3_1()); }
	(rule__Property__PropertyAttributesAssignment_6_3_1)
	{ after(grammarAccess.getPropertyAccess().getPropertyAttributesAssignment_6_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Property__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_7__0__Impl
	rule__Property__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getLessThanSignKeyword_7_0()); }
	'<'
	{ after(grammarAccess.getPropertyAccess().getLessThanSignKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_7__1__Impl
	rule__Property__Group_7__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getConstraintRuleAssignment_7_1()); }
	(rule__Property__ConstraintRuleAssignment_7_1)
	{ after(grammarAccess.getPropertyAccess().getConstraintRuleAssignment_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_7__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Property__Group_7__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__Group_7__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyAccess().getGreaterThanSignKeyword_7_2()); }
	'>'
	{ after(grammarAccess.getPropertyAccess().getGreaterThanSignKeyword_7_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConstraintRule__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConstraintRule__Group__0__Impl
	rule__ConstraintRule__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintRuleAccess().getConstraintRuleAction_0()); }
	()
	{ after(grammarAccess.getConstraintRuleAccess().getConstraintRuleAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConstraintRule__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintRuleAccess().getGroup_1()); }
	(rule__ConstraintRule__Group_1__0)?
	{ after(grammarAccess.getConstraintRuleAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConstraintRule__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConstraintRule__Group_1__0__Impl
	rule__ConstraintRule__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintRuleAccess().getConstraintsAssignment_1_0()); }
	(rule__ConstraintRule__ConstraintsAssignment_1_0)
	{ after(grammarAccess.getConstraintRuleAccess().getConstraintsAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConstraintRule__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintRuleAccess().getGroup_1_1()); }
	(rule__ConstraintRule__Group_1_1__0)*
	{ after(grammarAccess.getConstraintRuleAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConstraintRule__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConstraintRule__Group_1_1__0__Impl
	rule__ConstraintRule__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintRuleAccess().getCommaKeyword_1_1_0()); }
	','
	{ after(grammarAccess.getConstraintRuleAccess().getCommaKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConstraintRule__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintRuleAccess().getConstraintsAssignment_1_1_1()); }
	(rule__ConstraintRule__ConstraintsAssignment_1_1_1)
	{ after(grammarAccess.getConstraintRuleAccess().getConstraintsAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BooleanPropertyAttribute__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BooleanPropertyAttribute__Group__0__Impl
	rule__BooleanPropertyAttribute__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBooleanPropertyAttributeAccess().getTypeAssignment_0()); }
	(rule__BooleanPropertyAttribute__TypeAssignment_0)
	{ after(grammarAccess.getBooleanPropertyAttributeAccess().getTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BooleanPropertyAttribute__Group__1__Impl
	rule__BooleanPropertyAttribute__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBooleanPropertyAttributeAccess().getColonKeyword_1()); }
	':'
	{ after(grammarAccess.getBooleanPropertyAttributeAccess().getColonKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BooleanPropertyAttribute__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBooleanPropertyAttributeAccess().getAlternatives_2()); }
	(rule__BooleanPropertyAttribute__Alternatives_2)
	{ after(grammarAccess.getBooleanPropertyAttributeAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumLiteralPropertyAttribute__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumLiteralPropertyAttribute__Group__0__Impl
	rule__EnumLiteralPropertyAttribute__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getTypeAssignment_0()); }
	(rule__EnumLiteralPropertyAttribute__TypeAssignment_0)
	{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumLiteralPropertyAttribute__Group__1__Impl
	rule__EnumLiteralPropertyAttribute__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getColonKeyword_1()); }
	':'
	{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getColonKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumLiteralPropertyAttribute__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueAssignment_2()); }
	(rule__EnumLiteralPropertyAttribute__ValueAssignment_2)
	{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DictionaryPropertyType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group__0__Impl
	rule__DictionaryPropertyType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryPropertyTypeAction_0()); }
	()
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryPropertyTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group__1__Impl
	rule__DictionaryPropertyType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryKeyword_1()); }
	'dictionary'
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getGroup_2()); }
	(rule__DictionaryPropertyType__Group_2__0)?
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DictionaryPropertyType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group_2__0__Impl
	rule__DictionaryPropertyType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getLeftSquareBracketKeyword_2_0()); }
	'['
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getLeftSquareBracketKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group_2__1__Impl
	rule__DictionaryPropertyType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getKeyTypeAssignment_2_1()); }
	(rule__DictionaryPropertyType__KeyTypeAssignment_2_1)
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getKeyTypeAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group_2__2__Impl
	rule__DictionaryPropertyType__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getCommaKeyword_2_2()); }
	','
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getCommaKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group_2__3__Impl
	rule__DictionaryPropertyType__Group_2__4
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getValueTypeAssignment_2_3()); }
	(rule__DictionaryPropertyType__ValueTypeAssignment_2_3)
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getValueTypeAssignment_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DictionaryPropertyType__Group_2__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__Group_2__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDictionaryPropertyTypeAccess().getRightSquareBracketKeyword_2_4()); }
	']'
	{ after(grammarAccess.getDictionaryPropertyTypeAccess().getRightSquareBracketKeyword_2_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Presence__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Presence__Group__0__Impl
	rule__Presence__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Presence__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPresenceAccess().getPresenceAction_0()); }
	()
	{ after(grammarAccess.getPresenceAccess().getPresenceAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Presence__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Presence__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Presence__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPresenceAccess().getAlternatives_1()); }
	(rule__Presence__Alternatives_1)
	{ after(grammarAccess.getPresenceAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Constraint__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Constraint__Group__0__Impl
	rule__Constraint__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Constraint__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintAccess().getTypeAssignment_0()); }
	(rule__Constraint__TypeAssignment_0)
	{ after(grammarAccess.getConstraintAccess().getTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Constraint__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Constraint__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Constraint__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConstraintAccess().getConstraintValuesAssignment_1()); }
	(rule__Constraint__ConstraintValuesAssignment_1)
	{ after(grammarAccess.getConstraintAccess().getConstraintValuesAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CATEGORY__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CATEGORY__Group__0__Impl
	rule__CATEGORY__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CATEGORY__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_0()); }
	RULE_ID
	{ after(grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CATEGORY__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CATEGORY__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CATEGORY__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCATEGORYAccess().getGroup_1()); }
	(rule__CATEGORY__Group_1__0)*
	{ after(grammarAccess.getCATEGORYAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CATEGORY__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CATEGORY__Group_1__0__Impl
	rule__CATEGORY__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CATEGORY__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCATEGORYAccess().getSolidusKeyword_1_0()); }
	'/'
	{ after(grammarAccess.getCATEGORYAccess().getSolidusKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CATEGORY__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CATEGORY__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CATEGORY__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_1_1()); }
	RULE_ID
	{ after(grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InformationModel__UnorderedGroup_7
	@init {
		int stackSize = keepStackSize();
		getUnorderedGroupHelper().enter(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
	}
:
	rule__InformationModel__UnorderedGroup_7__0
	?
;
finally {
	getUnorderedGroupHelper().leave(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
	restoreStackSize(stackSize);
}

rule__InformationModel__UnorderedGroup_7__Impl
	@init {
		int stackSize = keepStackSize();
		boolean selected = false;
	}
:
		(
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 0)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 0);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getInformationModelAccess().getGroup_7_0()); }
					(rule__InformationModel__Group_7_0__0)
					{ after(grammarAccess.getInformationModelAccess().getGroup_7_0()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 1)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 1);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getInformationModelAccess().getGroup_7_1()); }
					(rule__InformationModel__Group_7_1__0)
					{ after(grammarAccess.getInformationModelAccess().getGroup_7_1()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 2)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 2);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getInformationModelAccess().getGroup_7_2()); }
					(rule__InformationModel__Group_7_2__0)
					{ after(grammarAccess.getInformationModelAccess().getGroup_7_2()); }
				)
			)
		)
		)
;
finally {
	if (selected)
		getUnorderedGroupHelper().returnFromSelection(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
	restoreStackSize(stackSize);
}

rule__InformationModel__UnorderedGroup_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__UnorderedGroup_7__Impl
	rule__InformationModel__UnorderedGroup_7__1?
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__UnorderedGroup_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__UnorderedGroup_7__Impl
	rule__InformationModel__UnorderedGroup_7__2?
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__UnorderedGroup_7__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InformationModel__UnorderedGroup_7__Impl
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionBlock__UnorderedGroup_1
	@init {
		int stackSize = keepStackSize();
		getUnorderedGroupHelper().enter(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
	}
:
	rule__FunctionBlock__UnorderedGroup_1__0
	?
;
finally {
	getUnorderedGroupHelper().leave(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
	restoreStackSize(stackSize);
}

rule__FunctionBlock__UnorderedGroup_1__Impl
	@init {
		int stackSize = keepStackSize();
		boolean selected = false;
	}
:
		(
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 0)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 0);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getFunctionBlockAccess().getConfigurationAssignment_1_0()); }
					(rule__FunctionBlock__ConfigurationAssignment_1_0)
					{ after(grammarAccess.getFunctionBlockAccess().getConfigurationAssignment_1_0()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 1)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 1);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getFunctionBlockAccess().getStatusAssignment_1_1()); }
					(rule__FunctionBlock__StatusAssignment_1_1)
					{ after(grammarAccess.getFunctionBlockAccess().getStatusAssignment_1_1()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 2)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 2);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getFunctionBlockAccess().getFaultAssignment_1_2()); }
					(rule__FunctionBlock__FaultAssignment_1_2)
					{ after(grammarAccess.getFunctionBlockAccess().getFaultAssignment_1_2()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 3)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 3);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getFunctionBlockAccess().getGroup_1_3()); }
					(rule__FunctionBlock__Group_1_3__0)
					{ after(grammarAccess.getFunctionBlockAccess().getGroup_1_3()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 4)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 4);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getFunctionBlockAccess().getGroup_1_4()); }
					(rule__FunctionBlock__Group_1_4__0)
					{ after(grammarAccess.getFunctionBlockAccess().getGroup_1_4()); }
				)
			)
		)
		)
;
finally {
	if (selected)
		getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
	restoreStackSize(stackSize);
}

rule__FunctionBlock__UnorderedGroup_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__UnorderedGroup_1__Impl
	rule__FunctionBlock__UnorderedGroup_1__1?
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__UnorderedGroup_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__UnorderedGroup_1__Impl
	rule__FunctionBlock__UnorderedGroup_1__2?
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__UnorderedGroup_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__UnorderedGroup_1__Impl
	rule__FunctionBlock__UnorderedGroup_1__3?
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__UnorderedGroup_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__UnorderedGroup_1__Impl
	rule__FunctionBlock__UnorderedGroup_1__4?
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__UnorderedGroup_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionBlock__UnorderedGroup_1__Impl
;
finally {
	restoreStackSize(stackSize);
}


rule__Entity__UnorderedGroup_6
	@init {
		int stackSize = keepStackSize();
		getUnorderedGroupHelper().enter(grammarAccess.getEntityAccess().getUnorderedGroup_6());
	}
:
	rule__Entity__UnorderedGroup_6__0
	?
;
finally {
	getUnorderedGroupHelper().leave(grammarAccess.getEntityAccess().getUnorderedGroup_6());
	restoreStackSize(stackSize);
}

rule__Entity__UnorderedGroup_6__Impl
	@init {
		int stackSize = keepStackSize();
		boolean selected = false;
	}
:
		(
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 0)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 0);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getEntityAccess().getGroup_6_0()); }
					(rule__Entity__Group_6_0__0)
					{ after(grammarAccess.getEntityAccess().getGroup_6_0()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 1)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 1);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getEntityAccess().getGroup_6_1()); }
					(rule__Entity__Group_6_1__0)
					{ after(grammarAccess.getEntityAccess().getGroup_6_1()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 2)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 2);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getEntityAccess().getGroup_6_2()); }
					(rule__Entity__Group_6_2__0)
					{ after(grammarAccess.getEntityAccess().getGroup_6_2()); }
				)
			)
		)
		)
;
finally {
	if (selected)
		getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
	restoreStackSize(stackSize);
}

rule__Entity__UnorderedGroup_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__UnorderedGroup_6__Impl
	rule__Entity__UnorderedGroup_6__1?
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__UnorderedGroup_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__UnorderedGroup_6__Impl
	rule__Entity__UnorderedGroup_6__2?
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__UnorderedGroup_6__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Entity__UnorderedGroup_6__Impl
;
finally {
	restoreStackSize(stackSize);
}


rule__Enum__UnorderedGroup_6
	@init {
		int stackSize = keepStackSize();
		getUnorderedGroupHelper().enter(grammarAccess.getEnumAccess().getUnorderedGroup_6());
	}
:
	rule__Enum__UnorderedGroup_6__0
	?
;
finally {
	getUnorderedGroupHelper().leave(grammarAccess.getEnumAccess().getUnorderedGroup_6());
	restoreStackSize(stackSize);
}

rule__Enum__UnorderedGroup_6__Impl
	@init {
		int stackSize = keepStackSize();
		boolean selected = false;
	}
:
		(
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 0)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 0);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getEnumAccess().getGroup_6_0()); }
					(rule__Enum__Group_6_0__0)
					{ after(grammarAccess.getEnumAccess().getGroup_6_0()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 1)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 1);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getEnumAccess().getGroup_6_1()); }
					(rule__Enum__Group_6_1__0)
					{ after(grammarAccess.getEnumAccess().getGroup_6_1()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 2)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 2);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getEnumAccess().getGroup_6_2()); }
					(rule__Enum__Group_6_2__0)
					{ after(grammarAccess.getEnumAccess().getGroup_6_2()); }
				)
			)
		)
		)
;
finally {
	if (selected)
		getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
	restoreStackSize(stackSize);
}

rule__Enum__UnorderedGroup_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__UnorderedGroup_6__Impl
	rule__Enum__UnorderedGroup_6__1?
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__UnorderedGroup_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__UnorderedGroup_6__Impl
	rule__Enum__UnorderedGroup_6__2?
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__UnorderedGroup_6__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Enum__UnorderedGroup_6__Impl
;
finally {
	restoreStackSize(stackSize);
}


rule__InformationModel__LangAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getLangVortoLangVersionEnumRuleCall_2_0()); }
		ruleVortoLangVersion
		{ after(grammarAccess.getInformationModelAccess().getLangVortoLangVersionEnumRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__NamespaceAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getNamespaceQualifiedNameParserRuleCall_4_0()); }
		ruleQualifiedName
		{ after(grammarAccess.getInformationModelAccess().getNamespaceQualifiedNameParserRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__VersionAssignment_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getVersionVERSIONTerminalRuleCall_6_0()); }
		RULE_VERSION
		{ after(grammarAccess.getInformationModelAccess().getVersionVERSIONTerminalRuleCall_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__DisplaynameAssignment_7_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getDisplaynameSTRINGTerminalRuleCall_7_0_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getInformationModelAccess().getDisplaynameSTRINGTerminalRuleCall_7_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__DescriptionAssignment_7_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getDescriptionSTRINGTerminalRuleCall_7_1_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getInformationModelAccess().getDescriptionSTRINGTerminalRuleCall_7_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__CategoryAssignment_7_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getCategoryCATEGORYParserRuleCall_7_2_1_0()); }
		ruleCATEGORY
		{ after(grammarAccess.getInformationModelAccess().getCategoryCATEGORYParserRuleCall_7_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__ReferencesAssignment_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getReferencesModelReferenceParserRuleCall_8_0()); }
		ruleModelReference
		{ after(grammarAccess.getInformationModelAccess().getReferencesModelReferenceParserRuleCall_8_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__NameAssignment_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getNameIDTerminalRuleCall_10_0()); }
		RULE_ID
		{ after(grammarAccess.getInformationModelAccess().getNameIDTerminalRuleCall_10_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InformationModel__PropertiesAssignment_12_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInformationModelAccess().getPropertiesFunctionblockPropertyParserRuleCall_12_2_0()); }
		ruleFunctionblockProperty
		{ after(grammarAccess.getInformationModelAccess().getPropertiesFunctionblockPropertyParserRuleCall_12_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__PresenceAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getPresencePresenceParserRuleCall_0_0()); }
		rulePresence
		{ after(grammarAccess.getFunctionblockPropertyAccess().getPresencePresenceParserRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__MultiplicityAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getMultiplicityMultipleKeyword_1_0()); }
		(
			{ before(grammarAccess.getFunctionblockPropertyAccess().getMultiplicityMultipleKeyword_1_0()); }
			'multiple'
			{ after(grammarAccess.getFunctionblockPropertyAccess().getMultiplicityMultipleKeyword_1_0()); }
		)
		{ after(grammarAccess.getFunctionblockPropertyAccess().getMultiplicityMultipleKeyword_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__NameAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getNameIDTerminalRuleCall_2_0()); }
		RULE_ID
		{ after(grammarAccess.getFunctionblockPropertyAccess().getNameIDTerminalRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__TypeAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getTypeFunctionblockModelCrossReference_4_0()); }
		(
			{ before(grammarAccess.getFunctionblockPropertyAccess().getTypeFunctionblockModelQualifiedNameParserRuleCall_4_0_1()); }
			ruleQualifiedName
			{ after(grammarAccess.getFunctionblockPropertyAccess().getTypeFunctionblockModelQualifiedNameParserRuleCall_4_0_1()); }
		)
		{ after(grammarAccess.getFunctionblockPropertyAccess().getTypeFunctionblockModelCrossReference_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__ExtendedFunctionBlockAssignment_5_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getExtendedFunctionBlockFunctionBlockParserRuleCall_5_2_0()); }
		ruleFunctionBlock
		{ after(grammarAccess.getFunctionblockPropertyAccess().getExtendedFunctionBlockFunctionBlockParserRuleCall_5_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionblockProperty__DescriptionAssignment_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionblockPropertyAccess().getDescriptionSTRINGTerminalRuleCall_6_0()); }
		RULE_STRING
		{ after(grammarAccess.getFunctionblockPropertyAccess().getDescriptionSTRINGTerminalRuleCall_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__ConfigurationAssignment_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionBlockAccess().getConfigurationConfigurationParserRuleCall_1_0_0()); }
		ruleConfiguration
		{ after(grammarAccess.getFunctionBlockAccess().getConfigurationConfigurationParserRuleCall_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__StatusAssignment_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionBlockAccess().getStatusStatusParserRuleCall_1_1_0()); }
		ruleStatus
		{ after(grammarAccess.getFunctionBlockAccess().getStatusStatusParserRuleCall_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__FaultAssignment_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionBlockAccess().getFaultFaultParserRuleCall_1_2_0()); }
		ruleFault
		{ after(grammarAccess.getFunctionBlockAccess().getFaultFaultParserRuleCall_1_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__EventsAssignment_1_3_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionBlockAccess().getEventsEventParserRuleCall_1_3_2_0()); }
		ruleEvent
		{ after(grammarAccess.getFunctionBlockAccess().getEventsEventParserRuleCall_1_3_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionBlock__OperationsAssignment_1_4_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionBlockAccess().getOperationsOperationParserRuleCall_1_4_2_0()); }
		ruleOperation
		{ after(grammarAccess.getFunctionBlockAccess().getOperationsOperationParserRuleCall_1_4_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Configuration__PropertiesAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConfigurationAccess().getPropertiesPropertyParserRuleCall_3_0()); }
		ruleProperty
		{ after(grammarAccess.getConfigurationAccess().getPropertiesPropertyParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Status__PropertiesAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatusAccess().getPropertiesPropertyParserRuleCall_3_0()); }
		ruleProperty
		{ after(grammarAccess.getStatusAccess().getPropertiesPropertyParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Fault__PropertiesAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFaultAccess().getPropertiesPropertyParserRuleCall_3_0()); }
		ruleProperty
		{ after(grammarAccess.getFaultAccess().getPropertiesPropertyParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__ExtensionAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getExtensionExtensionKeyword_0_0()); }
		(
			{ before(grammarAccess.getOperationAccess().getExtensionExtensionKeyword_0_0()); }
			'extension'
			{ after(grammarAccess.getOperationAccess().getExtensionExtensionKeyword_0_0()); }
		)
		{ after(grammarAccess.getOperationAccess().getExtensionExtensionKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__PresenceAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getPresencePresenceParserRuleCall_1_0()); }
		rulePresence
		{ after(grammarAccess.getOperationAccess().getPresencePresenceParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__BreakableAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getBreakableBreakableKeyword_2_0()); }
		(
			{ before(grammarAccess.getOperationAccess().getBreakableBreakableKeyword_2_0()); }
			'breakable'
			{ after(grammarAccess.getOperationAccess().getBreakableBreakableKeyword_2_0()); }
		)
		{ after(grammarAccess.getOperationAccess().getBreakableBreakableKeyword_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__NameAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getNameValidIDParserRuleCall_3_0()); }
		ruleValidID
		{ after(grammarAccess.getOperationAccess().getNameValidIDParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__ParamsAssignment_5_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getParamsParamParserRuleCall_5_0_0()); }
		ruleParam
		{ after(grammarAccess.getOperationAccess().getParamsParamParserRuleCall_5_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__ParamsAssignment_5_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getParamsParamParserRuleCall_5_1_1_0()); }
		ruleParam
		{ after(grammarAccess.getOperationAccess().getParamsParamParserRuleCall_5_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__ReturnTypeAssignment_7_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getReturnTypeReturnTypeParserRuleCall_7_1_0()); }
		ruleReturnType
		{ after(grammarAccess.getOperationAccess().getReturnTypeReturnTypeParserRuleCall_7_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Operation__DescriptionAssignment_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOperationAccess().getDescriptionSTRINGTerminalRuleCall_8_0()); }
		RULE_STRING
		{ after(grammarAccess.getOperationAccess().getDescriptionSTRINGTerminalRuleCall_8_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__MultiplicityAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
		(
			{ before(grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
			'multiple'
			{ after(grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
		)
		{ after(grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__ReturnTypeAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnDictonaryTypeAccess().getReturnTypeDictionaryPropertyTypeParserRuleCall_1_0()); }
		ruleDictionaryPropertyType
		{ after(grammarAccess.getReturnDictonaryTypeAccess().getReturnTypeDictionaryPropertyTypeParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnDictonaryType__ConstraintRuleAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnDictonaryTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0()); }
		ruleConstraintRule
		{ after(grammarAccess.getReturnDictonaryTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__MultiplicityAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnObjectTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
		(
			{ before(grammarAccess.getReturnObjectTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
			'multiple'
			{ after(grammarAccess.getReturnObjectTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
		)
		{ after(grammarAccess.getReturnObjectTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__ReturnTypeAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnObjectTypeAccess().getReturnTypeTypeCrossReference_1_0()); }
		(
			{ before(grammarAccess.getReturnObjectTypeAccess().getReturnTypeTypeQualifiedNameParserRuleCall_1_0_1()); }
			ruleQualifiedName
			{ after(grammarAccess.getReturnObjectTypeAccess().getReturnTypeTypeQualifiedNameParserRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getReturnObjectTypeAccess().getReturnTypeTypeCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnObjectType__ConstraintRuleAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnObjectTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0()); }
		ruleConstraintRule
		{ after(grammarAccess.getReturnObjectTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__MultiplicityAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
		(
			{ before(grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
			'multiple'
			{ after(grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
		)
		{ after(grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityMultipleKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__ReturnTypeAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnPrimitiveTypeAccess().getReturnTypePrimitiveTypeEnumRuleCall_1_0()); }
		rulePrimitiveType
		{ after(grammarAccess.getReturnPrimitiveTypeAccess().getReturnTypePrimitiveTypeEnumRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnPrimitiveType__ConstraintRuleAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnPrimitiveTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0()); }
		ruleConstraintRule
		{ after(grammarAccess.getReturnPrimitiveTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__MultiplicityAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictonaryParamAccess().getMultiplicityMultipleKeyword_0_0()); }
		(
			{ before(grammarAccess.getDictonaryParamAccess().getMultiplicityMultipleKeyword_0_0()); }
			'multiple'
			{ after(grammarAccess.getDictonaryParamAccess().getMultiplicityMultipleKeyword_0_0()); }
		)
		{ after(grammarAccess.getDictonaryParamAccess().getMultiplicityMultipleKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictonaryParamAccess().getNameValidIDParserRuleCall_1_0()); }
		ruleValidID
		{ after(grammarAccess.getDictonaryParamAccess().getNameValidIDParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__TypeAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictonaryParamAccess().getTypeDictionaryPropertyTypeParserRuleCall_3_0()); }
		ruleDictionaryPropertyType
		{ after(grammarAccess.getDictonaryParamAccess().getTypeDictionaryPropertyTypeParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__ConstraintRuleAssignment_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictonaryParamAccess().getConstraintRuleConstraintRuleParserRuleCall_4_1_0()); }
		ruleConstraintRule
		{ after(grammarAccess.getDictonaryParamAccess().getConstraintRuleConstraintRuleParserRuleCall_4_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictonaryParam__DescriptionAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictonaryParamAccess().getDescriptionSTRINGTerminalRuleCall_5_0()); }
		RULE_STRING
		{ after(grammarAccess.getDictonaryParamAccess().getDescriptionSTRINGTerminalRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__MultiplicityAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveParamAccess().getMultiplicityMultipleKeyword_0_0()); }
		(
			{ before(grammarAccess.getPrimitiveParamAccess().getMultiplicityMultipleKeyword_0_0()); }
			'multiple'
			{ after(grammarAccess.getPrimitiveParamAccess().getMultiplicityMultipleKeyword_0_0()); }
		)
		{ after(grammarAccess.getPrimitiveParamAccess().getMultiplicityMultipleKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveParamAccess().getNameValidIDParserRuleCall_1_0()); }
		ruleValidID
		{ after(grammarAccess.getPrimitiveParamAccess().getNameValidIDParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__TypeAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveParamAccess().getTypePrimitiveTypeEnumRuleCall_3_0()); }
		rulePrimitiveType
		{ after(grammarAccess.getPrimitiveParamAccess().getTypePrimitiveTypeEnumRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__ConstraintRuleAssignment_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveParamAccess().getConstraintRuleConstraintRuleParserRuleCall_4_1_0()); }
		ruleConstraintRule
		{ after(grammarAccess.getPrimitiveParamAccess().getConstraintRuleConstraintRuleParserRuleCall_4_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveParam__DescriptionAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveParamAccess().getDescriptionSTRINGTerminalRuleCall_5_0()); }
		RULE_STRING
		{ after(grammarAccess.getPrimitiveParamAccess().getDescriptionSTRINGTerminalRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__MultiplicityAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRefParamAccess().getMultiplicityMultipleKeyword_0_0()); }
		(
			{ before(grammarAccess.getRefParamAccess().getMultiplicityMultipleKeyword_0_0()); }
			'multiple'
			{ after(grammarAccess.getRefParamAccess().getMultiplicityMultipleKeyword_0_0()); }
		)
		{ after(grammarAccess.getRefParamAccess().getMultiplicityMultipleKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRefParamAccess().getNameValidIDParserRuleCall_1_0()); }
		ruleValidID
		{ after(grammarAccess.getRefParamAccess().getNameValidIDParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__TypeAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRefParamAccess().getTypeTypeCrossReference_3_0()); }
		(
			{ before(grammarAccess.getRefParamAccess().getTypeTypeQualifiedNameParserRuleCall_3_0_1()); }
			ruleQualifiedName
			{ after(grammarAccess.getRefParamAccess().getTypeTypeQualifiedNameParserRuleCall_3_0_1()); }
		)
		{ after(grammarAccess.getRefParamAccess().getTypeTypeCrossReference_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefParam__DescriptionAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRefParamAccess().getDescriptionSTRINGTerminalRuleCall_4_0()); }
		RULE_STRING
		{ after(grammarAccess.getRefParamAccess().getDescriptionSTRINGTerminalRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__NameAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEventAccess().getNameIDTerminalRuleCall_0_0()); }
		RULE_ID
		{ after(grammarAccess.getEventAccess().getNameIDTerminalRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Event__PropertiesAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEventAccess().getPropertiesPropertyParserRuleCall_2_0()); }
		ruleProperty
		{ after(grammarAccess.getEventAccess().getPropertiesPropertyParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__ImportedNamespaceAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getModelReferenceAccess().getImportedNamespaceQualifiedNameParserRuleCall_1_0()); }
		ruleQualifiedName
		{ after(grammarAccess.getModelReferenceAccess().getImportedNamespaceQualifiedNameParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelReference__VersionAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getModelReferenceAccess().getVersionVERSIONTerminalRuleCall_3_0()); }
		RULE_VERSION
		{ after(grammarAccess.getModelReferenceAccess().getVersionVERSIONTerminalRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__LangAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getLangVortoLangVersionEnumRuleCall_1_0()); }
		ruleVortoLangVersion
		{ after(grammarAccess.getEntityAccess().getLangVortoLangVersionEnumRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__NamespaceAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getNamespaceQualifiedNameParserRuleCall_3_0()); }
		ruleQualifiedName
		{ after(grammarAccess.getEntityAccess().getNamespaceQualifiedNameParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__VersionAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getVersionVERSIONTerminalRuleCall_5_0()); }
		RULE_VERSION
		{ after(grammarAccess.getEntityAccess().getVersionVERSIONTerminalRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__DisplaynameAssignment_6_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getEntityAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__DescriptionAssignment_6_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getEntityAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__CategoryAssignment_6_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0()); }
		ruleCATEGORY
		{ after(grammarAccess.getEntityAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__ReferencesAssignment_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getReferencesModelReferenceParserRuleCall_7_0()); }
		ruleModelReference
		{ after(grammarAccess.getEntityAccess().getReferencesModelReferenceParserRuleCall_7_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__NameAssignment_9
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_9_0()); }
		RULE_ID
		{ after(grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_9_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__SuperTypeAssignment_10_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_10_1_0()); }
		(
			{ before(grammarAccess.getEntityAccess().getSuperTypeEntityQualifiedNameParserRuleCall_10_1_0_1()); }
			ruleQualifiedName
			{ after(grammarAccess.getEntityAccess().getSuperTypeEntityQualifiedNameParserRuleCall_10_1_0_1()); }
		)
		{ after(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_10_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Entity__PropertiesAssignment_12
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEntityAccess().getPropertiesPropertyParserRuleCall_12_0()); }
		ruleProperty
		{ after(grammarAccess.getEntityAccess().getPropertiesPropertyParserRuleCall_12_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__LangAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getLangVortoLangVersionEnumRuleCall_1_0()); }
		ruleVortoLangVersion
		{ after(grammarAccess.getEnumAccess().getLangVortoLangVersionEnumRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__NamespaceAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getNamespaceQualifiedNameParserRuleCall_3_0()); }
		ruleQualifiedName
		{ after(grammarAccess.getEnumAccess().getNamespaceQualifiedNameParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__VersionAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getVersionVERSIONTerminalRuleCall_5_0()); }
		RULE_VERSION
		{ after(grammarAccess.getEnumAccess().getVersionVERSIONTerminalRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__DisplaynameAssignment_6_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getEnumAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__DescriptionAssignment_6_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getEnumAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__CategoryAssignment_6_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0()); }
		ruleCATEGORY
		{ after(grammarAccess.getEnumAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__ReferencesAssignment_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getReferencesModelReferenceParserRuleCall_7_0()); }
		ruleModelReference
		{ after(grammarAccess.getEnumAccess().getReferencesModelReferenceParserRuleCall_7_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__NameAssignment_9
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getNameIDTerminalRuleCall_9_0()); }
		RULE_ID
		{ after(grammarAccess.getEnumAccess().getNameIDTerminalRuleCall_9_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__EnumsAssignment_11_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_0_0()); }
		ruleEnumLiteral
		{ after(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Enum__EnumsAssignment_11_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_1_1_0()); }
		ruleEnumLiteral
		{ after(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteral__NameAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumLiteralAccess().getNameIDTerminalRuleCall_0_0()); }
		RULE_ID
		{ after(grammarAccess.getEnumLiteralAccess().getNameIDTerminalRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteral__DescriptionAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumLiteralAccess().getDescriptionSTRINGTerminalRuleCall_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getEnumLiteralAccess().getDescriptionSTRINGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__ExtensionAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getExtensionExtensionKeyword_0_0()); }
		(
			{ before(grammarAccess.getPropertyAccess().getExtensionExtensionKeyword_0_0()); }
			'extension'
			{ after(grammarAccess.getPropertyAccess().getExtensionExtensionKeyword_0_0()); }
		)
		{ after(grammarAccess.getPropertyAccess().getExtensionExtensionKeyword_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__PresenceAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getPresencePresenceParserRuleCall_1_0()); }
		rulePresence
		{ after(grammarAccess.getPropertyAccess().getPresencePresenceParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__MultiplicityAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getMultiplicityMultipleKeyword_2_0()); }
		(
			{ before(grammarAccess.getPropertyAccess().getMultiplicityMultipleKeyword_2_0()); }
			'multiple'
			{ after(grammarAccess.getPropertyAccess().getMultiplicityMultipleKeyword_2_0()); }
		)
		{ after(grammarAccess.getPropertyAccess().getMultiplicityMultipleKeyword_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__NameAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getNameValidIDParserRuleCall_3_0()); }
		ruleValidID
		{ after(grammarAccess.getPropertyAccess().getNameValidIDParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__TypeAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getTypePropertyTypeParserRuleCall_5_0()); }
		rulePropertyType
		{ after(grammarAccess.getPropertyAccess().getTypePropertyTypeParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__PropertyAttributesAssignment_6_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_2_0()); }
		rulePropertyAttribute
		{ after(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__PropertyAttributesAssignment_6_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_3_1_0()); }
		rulePropertyAttribute
		{ after(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__ConstraintRuleAssignment_7_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getConstraintRuleConstraintRuleParserRuleCall_7_1_0()); }
		ruleConstraintRule
		{ after(grammarAccess.getPropertyAccess().getConstraintRuleConstraintRuleParserRuleCall_7_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Property__DescriptionAssignment_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAccess().getDescriptionSTRINGTerminalRuleCall_8_0()); }
		RULE_STRING
		{ after(grammarAccess.getPropertyAccess().getDescriptionSTRINGTerminalRuleCall_8_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__ConstraintsAssignment_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_0_0()); }
		ruleConstraint
		{ after(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConstraintRule__ConstraintsAssignment_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_1_1_0()); }
		ruleConstraint
		{ after(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__TypeAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBooleanPropertyAttributeAccess().getTypeBooleanPropertyAttributeTypeEnumRuleCall_0_0()); }
		ruleBooleanPropertyAttributeType
		{ after(grammarAccess.getBooleanPropertyAttributeAccess().getTypeBooleanPropertyAttributeTypeEnumRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanPropertyAttribute__ValueAssignment_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBooleanPropertyAttributeAccess().getValueTrueKeyword_2_0_0()); }
		(
			{ before(grammarAccess.getBooleanPropertyAttributeAccess().getValueTrueKeyword_2_0_0()); }
			'true'
			{ after(grammarAccess.getBooleanPropertyAttributeAccess().getValueTrueKeyword_2_0_0()); }
		)
		{ after(grammarAccess.getBooleanPropertyAttributeAccess().getValueTrueKeyword_2_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__TypeAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getTypeEnumLiteralPropertyAttributeTypeEnumRuleCall_0_0()); }
		ruleEnumLiteralPropertyAttributeType
		{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getTypeEnumLiteralPropertyAttributeTypeEnumRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumLiteralPropertyAttribute__ValueAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueEnumLiteralCrossReference_2_0()); }
		(
			{ before(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueEnumLiteralQualifiedNameParserRuleCall_2_0_1()); }
			ruleQualifiedName
			{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueEnumLiteralQualifiedNameParserRuleCall_2_0_1()); }
		)
		{ after(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueEnumLiteralCrossReference_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitivePropertyType__TypeAssignment
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitivePropertyTypeAccess().getTypePrimitiveTypeEnumRuleCall_0()); }
		rulePrimitiveType
		{ after(grammarAccess.getPrimitivePropertyTypeAccess().getTypePrimitiveTypeEnumRuleCall_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectPropertyType__TypeAssignment
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getObjectPropertyTypeAccess().getTypeTypeCrossReference_0()); }
		(
			{ before(grammarAccess.getObjectPropertyTypeAccess().getTypeTypeQualifiedNameParserRuleCall_0_1()); }
			ruleQualifiedName
			{ after(grammarAccess.getObjectPropertyTypeAccess().getTypeTypeQualifiedNameParserRuleCall_0_1()); }
		)
		{ after(grammarAccess.getObjectPropertyTypeAccess().getTypeTypeCrossReference_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__KeyTypeAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictionaryPropertyTypeAccess().getKeyTypePropertyTypeParserRuleCall_2_1_0()); }
		rulePropertyType
		{ after(grammarAccess.getDictionaryPropertyTypeAccess().getKeyTypePropertyTypeParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DictionaryPropertyType__ValueTypeAssignment_2_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDictionaryPropertyTypeAccess().getValueTypePropertyTypeParserRuleCall_2_3_0()); }
		rulePropertyType
		{ after(grammarAccess.getDictionaryPropertyTypeAccess().getValueTypePropertyTypeParserRuleCall_2_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Presence__MandatoryAssignment_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPresenceAccess().getMandatoryMandatoryKeyword_1_0_0()); }
		(
			{ before(grammarAccess.getPresenceAccess().getMandatoryMandatoryKeyword_1_0_0()); }
			'mandatory'
			{ after(grammarAccess.getPresenceAccess().getMandatoryMandatoryKeyword_1_0_0()); }
		)
		{ after(grammarAccess.getPresenceAccess().getMandatoryMandatoryKeyword_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Constraint__TypeAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConstraintAccess().getTypeConstraintIntervalTypeEnumRuleCall_0_0()); }
		ruleConstraintIntervalType
		{ after(grammarAccess.getConstraintAccess().getTypeConstraintIntervalTypeEnumRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Constraint__ConstraintValuesAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConstraintAccess().getConstraintValuesIntervalTypeParserRuleCall_1_0()); }
		ruleIntervalType
		{ after(grammarAccess.getConstraintAccess().getConstraintValuesIntervalTypeParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_SIGNEDINT : '-' RULE_INT;

RULE_FLOAT : '-'? RULE_INT '.' RULE_INT;

fragment RULE_DATE : '0'..'9' '0'..'9' '0'..'9' '0'..'9' '-' '0'..'9' '0'..'9' '-' '0'..'9' '0'..'9';

fragment RULE_TIME : '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9' RULE_TIMEZONE?;

fragment RULE_TIMEZONE : ('Z'|('+'|'-') '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9');

RULE_DATETIME : RULE_DATE 'T' RULE_TIME;

RULE_VERSION : ('0'..'9')* '.' ('0'..'9')* '.' ('0'..'9')* ('-' RULE_ID)?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
