/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.RunOnServerWizardFragment;

public class RunOnServerWizard
extends TaskWizard {
    public RunOnServerWizard(IModule module, String launchMode, IModuleArtifact moduleArtifact) {
        super(Messages.wizRunOnServerTitle, new RunOnServerWizardFragment(module, launchMode, moduleArtifact));
        this.setNeedsProgressMonitor(true);
        if ("debug".equals(launchMode)) {
            this.setWindowTitle(Messages.wizDebugOnServerTitle);
        } else if ("profile".equals(launchMode)) {
            this.setWindowTitle(Messages.wizProfileOnServerTitle);
        }
        this.getTaskModel().putObject("launch-mode", (Object)launchMode);
    }

    public RunOnServerWizard(IServer server, String launchMode, IModuleArtifact moduleArtifact) {
        super(Messages.wizRunOnServerTitle, new RunOnServerWizardFragment(server, launchMode, moduleArtifact));
        this.setNeedsProgressMonitor(true);
        if ("debug".equals(launchMode)) {
            this.setWindowTitle(Messages.wizDebugOnServerTitle);
        } else if ("profile".equals(launchMode)) {
            this.setWindowTitle(Messages.wizProfileOnServerTitle);
        }
        this.getTaskModel().putObject("server", (Object)server);
        this.getTaskModel().putObject("launch-mode", (Object)launchMode);
        this.addPages();
    }

    public IServer getServer() {
        try {
            return (IServer)this.getTaskModel().getObject("server");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isPreferredServer() {
        try {
            Boolean b = (Boolean)this.getTaskModel().getObject("defaultServer");
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IClient getSelectedClient() {
        try {
            return (IClient)this.getTaskModel().getObject("client");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ILaunchableAdapter getLaunchableAdapter() {
        try {
            return (ILaunchableAdapter)this.getTaskModel().getObject("launchableAdapter");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean shouldAppear() {
        return this.getServer() == null || this.hasTasks() || this.hasClients();
    }

    protected boolean hasTasks() {
        try {
            Boolean b = (Boolean)this.getTaskModel().getObject("hasTasks");
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean hasClients() {
        try {
            Boolean b = (Boolean)this.getTaskModel().getObject("hasClients");
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

