/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.page.TasksLayout;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class TasksComposite
extends ScrolledComposite {
    protected IWizardHandle wizard;
    protected List tasks;
    protected boolean created;

    public TasksComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 768);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizTaskTitle);
        wizard.setDescription(Messages.wizTaskDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("selectServer"));
    }

    public void setTasks(List tasks) {
        this.tasks = tasks;
        Control[] children = this.getChildren();
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                children[i].dispose();
                ++i;
            }
        }
        this.created = false;
    }

    public void createControl() {
        if (this.created) {
            return;
        }
        this.setLayoutData(new GridData(1808));
        Composite comp = new Composite((Composite)this, 0);
        this.setContent((Control)comp);
        TasksLayout layout = new TasksLayout(SWTUtil.convertVerticalDLUsToPixels((Composite)this, 4));
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.wst.server.ui.sstw0000");
        int size = 0;
        if (this.tasks != null) {
            size = this.tasks.size();
        }
        int i = 0;
        while (i < size) {
            Object obj = this.tasks.get(i);
            final TasksWizardFragment.TaskInfo sti = (TasksWizardFragment.TaskInfo)obj;
            final Button checkbox = new Button(comp, 96);
            String label = sti.task2.getLabel();
            if (label != null) {
                checkbox.setText(label);
            } else {
                checkbox.setText(Messages.elementUnknownName);
            }
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    sti.setSelected(checkbox.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    sti.setSelected(checkbox.getSelection());
                }
            });
            Label description = new Label(comp, 64);
            String desc = sti.task2.getDescription();
            if (desc != null) {
                description.setText(desc);
            } else {
                description.setText(Messages.elementUnknownName);
            }
            if (sti.kind == 2) {
                checkbox.setSelection(true);
                checkbox.setEnabled(false);
                description.setEnabled(false);
            } else {
                checkbox.setSelection(sti.isSelected());
            }
            ++i;
        }
        if (size == 0) {
            Trace.trace((byte)3, "Task composite appeared with no tasks!");
        }
        Dialog.applyDialogFont((Control)this);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setMinSize(comp.computeSize(-1, -1));
        this.layout(true, true);
        this.created = true;
    }
}

