/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.wst.common.internal.emf.utilities.DanglingHREFException;
import org.eclipse.wst.common.internal.emf.utilities.IsLoadingProxyAdapter;
import org.eclipse.wst.common.internal.emf.utilities.WFTUtilsResourceHandler;

public class ExtendedEcoreUtil
extends EcoreUtil {
    private static FileNotFoundDetector FILE_NOT_FOUND_DETECTOR;
    private static String NAME_ATTRIBUTE_STRING;

    static {
        NAME_ATTRIBUTE_STRING = "name";
    }

    public static void setFileNotFoundDetector(FileNotFoundDetector detector) {
        FILE_NOT_FOUND_DETECTOR = detector;
    }

    public static FileNotFoundDetector getFileNotFoundDetector() {
        if (FILE_NOT_FOUND_DETECTOR == null) {
            FILE_NOT_FOUND_DETECTOR = new FileNotFoundDetector(){

                public boolean isFileNotFound(WrappedException wrappedEx) {
                    return ExtendedEcoreUtil.getInnerFileNotFoundException(wrappedEx) != null;
                }
            };
        }
        return FILE_NOT_FOUND_DETECTOR;
    }

    public static FileNotFoundException getInnerFileNotFoundException(WrappedException wrappedEx) {
        if (wrappedEx.exception() instanceof FileNotFoundException) {
            return (FileNotFoundException)wrappedEx.exception();
        }
        if (wrappedEx.exception() instanceof WrappedException) {
            return ExtendedEcoreUtil.getInnerFileNotFoundException((WrappedException)wrappedEx.exception());
        }
        return null;
    }

    public static void eSetOrAdd(EObject obj, EStructuralFeature feature, Object value) {
        ExtendedEcoreUtil.eSetOrAdd(obj, feature, value, 0);
    }

    public static void eSetOrAdd(EObject obj, EStructuralFeature feature, Object value, int newIndex) {
        if (feature.isMany() && value != null) {
            List featureList = (List)obj.eGet(feature);
            if (newIndex >= 0 && newIndex < featureList.size()) {
                featureList.add(newIndex, value);
            } else {
                featureList.add(value);
            }
        } else {
            obj.eSet(feature, value);
        }
    }

    public static void eUnsetOrRemove(EObject obj, EStructuralFeature feature, Object value) {
        if (feature == null || feature.isMany()) {
            ((List)obj.eGet(feature)).remove(value);
        } else {
            obj.eUnset(feature);
        }
    }

    public static boolean endsWith(URI sourceUri, URI testUri) {
        String[] testSegments;
        int i;
        String[] sourceSegments = sourceUri.segments();
        int j = sourceSegments.length;
        if (j >= (i = (testSegments = testUri.segments()).length)) {
            boolean test = true;
            while (test && i > 0) {
                test = testSegments[--i].equals(sourceSegments[--j]);
            }
            return test;
        }
        return false;
    }

    public static String getName(EObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ENamedElement) {
            return ((ENamedElement)obj).getName();
        }
        EList allAtts = obj.eClass().getEAllAttributes();
        int size = allAtts.size();
        EAttribute nameAttribute = null;
        int i = 0;
        while (i < size) {
            EAttribute att = (EAttribute)allAtts.get(i);
            if (NAME_ATTRIBUTE_STRING.equals(att.getName())) {
                nameAttribute = att;
                break;
            }
            ++i;
        }
        if (nameAttribute != null) {
            return (String)obj.eGet(nameAttribute);
        }
        return null;
    }

    public static void addLoadingTag(Resource resource) {
    }

    public static void removeLoadingTag(Resource resource) {
    }

    public static boolean isLoading(Resource resource) {
        return resource != null ? ((Resource.Internal)resource).isLoading() : false;
    }

    public static Adapter createAdapterForLoading(Adapter targetAdapter, EObject targetObject) {
        Resource res = targetObject.eResource();
        if (res == null || ExtendedEcoreUtil.isLoading(res)) {
            return new IsLoadingProxyAdapter(targetAdapter, targetObject);
        }
        return targetAdapter;
    }

    public static void preRegisterPackage(String nsPrefix, EPackage.Descriptor descriptor) {
        if (!EPackage.Registry.INSTANCE.containsKey((Object)nsPrefix)) {
            EPackage.Registry.INSTANCE.put((Object)nsPrefix, (Object)descriptor);
        }
    }

    public static Adapter getAdapter(EObject anObject, List adapters, Object type) {
        Object[] adaptArray = ((BasicNotifierImpl.EAdapterList)adapters).data();
        if (adaptArray == null) {
            return null;
        }
        int i = 0;
        while (i < adaptArray.length) {
            Adapter adapter = (Adapter)adaptArray[i];
            if (adapter != null && adapter.isAdapterForType(type)) {
                return adapter;
            }
            ++i;
        }
        return null;
    }

    public static void unload(EObject root) {
        Resource res = root.eResource();
        EObject container = root.eContainer();
        if (res != null) {
            ExtendedEcoreUtil.becomeProxy(root, res);
        }
        if (container == null) {
            if (res != null) {
                res.getContents().remove((Object)root);
            } else {
                EReference feature = root.eContainmentFeature();
                if (feature != null) {
                    ExtendedEcoreUtil.eUnsetOrRemove(container, (EStructuralFeature)feature, root);
                }
            }
        }
    }

    public static void becomeProxy(EObject root, Resource res) {
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            ExtendedEcoreUtil.doBecomeProxy((InternalEObject)iter.next(), res);
        }
        ExtendedEcoreUtil.doBecomeProxy((InternalEObject)root, res);
    }

    protected static void doBecomeProxy(InternalEObject p, Resource res) {
        String id = res.getURIFragment((EObject)p);
        p.eSetProxyURI(res.getURI().appendFragment(id));
        if (res instanceof XMLResource) {
            ((XMLResource)res).setID((EObject)p, null);
        }
        p.eAdapters().clear();
    }

    public static void removeProxy(EObject root, Resource res) {
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            ExtendedEcoreUtil.doRemoveProxy((InternalEObject)iter.next(), res);
        }
        ExtendedEcoreUtil.doRemoveProxy((InternalEObject)root, res);
    }

    protected static void doRemoveProxy(InternalEObject p, Resource res) {
        String id = p.eProxyURI().fragment();
        if (res instanceof XMLResource) {
            ((XMLResource)res).setID((EObject)p, id);
        }
        p.eSetProxyURI(null);
    }

    public static void checkProxy(EObject object) throws DanglingHREFException {
        if (object == null || !object.eIsProxy()) {
            return;
        }
        String msg = WFTUtilsResourceHandler.getString(WFTUtilsResourceHandler.DANGLING_HREF_ERROR_, new Object[]{((InternalEObject)object).eProxyURI()});
        throw new DanglingHREFException(msg);
    }

    public static boolean valueChanged(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 == null || !o1.equals(o2);
    }

    public static class ESynchronizedAdapterList
    extends BasicNotifierImpl.EAdapterList {
        private static final long serialVersionUID = 7855438339187540718L;

        public ESynchronizedAdapterList(Notifier notifier) {
            super(notifier);
        }

        public synchronized boolean add(Object object) {
            return super.add(object);
        }

        public synchronized void add(int index, Object object) {
            super.add(index, object);
        }

        public synchronized boolean addAll(Collection collection) {
            return super.addAll(collection);
        }

        public synchronized boolean remove(Object object) {
            return super.remove(object);
        }

        public synchronized Object remove(int index) {
            return super.remove(index);
        }

        public synchronized boolean removeAll(Collection collection) {
            return super.removeAll(collection);
        }

        public synchronized void clear() {
            super.clear();
        }

        public synchronized Object set(int index, Object object) {
            return super.set(index, object);
        }

        public synchronized void move(int newPosition, Object object) {
            super.move(newPosition, object);
        }

        public synchronized Object move(int newPosition, int oldPosition) {
            return super.move(newPosition, oldPosition);
        }
    }

    public static interface FileNotFoundDetector {
        public boolean isFileNotFound(WrappedException var1);
    }
}

