/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.web.operations.AddListenerOperation;
import org.eclipse.jst.j2ee.internal.web.operations.NewWebClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewListenerClassDataModelProvider
extends NewWebClassDataModelProvider {
    public static final String[] LISTENER_INTERFACES = new String[]{"javax.servlet.ServletContextListener", "javax.servlet.ServletContextAttributeListener", "javax.servlet.http.HttpSessionListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionBindingListener", "javax.servlet.ServletRequestListener", "javax.servlet.ServletRequestAttributeListener"};

    public IDataModelOperation getDefaultOperation() {
        return new AddListenerOperation(this.getDataModel());
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES") && !this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return this.validateListeners();
        }
        return super.validate(propertyName);
    }

    private IStatus validateListeners() {
        boolean atLeastOneSelected = false;
        Object value = this.model.getProperty("NewJavaClassDataModel.INTERFACES");
        if (value != null && value instanceof List) {
            List interfaces = (List)value;
            String[] stringArray = LISTENER_INTERFACES;
            int n = LISTENER_INTERFACES.length;
            int n2 = 0;
            while (n2 < n) {
                String iface = stringArray[n2];
                if (interfaces.contains(iface)) {
                    atLeastOneSelected = true;
                    break;
                }
                ++n2;
            }
        }
        if (atLeastOneSelected) {
            return WTPCommonPlugin.OK_STATUS;
        }
        String msg = WebMessages.ERR_NO_LISTENER_SELECTED;
        return WTPCommonPlugin.createErrorStatus((String)msg);
    }
}

