/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.StackFrameImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoResponse;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;

public class ThreadReferenceImpl
extends MirrorImpl
implements ThreadReference {
    private Number threadId;
    private List frames;
    private int status = 1;
    private boolean suspended;
    private boolean atBreakpoint = false;
    private String name;
    private String step;

    public ThreadReferenceImpl(VirtualMachineImpl vm, Map jsonThread) {
        super(vm);
        this.threadId = (Number)jsonThread.get("threadId");
        this.name = (String)jsonThread.get("name");
        if (this.name == null) {
            this.name = "Rhino - " + this.threadId;
        }
        this.suspended = "suspended".equals(jsonThread.get("state"));
    }

    public synchronized int frameCount() {
        this.frames();
        return this.frames == null ? 0 : this.frames.size();
    }

    public synchronized StackFrame frame(int index) {
        this.frames();
        return (StackFrame)this.frames.get(index);
    }

    public synchronized List frames() {
        if (!this.suspended || this.status == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.frames != null) {
            return this.frames;
        }
        RhinoRequest request = new RhinoRequest("frames");
        request.getArguments().put("threadId", this.threadId);
        try {
            RhinoResponse response = this.vm.sendRequest(request, 30000);
            List frameIds = (List)response.getBody().get("frames");
            if (frameIds.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            this.frames = new ArrayList();
            Iterator iterator = frameIds.iterator();
            while (iterator.hasNext()) {
                Long frameId = new Long(((Number)iterator.next()).longValue());
                StackFrameImpl frame = this.createStackFrame(frameId);
                this.frames.add(frame);
            }
        }
        catch (DisconnectedException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        if (this.frames != null) {
            return this.frames;
        }
        return Collections.EMPTY_LIST;
    }

    private StackFrameImpl createStackFrame(Long frameId) {
        RhinoRequest request = new RhinoRequest("frame");
        request.getArguments().put("threadId", this.threadId);
        request.getArguments().put("frameId", frameId);
        try {
            RhinoResponse response = this.vm.sendRequest(request);
            Map jsonFrame = (Map)response.getBody().get("frame");
            return new StackFrameImpl(this.vm, jsonFrame);
        }
        catch (DisconnectedException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
        return null;
    }

    public synchronized boolean isAtBreakpoint() {
        return this.suspended && this.atBreakpoint;
    }

    public synchronized void markSuspended(boolean atBreakpoint) {
        this.suspended = true;
        this.atBreakpoint = atBreakpoint;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public String name() {
        return this.name;
    }

    public synchronized void resume() {
        if (this.status == 0) {
            return;
        }
        RhinoRequest request = new RhinoRequest("continue");
        request.getArguments().put("threadId", this.threadId);
        if (this.step != null) {
            request.getArguments().put("step", this.step);
        }
        try {
            RhinoResponse response = this.vm.sendRequest(request);
            if (response.isSuccess()) {
                this.step = null;
                this.frames = null;
                this.suspended = false;
                this.atBreakpoint = false;
            }
        }
        catch (DisconnectedException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
    }

    public synchronized void suspend() {
        if (this.status == 0) {
            return;
        }
        RhinoRequest request = new RhinoRequest("suspend");
        request.getArguments().put("threadId", this.threadId);
        try {
            RhinoResponse response = this.vm.sendRequest(request);
            if (response.isSuccess()) {
                this.markSuspended(false);
            }
        }
        catch (DisconnectedException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            RhinoDebugPlugin.log(e);
        }
    }

    public void interrupt() {
        throw new UnsupportedOperationException();
    }

    public synchronized int status() {
        return this.status;
    }

    public synchronized String getStep() {
        return this.step;
    }

    public synchronized void setStep(String step) {
        this.step = step;
    }
}

