/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.SelectionManagerFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenJpaResourceAction
extends BaseSelectionListenerAction {
    private JpaContextNode selectedNode;

    public OpenJpaResourceAction() {
        super("Open");
    }

    public boolean updateSelection(IStructuredSelection s) {
        this.selectedNode = null;
        if (!super.updateSelection(s)) {
            return false;
        }
        if (s.size() != 1) {
            return false;
        }
        if (s.getFirstElement() instanceof JpaRootContextNode) {
            return false;
        }
        this.selectedNode = (JpaContextNode)s.getFirstElement();
        return true;
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        IResource resource = this.selectedNode.getResource();
        if (resource != null && resource.exists() && resource.getType() == 1) {
            this.openEditor((IFile)resource);
            if (this.selectedNode instanceof JpaStructureNode) {
                JpaSelectionManager selectionManager = SelectionManagerFactory.getSelectionManager(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                selectionManager.select(new DefaultJpaSelection((JpaStructureNode)this.selectedNode), null);
            }
        }
    }

    protected void openEditor(IFile file) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IContentType contentType = IDE.getContentType((IFile)file);
        IEditorDescriptor editorDescriptor = registry.getDefaultEditor(file.getName(), contentType);
        if (editorDescriptor == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)JptUiMessages.Error_openingEditor, (String)e.getMessage());
        }
    }
}

