/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.SelectionManagerFactory;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemovePersistentAttributeFromXmlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
        final ArrayList<OrmPersistentAttribute> newAttributes = new ArrayList<OrmPersistentAttribute>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        for (OrmPersistentAttribute attribute : CollectionTools.iterable((Iterator)selection.iterator())) {
            OrmPersistentType type = attribute.getOwningPersistentType();
            String attributeName = attribute.getName();
            attribute.makeVirtual();
            OrmPersistentAttribute newAttribute = type.getAttributeNamed(attributeName);
            if (newAttribute == null) continue;
            newAttributes.add(newAttribute);
        }
        if (newAttributes.size() == 1) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JpaSelectionManager selectionManager = SelectionManagerFactory.getSelectionManager(window);
                    selectionManager.select(new DefaultJpaSelection((JpaStructureNode)newAttributes.get(0)), null);
                }
            });
        }
        return null;
    }
}

