/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalComposite
extends Pane<Nullable> {
    public OptionalComposite(Pane<? extends Nullable> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addTriStateCheckBoxWithDefault(this.addSubPane(container, 4), JptUiDetailsMessages.BasicGeneralSection_optionalLabel, this.buildOptionalHolder(), this.buildOptionalStringHolder(), "org.eclipse.jpt.ui.mapping_optional");
    }

    private WritablePropertyValueModel<Boolean> buildOptionalHolder() {
        return new PropertyAspectAdapter<Nullable, Boolean>(this.getSubjectHolder(), new String[]{"specifiedOptional"}){

            protected Boolean buildValue_() {
                return ((Nullable)this.subject).getSpecifiedOptional();
            }

            protected void setValue_(Boolean value) {
                ((Nullable)this.subject).setSpecifiedOptional(value);
            }
        };
    }

    private PropertyValueModel<String> buildOptionalStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultOptionalHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptUiDetailsMessages.Boolean_True : JptUiDetailsMessages.Boolean_False;
                    return NLS.bind((String)JptUiDetailsMessages.BasicGeneralSection_optionalLabelDefault, (Object)defaultStringValue);
                }
                return JptUiDetailsMessages.BasicGeneralSection_optionalLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultOptionalHolder() {
        return new PropertyAspectAdapter<Nullable, Boolean>(this.getSubjectHolder(), new String[]{"specifiedOptional", "defaultOptional"}){

            protected Boolean buildValue_() {
                if (((Nullable)this.subject).getSpecifiedOptional() != null) {
                    return null;
                }
                return ((Nullable)this.subject).isDefaultOptional();
            }
        };
    }
}

