/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Converter;
import org.eclipse.jpt.core.context.EnumeratedConverter;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.details.EnumTypeComposite;
import org.eclipse.jpt.ui.internal.details.FetchTypeComposite;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.details.OptionalComposite;
import org.eclipse.jpt.ui.internal.details.TemporalTypeComposite;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicMappingComposite<T extends BasicMapping>
extends Pane<T>
implements JpaComposite {
    protected AbstractBasicMappingComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.initializeBasicCollapsibleSection(container);
        this.initializeTypeCollapsibleSection(container);
    }

    protected void initializeBasicCollapsibleSection(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsMessages.BasicSection_title, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.TRUE));
        this.initializeBasicSection(container);
    }

    protected void initializeBasicSection(Composite container) {
        new ColumnComposite((Pane<?>)this, (PropertyValueModel<? extends Column>)this.buildColumnHolder(), container);
        new FetchTypeComposite(this, container);
        new OptionalComposite(this, this.addSubPane(container, 4));
    }

    protected void initializeTypeCollapsibleSection(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsMessages.TypeSection_type);
        this.initializeTypeSection(container);
    }

    protected void initializeTypeSection(Composite container) {
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiDetailsMessages.TypeSection_default, this.buildConverterBooleanHolder("noConverter"), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        Button lobButton = this.addRadioButton(container, JptUiDetailsMessages.TypeSection_lob, this.buildConverterBooleanHolder("lobConverter"), null);
        ((GridData)lobButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> converterHolder = this.buildConverterHolder();
        this.addRadioButton(container, JptUiDetailsMessages.TypeSection_temporal, this.buildConverterBooleanHolder("temporalConverter"), null);
        this.registerSubPane(new TemporalTypeComposite((PropertyValueModel<? extends TemporalConverter>)this.buildTemporalConverterHolder(converterHolder), container, this.getWidgetFactory()));
        this.addRadioButton(container, JptUiDetailsMessages.TypeSection_enumerated, this.buildConverterBooleanHolder("enumeratedConverter"), null);
        this.registerSubPane(new EnumTypeComposite((PropertyValueModel<? extends EnumeratedConverter>)this.buildEnumeratedConverterHolder(converterHolder), container, this.getWidgetFactory()));
    }

    protected PropertyValueModel<Column> buildColumnHolder() {
        return new TransformationPropertyValueModel<T, Column>(this.getSubjectHolder()){

            protected Column transform_(T value) {
                return value.getColumn();
            }
        };
    }

    protected PropertyValueModel<Converter> buildConverterHolder() {
        return new PropertyAspectAdapter<T, Converter>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Converter buildValue_() {
                return ((BasicMapping)this.subject).getConverter();
            }
        };
    }

    protected PropertyValueModel<TemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, TemporalConverter>(converterHolder){

            protected TemporalConverter transform_(Converter converter) {
                return converter.getType() == "temporalConverter" ? (TemporalConverter)converter : null;
            }
        };
    }

    protected PropertyValueModel<EnumeratedConverter> buildEnumeratedConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, EnumeratedConverter>(converterHolder){

            protected EnumeratedConverter transform_(Converter converter) {
                return converter.getType() == "enumeratedConverter" ? (EnumeratedConverter)converter : null;
            }
        };
    }

    protected WritablePropertyValueModel<Boolean> buildConverterBooleanHolder(final String converterType) {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getConverter();
                return converter.getType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setConverter(converterType);
                }
            }
        };
    }
}

