/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.eclipse.wst.jsdt.debug.transport.packet.Request;

public class CFRequestPacket
extends CFPacket
implements Request {
    public static final String REQUEST = "request";
    private final String command;
    private final Map arguments = Collections.synchronizedMap(new HashMap());
    private final Map params = Collections.synchronizedMap(new HashMap());
    private static int currentSequence = 0;
    private final int sequence;

    public CFRequestPacket(String command, String context_id) {
        super(REQUEST, context_id);
        if (command == null) {
            throw new IllegalArgumentException("The request command kind cannot be null");
        }
        this.sequence = CFRequestPacket.nextSequence();
        this.command = command.intern();
    }

    public CFRequestPacket(Map json) {
        super(json);
        if (json == null) {
            throw new IllegalArgumentException("The JSON map for a request packet cannot be null");
        }
        String value = (String)json.get("command");
        this.command = value.intern();
        Map packetArguments = (Map)json.get("arguments");
        this.arguments.putAll(packetArguments);
        Number packetSeq = (Number)json.get("seq");
        this.sequence = packetSeq.intValue();
    }

    private static synchronized int nextSequence() {
        return ++currentSequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void addAdditionalParam(String key, Object value) {
        this.params.put(key, value);
    }

    public String getCommand() {
        return this.command;
    }

    public Map getArguments() {
        return this.arguments;
    }

    public void setArgument(String key, Object argument) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key cannot be null");
        }
        this.arguments.put(key, argument);
    }

    public Map toJSON() {
        Map json = super.toJSON();
        json.put("seq", new Integer(this.sequence));
        json.put("command", this.command);
        if (!this.arguments.isEmpty()) {
            json.put("arguments", this.arguments);
        }
        Map.Entry entry = null;
        Iterator iter = this.params.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            json.put(entry.getKey(), entry.getValue());
        }
        return json;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        buffer.append("CFRequestPacket: ");
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }
}

