/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistryReader;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorDelegatesRegistry {
    private static ValidatorDelegatesRegistry _instance;
    private Map<String, Map<String, ValidatorDelegateDescriptor>> _delegatesByTarget = new HashMap<String, Map<String, ValidatorDelegateDescriptor>>();
    private Set<String> _defaultDelegates;

    public static ValidatorDelegatesRegistry getInstance() {
        if (_instance == null) {
            ValidatorDelegatesRegistry instance = new ValidatorDelegatesRegistry();
            ValidatorDelegatesRegistryReader reader = new ValidatorDelegatesRegistryReader(instance);
            reader.readRegistry();
            instance.initDefaults();
            _instance = instance;
        }
        return _instance;
    }

    private void initDefaults() {
        IEclipsePreferences prefs = new DefaultScope().getNode("org.eclipse.wst.validation");
        String delegatePref = prefs.get("DELEGATES_PREFERENCE", null);
        if (delegatePref == null) {
            return;
        }
        int delegatesIndex = delegatePref.indexOf("delegateValidatorList");
        String delegates = delegatePref.substring(delegatesIndex + "delegateValidatorList".length(), delegatePref.length());
        if (delegates == null) {
            return;
        }
        this._defaultDelegates = new HashSet<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(delegates, ";");
        while (tokenizer.hasMoreTokens()) {
            String delegateConfiguration = tokenizer.nextToken();
            int separatorIndex = delegateConfiguration.indexOf("=");
            String delegateID = delegateConfiguration.substring(separatorIndex + 1);
            this._defaultDelegates.add(delegateID);
        }
    }

    void add(ValidatorDelegateDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        String targetID = descriptor.getTargetID();
        Map<String, ValidatorDelegateDescriptor> delegates = this._delegatesByTarget.get(targetID);
        if (delegates == null) {
            delegates = new HashMap<String, ValidatorDelegateDescriptor>();
            this._delegatesByTarget.put(targetID, delegates);
        }
        delegates.put(descriptor.getId(), descriptor);
    }

    public String getDefaultDelegate(String targetID) {
        Iterator<ValidatorDelegateDescriptor> delegatesIterator;
        Map<String, ValidatorDelegateDescriptor> delegates = this.getDelegateDescriptors(targetID);
        if (delegates == null) {
            return null;
        }
        if (this._defaultDelegates != null) {
            for (ValidatorDelegateDescriptor vdd : delegates.values()) {
                String id = vdd.getId();
                if (!this._defaultDelegates.contains(id)) continue;
                return id;
            }
        }
        if (!(delegatesIterator = delegates.values().iterator()).hasNext()) {
            return null;
        }
        return delegatesIterator.next().getId();
    }

    public IValidator getDelegate(String targetID, String delegateID) throws ValidationException {
        ValidatorDelegateDescriptor descriptor = this.getDescriptor(targetID, delegateID);
        if (descriptor == null) {
            return null;
        }
        IValidator delegate = descriptor.getValidator();
        return delegate;
    }

    public Map<String, ValidatorDelegateDescriptor> getDelegateDescriptors(String targetID) {
        return this._delegatesByTarget.get(targetID);
    }

    public ValidatorDelegateDescriptor getDescriptor(String targetID, String delegateID) {
        Map<String, ValidatorDelegateDescriptor> delegates = this._delegatesByTarget.get(targetID);
        if (delegates == null || delegateID == null) {
            return null;
        }
        ValidatorDelegateDescriptor descriptor = delegates.get(delegateID);
        return descriptor;
    }

    public boolean hasDelegates(String targetID) {
        Map<String, ValidatorDelegateDescriptor> delegatesByID = this._delegatesByTarget.get(targetID);
        boolean hasDelegates = delegatesByID != null && !delegatesByID.isEmpty();
        return hasDelegates;
    }
}

