/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.actions.AbstractNodeActionManager;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.dialogs.EditAttributeDialog;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditAttributeAction
extends NodeAction {
    protected static ImageDescriptor imageDescriptor;
    protected Attr attr;
    protected AbstractNodeActionManager manager;
    protected Element ownerElement;
    protected String title;

    public static ImageDescriptor createImageDescriptor() {
        if (imageDescriptor == null) {
            imageDescriptor = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/attribute_obj.gif");
        }
        return imageDescriptor;
    }

    public EditAttributeAction(AbstractNodeActionManager manager, Element ownerElement, Attr attr, String actionLabel, String title) {
        this.manager = manager;
        this.ownerElement = ownerElement;
        this.attr = attr;
        this.title = title;
        this.setText(actionLabel);
        if (attr == null) {
            this.setImageDescriptor(EditAttributeAction.createImageDescriptor());
        }
    }

    public String getUndoDescription() {
        return this.title;
    }

    public void run() {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.validateEdit(this.manager.getModel(), shell)) {
            this.manager.beginNodeAction(this);
            EditAttributeDialog dialog = new EditAttributeDialog(shell, this.ownerElement, this.attr);
            dialog.create();
            dialog.getShell().setText(this.title);
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                if (this.attr != null) {
                    this.ownerElement.removeAttributeNode(this.attr);
                }
                Document document = this.ownerElement.getOwnerDocument();
                Attr newAttribute = document.createAttribute(dialog.getAttributeName());
                newAttribute.setValue(dialog.getAttributeValue());
                this.ownerElement.setAttributeNode(newAttribute);
                this.manager.setViewerSelection(newAttribute);
            }
            this.manager.endNodeAction(this);
        }
    }
}

