/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.ui.internal.assembly.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.internal.modulecore.util.JavaModuleComponentUtility;
import org.eclipse.jst.common.ui.internal.Messages;
import org.eclipse.jst.common.ui.internal.assembly.wizard.ManifestModuleDependencyControl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizard;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;

public class AddManifestEntryTaskWizard
extends TaskWizard {
    public static final String PARENT_PROJECT = "PARENT_PROJECT";
    public static final String CHILD_PROJECT = "CHILD_PROJECT";
    public static final String CURRENT_REFERENCES = "CURRENT_REFERENCES";
    public static final String RETURNED_REFERENCES = "RETURNED_REFERENCES";

    public AddManifestEntryTaskWizard() {
        super(Messages.AddManifestEntryTaskWizardTitle, (WizardFragment)new ManifestRootFragment());
    }

    public static class ManifestRootFragment
    extends WizardFragment {
        private TableViewer viewer;
        private Button addCustom;
        private Text customEntryText;
        protected IProject parentProject;
        protected IProject childProject;
        private IVirtualReference[] selected;
        private ShowPossibleManifestEntryContentProvider contentProvider;
        private Link parentContainerLink;

        public boolean hasComposite() {
            return true;
        }

        private void updateWidgets() throws InvocationTargetException {
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.viewer.refresh();
        }

        private static GridLayout glayout(int columns) {
            GridLayout gl = new GridLayout(columns, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            return gl;
        }

        public Composite createComposite(Composite parent, IWizardHandle handle) {
            this.parentProject = (IProject)this.getTaskModel().getObject(AddManifestEntryTaskWizard.PARENT_PROJECT);
            this.childProject = (IProject)this.getTaskModel().getObject(AddManifestEntryTaskWizard.CHILD_PROJECT);
            handle.setTitle(Messages.AddManifestEntryTaskWizardTitle);
            handle.setDescription(NLS.bind((String)Messages.AddManifestEntryTaskWizardDesc, (Object)this.parentProject.getName()));
            handle.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_EXPORT_WIZ"));
            handle.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.common.ui", (String)"icons/manifest-classpath-banner.png"));
            Composite root = new Composite(parent, 0);
            root.setLayout((Layout)ManifestRootFragment.glayout(1));
            this.viewer = ManifestModuleDependencyControl.createManifestReferenceTableViewer(root, 2);
            GridData gData = new GridData(1808);
            gData.heightHint = 350;
            this.viewer.getTable().setLayoutData((Object)gData);
            this.contentProvider = new ShowPossibleManifestEntryContentProvider(this.parentProject, this.childProject, this.getTaskModel());
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
            this.viewer.setLabelProvider((IBaseLabelProvider)new ManifestModuleDependencyControl.ManifestLabelProvider());
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ManifestRootFragment.this.viewerSelectionChanged();
                }
            });
            Composite customEntryComposite = new Composite(root, 0);
            customEntryComposite.setLayoutData((Object)new GridData(768));
            customEntryComposite.setLayout((Layout)ManifestRootFragment.glayout(2));
            this.customEntryText = new Text(customEntryComposite, 2048);
            this.customEntryText.setLayoutData((Object)new GridData(768));
            this.customEntryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ManifestRootFragment.this.customEntryText.getText() == null || ManifestRootFragment.this.customEntryText.getText().trim().length() == 0 || new Path(ManifestRootFragment.this.customEntryText.getText().trim()).makeRelative().toString().length() == 0) {
                        ManifestRootFragment.this.addCustom.setEnabled(false);
                    } else {
                        ManifestRootFragment.this.addCustom.setEnabled(true);
                    }
                }
            });
            this.addCustom = new Button(customEntryComposite, 8);
            this.addCustom.setLayoutData((Object)new GridData());
            this.addCustom.setText(Messages.CustomEntryButton);
            this.addCustom.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ManifestRootFragment.this.addCustomPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.addCustom.setEnabled(false);
            this.createConfigLink(root);
            this.parentContainerLink.setLayoutData((Object)new GridData());
            return root;
        }

        private void addCustomPressed() {
            IVirtualReference ref = ManifestModuleDependencyControl.createDummyReference(new Path(this.customEntryText.getText()).toString(), this.parentProject, ComponentCore.createComponent((IProject)this.parentProject));
            this.contentProvider.addPossibleReference(ref);
            this.customEntryText.setText("");
            this.addCustom.setEnabled(false);
            this.viewer.refresh();
        }

        private void viewerSelectionChanged() {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object[] obj = sel.toArray();
            IVirtualReference[] ret = new IVirtualReference[obj.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = (IVirtualReference)obj[i];
                ++i;
            }
            this.selected = ret;
        }

        private void createConfigLink(Composite aGroup) {
            this.parentContainerLink = new Link(aGroup, 0);
            this.parentContainerLink.setText("<A>" + Messages.ConfigureParentLink + "</A>");
            this.parentContainerLink.addSelectionListener(new SelectionListener(){

                public void doLinkActivated(Link e) {
                    IProject parentProject = ManifestRootFragment.this.parentProject;
                    PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)ManifestRootFragment.this.getPage().getControl().getShell(), (String)"org.eclipse.wst.common.componentcore.ui.DeploymentAssemblyPage", (Object)parentProject);
                    if (dialog != null) {
                        dialog.open();
                    }
                    try {
                        ManifestRootFragment.this.updateWidgets();
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.doLinkActivated((Link)e.widget);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.doLinkActivated((Link)e.widget);
                }
            });
        }

        public void performFinish(IProgressMonitor monitor) throws CoreException {
            this.getTaskModel().putObject(AddManifestEntryTaskWizard.RETURNED_REFERENCES, (Object)this.selected);
        }
    }

    public static class ShowPossibleManifestEntryContentProvider
    extends ArrayContentProvider {
        private IProject parent;
        private IProject child;
        private TaskModel model;
        private IVirtualReference[] possible;

        public ShowPossibleManifestEntryContentProvider(IProject parent, IProject child, TaskModel taskModel) {
            this.parent = parent;
            this.child = child;
            this.model = taskModel;
        }

        public Object[] getElements(Object inputElement) {
            if (this.possible == null) {
                IVirtualReference[] current = (IVirtualReference[])this.model.getObject(AddManifestEntryTaskWizard.CURRENT_REFERENCES);
                this.possible = JavaModuleComponentUtility.findPossibleManifestEntries((IProject)this.parent, (IProject)this.child, (IVirtualReference[])current);
            }
            return this.possible;
        }

        public void addPossibleReference(IVirtualReference ref) {
            ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>();
            newRefs.addAll(Arrays.asList(this.possible));
            newRefs.add(ref);
            this.possible = newRefs.toArray(new IVirtualReference[newRefs.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.possible = null;
                viewer.refresh();
            }
        }
    }
}

