/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.componentcore.util;

import java.net.ConnectException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WelcomeFile;
import org.eclipse.jst.j2ee.webapplication.WelcomeFileList;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class WebArtifactEdit
extends EnterpriseArtifactEdit
implements IArtifactEditFactory {
    private static final String WEB_CONTENT_TYPE = "org.eclipse.jst.j2ee.webDD";
    public static final Class ADAPTER_TYPE = WebArtifactEdit.class;
    public static final String WEB_CONTENT = "WebContent";
    public static final String WEB_INF = "WEB-INF";
    public static final String META_INF = "META-INF";
    public static IPath WEBLIB = new Path("/WEB-INF/lib");

    public WebArtifactEdit() {
    }

    public WebArtifactEdit(IVirtualComponent aModule) {
        super(aModule);
    }

    protected BinaryComponentHelper initBinaryComponentHelper(IVirtualComponent binaryModule) {
        return new JavaEEBinaryComponentHelper(binaryModule);
    }

    public WebArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public WebArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly, forCreate, "jst.web");
    }

    protected WebArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate, String editModelID) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly, forCreate, editModelID);
    }

    public static WebArtifactEdit getWebArtifactEditForRead(IProject aProject) {
        WebArtifactEdit artifactEdit = null;
        try {
            if (WebArtifactEdit.isValidWebModule(ComponentCore.createComponent((IProject)aProject))) {
                artifactEdit = new WebArtifactEdit(aProject, true, false);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static WebArtifactEdit getWebArtifactEditForWrite(IProject aProject) {
        WebArtifactEdit artifactEdit = null;
        try {
            if (WebArtifactEdit.isValidWebModule(ComponentCore.createComponent((IProject)aProject))) {
                artifactEdit = new WebArtifactEdit(aProject, false, false);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static WebArtifactEdit getWebArtifactEditForRead(IVirtualComponent aModule) {
        if (aModule == null) {
            return null;
        }
        if (aModule.isBinary()) {
            return new WebArtifactEdit(aModule);
        }
        return WebArtifactEdit.getWebArtifactEditForRead(aModule.getProject());
    }

    public static WebArtifactEdit getWebArtifactEditForWrite(IVirtualComponent aModule) {
        if (aModule == null || aModule.isBinary()) {
            return null;
        }
        return WebArtifactEdit.getWebArtifactEditForWrite(aModule.getProject());
    }

    public static boolean isValidWebModule(IVirtualComponent aModule) throws UnresolveableURIException {
        if (!WebArtifactEdit.isValidEditableModule((IVirtualComponent)aModule)) {
            return false;
        }
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)aModule.getProject());
    }

    public WebArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    protected WebArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public int getJ2EEVersion() {
        this.verifyOperationSupported();
        return ((WebAppResource)this.getDeploymentDescriptorResource()).getJ2EEVersionID();
    }

    public EObject getDeploymentDescriptorRoot() {
        this.verifyOperationSupported();
        EList contents = this.getDeploymentDescriptorResource().getContents();
        if (contents.size() > 0) {
            return (EObject)contents.get(0);
        }
        if (this.isBinary()) {
            return null;
        }
        this.addWebAppIfNecessary((XMLResource)((WebAppResource)this.getDeploymentDescriptorResource()));
        return (EObject)contents.get(0);
    }

    public Resource getDeploymentDescriptorResource() {
        this.verifyOperationSupported();
        if (this.isBinary()) {
            return this.getBinaryComponentHelper().getResource(J2EEConstants.WEBAPP_DD_URI_OBJ);
        }
        return this.getArtifactEditModel().getResource(J2EEConstants.WEBAPP_DD_URI_OBJ);
    }

    public int getServletVersion() {
        this.verifyOperationSupported();
        return ((WebAppResource)this.getDeploymentDescriptorResource()).getModuleVersionID();
    }

    public int getJSPVersion() {
        this.verifyOperationSupported();
        int servletVersion = this.getServletVersion();
        if (servletVersion == 22) {
            return 11;
        }
        if (servletVersion == 23) {
            return 12;
        }
        return 20;
    }

    protected void addWebAppIfNecessary(XMLResource aResource) {
        this.verifyOperationSupported();
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        if (aResource != null) {
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                WebApp webAppNew = WebapplicationFactory.eINSTANCE.createWebApp();
                aResource.getContents().add((Object)webAppNew);
                aResource.setModified(true);
            }
            WebApp webApp = (WebApp)aResource.getContents().get(0);
            URI moduleURI = this.getArtifactEditModel().getModuleURI();
            try {
                webApp.setDisplayName(StructureEdit.getDeployedName((URI)moduleURI));
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            aResource.setID((EObject)webApp, "WebApp_ID");
            WelcomeFileList wList = WebapplicationFactory.eINSTANCE.createWelcomeFileList();
            EList files = wList.getFile();
            WelcomeFile file = WebapplicationFactory.eINSTANCE.createWelcomeFile();
            file.setWelcomeFile("index.html");
            files.add(file);
            file = WebapplicationFactory.eINSTANCE.createWelcomeFile();
            file.setWelcomeFile("index.htm");
            files.add(file);
            file = WebapplicationFactory.eINSTANCE.createWelcomeFile();
            file.setWelcomeFile("index.jsp");
            files.add(file);
            file = WebapplicationFactory.eINSTANCE.createWelcomeFile();
            file.setWelcomeFile("default.html");
            files.add(file);
            file = WebapplicationFactory.eINSTANCE.createWelcomeFile();
            file.setWelcomeFile("default.htm");
            files.add(file);
            file = WebapplicationFactory.eINSTANCE.createWelcomeFile();
            file.setWelcomeFile("default.jsp");
            files.add(file);
            webApp.setFileList(wList);
            try {
                aResource.saveIfNecessary();
            }
            catch (ConnectException connectException) {
            }
            catch (Exception e) {
                WebPlugin.logError(e);
            }
        }
    }

    public IPath getDeploymentDescriptorPath() {
        this.verifyOperationSupported();
        IFile file = WorkbenchResourceHelper.getFile((Resource)this.getDeploymentDescriptorResource());
        if (file != null) {
            return file.getFullPath();
        }
        return null;
    }

    public EObject createModelRoot() {
        this.verifyOperationSupported();
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        return this.createModelRoot(this.getJ2EEVersion());
    }

    public EObject createModelRoot(int version) {
        this.verifyOperationSupported();
        if (this.isBinary()) {
            this.throwAttemptedBinaryEditModelAccess();
        }
        WebAppResource res = (WebAppResource)this.getDeploymentDescriptorResource();
        res.setModuleVersionID(version);
        this.addWebAppIfNecessary((XMLResource)res);
        return res.getRootObject();
    }

    public IVirtualReference[] getLibModules() {
        return WebUtilities.getLibModules((IProject)this.getProject());
    }

    public void addLibModules(ReferencedComponent[] libModules) {
    }

    public String getServerContextRoot() {
        return J2EEProjectUtilities.getServerContextRoot((IProject)this.getProject());
    }

    public String getServerContextRoot(IProject earProject) {
        if (earProject == null || !JavaEEProjectUtilities.isEARProject((IProject)earProject)) {
            return this.getServerContextRoot();
        }
        EARArtifactEdit earEdit = null;
        String contextRoot = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
            if (earEdit != null) {
                contextRoot = earEdit.getWebContextRoot(this.getProject());
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
        return contextRoot;
    }

    public void setServerContextRoot(IProject earProject, String aContextRoot) {
        if (earProject == null || !JavaEEProjectUtilities.isEARProject((IProject)earProject)) {
            this.setServerContextRoot(aContextRoot);
        }
        EARArtifactEdit earEdit = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)earProject);
            if (earEdit != null) {
                earEdit.setWebContextRoot(this.getProject(), aContextRoot);
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                earEdit.dispose();
            }
        }
    }

    public void setServerContextRoot(String contextRoot) {
        J2EEProjectUtilities.setServerContextRoot((IProject)this.getProject(), (String)contextRoot);
    }

    public WebApp getWebApp() {
        this.verifyOperationSupported();
        return (WebApp)this.getDeploymentDescriptorRoot();
    }

    public ArtifactEdit createArtifactEditForRead(IVirtualComponent aComponent) {
        return WebArtifactEdit.getWebArtifactEditForRead(aComponent);
    }

    public ArtifactEdit createArtifactEditForWrite(IVirtualComponent aComponent) {
        return WebArtifactEdit.getWebArtifactEditForWrite(aComponent);
    }

    public Archive asArchive(boolean includeSource, boolean includeClasspathComponents) throws OpenFailureException {
        return this.asArchive(includeSource, includeClasspathComponents, false);
    }

    public Archive asArchive(boolean includeSource, boolean includeClasspathComponents, boolean readOnly) throws OpenFailureException {
        this.verifyOperationSupported();
        if (this.isBinary()) {
            JavaEEBinaryComponentHelper helper = (JavaEEBinaryComponentHelper)this.getBinaryComponentHelper();
            return helper.accessLegacyArchive();
        }
        WebComponentLoadStrategyImpl loader = new WebComponentLoadStrategyImpl(this.getComponent(), includeClasspathComponents);
        loader.setExportSource(includeSource);
        loader.setReadOnly(readOnly);
        String uri = ModuleURIUtil.getHandleString((IVirtualComponent)this.getComponent());
        ArchiveOptions options = new ArchiveOptions();
        options.setLoadStrategy((LoadStrategy)loader);
        options.setIsReadOnly(readOnly);
        return CommonarchiveFactory.eINSTANCE.openWARFile(options, uri);
    }

    public static void createDeploymentDescriptor(IProject project, int version) {
        WebArtifactEdit webEdit = new WebArtifactEdit(project, false, true);
        try {
            webEdit.createModelRoot(version);
            webEdit.save(null);
        }
        finally {
            Resource newRes = webEdit.getDeploymentDescriptorResource();
            WorkbenchResourceHelperBase.getResourceSet((IProject)project).getResources().remove((Object)newRes);
            newRes.unload();
            webEdit.dispose();
        }
    }

    public IModelProvider create(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForRead(project);
    }

    public IModelProvider create(IVirtualComponent component) {
        return WebArtifactEdit.getWebArtifactEditForRead(component);
    }

    public void modify(Runnable runnable, IPath modelPath) {
        this.setWritableEdit((ArtifactEdit)WebArtifactEdit.getWebArtifactEditForWrite(this.getProject()));
        try {
            runnable.run();
            if (this.getWritableEdit() != null) {
                this.getWritableEdit().saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            if (this.getWritableEdit() != null) {
                this.getWritableEdit().dispose();
            }
            this.setWritableEdit(null);
        }
    }

    protected String getContentTypeDescriber() {
        return WEB_CONTENT_TYPE;
    }

    protected URI getRootURI() {
        return J2EEConstants.WEBAPP_DD_URI_OBJ;
    }
}

