/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class SiblingNavigationAction
extends TextEditorAction {
    private boolean fForward;

    SiblingNavigationAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean forward) {
        super(bundle, prefix, editor);
        this.fForward = forward;
    }

    public void runWithEvent(Event event) {
        Object o;
        super.runWithEvent(event);
        if (this.getTextEditor() == null) {
            return;
        }
        ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof Node) {
            Node sibling = null;
            if (((Node)o).getNodeType() == 2) {
                o = ((Attr)o).getOwnerElement();
            }
            if (this.fForward) {
                sibling = ((Node)o).getNextSibling();
                while (sibling != null && sibling.getNodeType() == 3 && sibling.getNodeValue().trim().length() == 0) {
                    sibling = sibling.getNextSibling();
                }
                if (sibling == null) {
                    sibling = ((Node)o).getParentNode().getFirstChild();
                    while (sibling != null && sibling.getNodeType() == 3 && sibling.getNodeValue().trim().length() == 0) {
                        sibling = sibling.getNextSibling();
                    }
                }
            } else {
                sibling = ((Node)o).getPreviousSibling();
                while (sibling != null && sibling.getNodeType() == 3 && sibling.getNodeValue().trim().length() == 0) {
                    sibling = sibling.getPreviousSibling();
                }
                if (sibling == null) {
                    sibling = ((Node)o).getParentNode().getLastChild();
                    while (sibling != null && sibling.getNodeType() == 3 && sibling.getNodeValue().trim().length() == 0) {
                        sibling = sibling.getPreviousSibling();
                    }
                }
            }
            if (((Node)o).getNodeType() == 3 && o.equals(sibling)) {
                sibling = ((Node)o).getParentNode();
            }
            if (sibling != null) {
                this.getTextEditor().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)sibling));
            }
        }
    }

    public void update() {
    }
}

