/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import java.util.HashMap;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.RunOnServerWizardFragment;

public class RunOnServerWizard
extends TaskWizard {
    public RunOnServerWizard(IModule module, String launchMode, IModuleArtifact moduleArtifact) {
        this(module, launchMode, moduleArtifact, null);
    }

    public RunOnServerWizard(IModule module, String launchMode, IModuleArtifact moduleArtifact, HashMap properties) {
        super(Messages.wizRunOnServerTitle, RunOnServerWizard.createRootWizard(module, launchMode, moduleArtifact, properties));
        this.setNeedsProgressMonitor(true);
        if ("debug".equals(launchMode)) {
            this.setWindowTitle(Messages.wizDebugOnServerTitle);
        } else if ("profile".equals(launchMode)) {
            this.setWindowTitle(Messages.wizProfileOnServerTitle);
        }
        this.getTaskModel().putObject("launch-mode", (Object)launchMode);
    }

    private static RunOnServerWizardFragment createRootWizard(IModule module, String launchMode, IModuleArtifact moduleArtifact, HashMap properties) {
        RunOnServerWizardFragment fragment = new RunOnServerWizardFragment(module, launchMode, moduleArtifact);
        RunOnServerWizard.setFragmentProperties(fragment, properties);
        return fragment;
    }

    private static RunOnServerWizardFragment createRootWizard(IServer server, String launchMode, IModuleArtifact moduleArtifact, HashMap properties) {
        RunOnServerWizardFragment fragment = new RunOnServerWizardFragment(server, launchMode, moduleArtifact);
        RunOnServerWizard.setFragmentProperties(fragment, properties);
        return fragment;
    }

    private static void setFragmentProperties(RunOnServerWizardFragment fragment, HashMap properties) {
        if (properties != null) {
            fragment.setClient((IClient)properties.get(RunOnServerActionDelegate.ROS_CLIENT));
            fragment.setLaunchable((ILaunchableAdapter)properties.get(RunOnServerActionDelegate.ROS_LAUNCHABLE));
        }
    }

    public RunOnServerWizard(IServer server, String launchMode, IModuleArtifact moduleArtifact, HashMap properties) {
        super(Messages.wizRunOnServerTitle, RunOnServerWizard.createRootWizard(server, launchMode, moduleArtifact, properties));
        this.setNeedsProgressMonitor(true);
        if ("debug".equals(launchMode)) {
            this.setWindowTitle(Messages.wizDebugOnServerTitle);
        } else if ("profile".equals(launchMode)) {
            this.setWindowTitle(Messages.wizProfileOnServerTitle);
        }
        this.getTaskModel().putObject("server", (Object)server);
        this.getTaskModel().putObject("launch-mode", (Object)launchMode);
        this.addPages();
    }

    public IServer getServer() {
        try {
            return (IServer)this.getTaskModel().getObject("server");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isPreferredServer() {
        try {
            Boolean b = (Boolean)this.getTaskModel().getObject("defaultServer");
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IClient getSelectedClient() {
        try {
            return (IClient)this.getTaskModel().getObject("client");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setLaunchableAdapter(ILaunchableAdapter launch) {
        this.getTaskModel().putObject("launchableAdapter", (Object)launch);
    }

    public ILaunchableAdapter getLaunchableAdapter() {
        try {
            return (ILaunchableAdapter)this.getTaskModel().getObject("launchableAdapter");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean shouldAppear() {
        return this.getServer() == null || this.hasTasks() || this.hasClients();
    }

    protected boolean hasTasks() {
        try {
            Boolean b = (Boolean)this.getTaskModel().getObject("hasTasks");
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean hasClients() {
        try {
            Boolean b = (Boolean)this.getTaskModel().getObject("hasClients");
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

