/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IBytecodeVisitor;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClassVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.adopters.ClassRef;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.adopters.Plugin2API;
import org.eclipse.wtp.releng.tools.component.adopters.PluginRef;
import org.eclipse.wtp.releng.tools.component.adopters.References;
import org.eclipse.wtp.releng.tools.component.api.API2ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPICache;
import org.eclipse.wtp.releng.tools.component.api.violation.LibVisitor;
import org.eclipse.wtp.releng.tools.component.internal.InternalByteCodeVisitor;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class SimpleClass2Reference
implements IPlatformRunnable,
IClassVisitor {
    private Collection src;
    private String base;
    private String output;
    private String contactInfo;
    private ComponentAPICache compAPICache;
    private String html;
    private Collection includes;
    private Collection excludes;
    private Collection includePlugins;
    private Collection excludePlugins;
    private References refs;

    public void setCompAPIDir(String compAPIDir) {
        this.compAPICache = new ComponentAPICache(compAPIDir);
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = SimpleClass2Reference.addTrailingSeperator(output);
    }

    public String getHTML() {
        return this.html;
    }

    public void setHTML(String html) {
        this.html = html;
    }

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(Collection src) {
        this.src = new ArrayList(src);
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public Collection getExcludePlugins() {
        return this.excludePlugins;
    }

    public void setExcludePlugins(Collection excludePlugins) {
        this.excludePlugins = excludePlugins;
    }

    public Collection getIncludePlugins() {
        return this.includePlugins;
    }

    public void setIncludePlugins(Collection includePlugins) {
        this.includePlugins = includePlugins;
    }

    public void execute() {
        this.refs = new References();
        this.refs.setName(this.src.toString());
        this.refs.setRefBuildId(this.base);
        this.refs.setContactInfo(this.contactInfo);
        if (this.includes != null) {
            this.refs.setIncludes(this.includes.toString());
        }
        if (this.excludes != null) {
            this.refs.setExcludes(this.excludes.toString());
        }
        if (this.includePlugins != null) {
            this.refs.setIncludePlugins(this.includePlugins.toString());
        }
        if (this.excludePlugins != null) {
            this.refs.setExcludePlugins(this.excludePlugins.toString());
        }
        Iterator it = this.src.iterator();
        while (it.hasNext()) {
            ILocation srcLocation = Location.createLocation(new File((String)it.next()));
            LibVisitor libVisitor = new LibVisitor();
            srcLocation.accept(libVisitor);
            libVisitor.setClassVisitor(this);
            srcLocation.accept(libVisitor);
        }
        try {
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() throws IOException {
        File file = new File(this.output);
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        this.refs.write(fos);
        fos.close();
        if (this.html != null) {
            this.genHTML(file);
        }
    }

    private void genHTML(File f) {
        try {
            int i = this.html.replace('\\', '/').lastIndexOf("/");
            String htmlDir = i != -1 ? this.html.substring(0, i + 1) : this.html;
            XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/api-ref-compatibility.xsl").openStream(), f, (OutputStream)new FileOutputStream(this.html), htmlDir);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public boolean visit(String pluginId, ILocation classLoc) {
        if (this.includePlugins(pluginId)) {
            try {
                this.visit(classLoc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassFormatException classFormatException) {
                System.err.println("Plugin: " + pluginId + " Class: " + classLoc.getAbsolutePath());
            }
        }
        return true;
    }

    public References visit(ILocation classLoc) throws IOException, ClassFormatException {
        String refClassName;
        IClassFileReader reader = this.read(classLoc);
        String className = new String(reader.getClassName()).replace('/', '.');
        Iterator it = this.getReferencedTypes(reader).iterator();
        while (it.hasNext()) {
            String refClassName2 = (String)it.next();
            if (className.equals(refClassName2) || !this.include(refClassName2)) continue;
            this.getClassRef(refClassName2).incRefCount();
        }
        this.setMethodAndFieldInfoUses(reader);
        ArrayList methodRefs = new ArrayList();
        ArrayList fieldRefs = new ArrayList();
        this.getRefs(reader, false, methodRefs, fieldRefs);
        Iterator it2 = methodRefs.iterator();
        while (it2.hasNext()) {
            org.eclipse.wtp.releng.tools.component.internal.MethodRef methodRef = (org.eclipse.wtp.releng.tools.component.internal.MethodRef)it2.next();
            refClassName = methodRef.getClassName();
            if (className.equals(refClassName) || !this.include(refClassName)) continue;
            String methodName = methodRef.getMethodName();
            String methodDesc = methodRef.getMethodDescriptor();
            ClassRef classRef = this.getClassRef(refClassName);
            if (methodRef.isConstructor()) {
                classRef.incInstantiateCount();
            } else {
                classRef.incRefCount();
            }
            this.getMethodRef(classRef, methodName, methodDesc).incRefCount();
        }
        methodRefs = null;
        it2 = fieldRefs.iterator();
        while (it2.hasNext()) {
            org.eclipse.wtp.releng.tools.component.internal.FieldRef fieldRef = (org.eclipse.wtp.releng.tools.component.internal.FieldRef)it2.next();
            refClassName = fieldRef.getClassName();
            if (className.equals(refClassName) || !this.include(refClassName)) continue;
            this.getFieldRef(this.getClassRef(refClassName), fieldRef.getFieldName(), fieldRef.getFieldDescriptor()).incRefCount();
        }
        fieldRefs = null;
        String superClass = new String(reader.getSuperclassName()).replace('/', '.');
        if (superClass != null && this.include(superClass)) {
            this.getClassRef(superClass).incSubclassCount();
        }
        char[][] interfaceNames = reader.getInterfaceNames();
        String[] interfaces = new String[interfaceNames.length];
        int i = 0;
        while (i < interfaces.length) {
            interfaces[i] = new String(interfaceNames[i]).replace('/', '.');
            ++i;
        }
        i = 0;
        while (i < interfaces.length) {
            if (this.include(interfaces[i])) {
                this.getClassRef(interfaces[i]).incImplementCount();
            }
            ++i;
        }
        return this.refs;
    }

    private IClassFileReader read(ILocation classLoc) throws IOException, ClassFormatException {
        ClassFileReader classFileReader;
        ByteArrayOutputStream baos;
        block11: {
            InputStream is = null;
            baos = null;
            try {
                byte[] b = new byte[8192];
                baos = new ByteArrayOutputStream(8192);
                is = classLoc.getInputStream();
                int read = is.read(b);
                while (read != -1) {
                    baos.write(b, 0, read);
                    read = is.read(b);
                }
                is.close();
                baos.close();
                classFileReader = new ClassFileReader(baos.toByteArray(), 47);
                Object var6_7 = null;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_8 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (baos == null) break block13;
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
    }

    private Set getReferencedTypes(IClassFileReader reader) {
        HashSet<String> types = new HashSet<String>();
        IConstantPool constantPool = reader.getConstantPool();
        int poolSize = constantPool.getConstantPoolCount();
        int i = 0;
        while (i < poolSize) {
            block3: {
                String signature;
                block4: {
                    if (constantPool.getEntryKind(i) != 7) break block3;
                    IConstantPoolEntry classEntry = constantPool.decodeEntry(i);
                    signature = new String(classEntry.getClassInfoName());
                    int index = signature.lastIndexOf(91);
                    if (index <= -1) break block4;
                    if (signature.length() - (index + 1) == 1) break block3;
                    signature = Signature.toString((String)signature);
                    signature = signature.substring(0, signature.length() - 2 * (index + 1));
                    signature = signature.replace('.', '$');
                }
                String typeName = signature.replace('/', '.');
                types.add(typeName);
            }
            ++i;
        }
        return types;
    }

    private void getRefs(IClassFileReader reader, boolean debug, List methodRefs, List fieldRefs) {
        org.eclipse.wtp.releng.tools.component.internal.MethodRef methodRef;
        String refClassName;
        String className = new String(reader.getClassName()).replace('/', '.');
        IConstantPoolEntry[] refs = this.getConstantPoolEntries(reader, 10);
        int i = 0;
        while (i < refs.length) {
            refClassName = new String(refs[i].getClassName()).replace('/', '.');
            if (!className.equals(refClassName) && this.include(refClassName)) {
                methodRef = new org.eclipse.wtp.releng.tools.component.internal.MethodRef();
                methodRef.setPoolEntry(refs[i]);
                methodRefs.add(methodRef);
            }
            ++i;
        }
        refs = this.getConstantPoolEntries(reader, 11);
        i = 0;
        while (i < refs.length) {
            refClassName = new String(refs[i].getClassName()).replace('/', '.');
            if (!className.equals(refClassName) && this.include(refClassName)) {
                methodRef = new org.eclipse.wtp.releng.tools.component.internal.MethodRef();
                methodRef.setPoolEntry(refs[i]);
                methodRefs.add(methodRef);
            }
            ++i;
        }
        refs = this.getConstantPoolEntries(reader, 9);
        i = 0;
        while (i < refs.length) {
            refClassName = new String(refs[i].getClassName()).replace('/', '.');
            if (!className.equals(refClassName) && this.include(refClassName)) {
                org.eclipse.wtp.releng.tools.component.internal.FieldRef fieldRef = new org.eclipse.wtp.releng.tools.component.internal.FieldRef();
                fieldRef.setPoolEntry(refs[i]);
                fieldRefs.add(fieldRef);
            }
            ++i;
        }
        if (debug) {
            IMethodInfo[] methodInfos = reader.getMethodInfos();
            int i2 = 0;
            while (i2 < methodInfos.length) {
                ILineNumberAttribute lineNumAttr;
                ICodeAttribute codeAttr = methodInfos[i2].getCodeAttribute();
                if (codeAttr != null && (lineNumAttr = codeAttr.getLineNumberAttribute()) != null) {
                    InternalByteCodeVisitor byteCodeVisitor = new InternalByteCodeVisitor(methodRefs, fieldRefs, lineNumAttr);
                    try {
                        codeAttr.traverse((IBytecodeVisitor)byteCodeVisitor);
                    }
                    catch (ClassFormatException e) {
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
        }
    }

    private void setMethodAndFieldInfoUses(IClassFileReader reader) {
        String className = new String(reader.getClassName()).replace('/', '.');
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        int i = 0;
        while (i < methodInfos.length) {
            String desc = new String(methodInfos[i].getDescriptor());
            String returnTypeDesc = Signature.getReturnType((String)desc);
            String returnType = this.toFullyQualifiedName(returnTypeDesc);
            if (Signature.getTypeSignatureKind((String)returnTypeDesc) != 2 && !className.equals(returnType) && this.include(returnType)) {
                this.getClassRef(returnType).incRefCount();
            }
            String[] params = Signature.getParameterTypes((String)desc);
            int j = 0;
            while (j < params.length) {
                String param = this.toFullyQualifiedName(params[j]);
                if (Signature.getTypeSignatureKind((String)params[j]) != 2 && !className.equals(param) && this.include(param)) {
                    this.getClassRef(param).incRefCount();
                }
                ++j;
            }
            String[] throwTypes = Signature.getThrownExceptionTypes((String)desc);
            int j2 = 0;
            while (j2 < throwTypes.length) {
                String throwType = this.toFullyQualifiedName(throwTypes[j2]);
                if (Signature.getTypeSignatureKind((String)throwTypes[j2]) != 2 && !className.equals(throwType) && this.include(throwType)) {
                    this.getClassRef(throwType).incRefCount();
                }
                ++j2;
            }
            ++i;
        }
        IFieldInfo[] fieldInfos = reader.getFieldInfos();
        int i2 = 0;
        while (i2 < fieldInfos.length) {
            String desc = new String(fieldInfos[i2].getDescriptor());
            String field = this.toFullyQualifiedName(desc);
            if (Signature.getTypeSignatureKind((String)desc) != 2 && !className.equals(field) && this.include(field)) {
                this.getClassRef(field).incRefCount();
            }
            ++i2;
        }
    }

    private String toFullyQualifiedName(String descriptor) {
        StringBuffer sb = new StringBuffer();
        descriptor = descriptor.replace('/', '.');
        sb.append(Signature.getSignatureQualifier((String)descriptor));
        sb.append('.');
        sb.append(Signature.getSignatureSimpleName((String)descriptor).replace('.', '$'));
        return sb.toString();
    }

    private IConstantPoolEntry[] getConstantPoolEntries(IClassFileReader reader, int kind) {
        Vector<IConstantPoolEntry> entries = new Vector<IConstantPoolEntry>();
        IConstantPool pool = reader.getConstantPool();
        int poolSize = pool.getConstantPoolCount();
        int i = 0;
        while (i < poolSize) {
            if (pool.getEntryKind(i) == kind) {
                entries.add(pool.decodeEntry(i));
            }
            ++i;
        }
        return entries.toArray(new IConstantPoolEntry[0]);
    }

    private ClassRef getClassRef(String name) {
        ClassRef classRef;
        ComponentAPI compAPI = this.compAPICache.getComponentAPIByClassName(name);
        String pluginId = compAPI != null ? compAPI.getName() : "unknown";
        PluginRef pluginRef = this.refs.getPluginRef(pluginId);
        if (pluginRef == null) {
            pluginRef = new PluginRef();
            pluginRef.setId(pluginId);
            this.refs.addPluginRef(pluginRef);
        }
        if ((classRef = pluginRef.getClassRef(name)) == null) {
            classRef = new ClassRef();
            classRef.setName(name);
            pluginRef.addClassRef(classRef);
        }
        return classRef;
    }

    private MethodRef getMethodRef(ClassRef classRef, String name, String descriptor) {
        MethodRef methodRef = classRef.getMethodRef(name, descriptor);
        if (methodRef == null) {
            methodRef = new MethodRef();
            methodRef.setName(name);
            methodRef.setDescriptor(descriptor);
            classRef.addMethodRef(methodRef);
        }
        return methodRef;
    }

    private FieldRef getFieldRef(ClassRef classRef, String name, String descriptor) {
        FieldRef fieldRef = classRef.getFieldRef(name, descriptor);
        if (fieldRef == null) {
            fieldRef = new FieldRef();
            fieldRef.setName(name);
            fieldRef.setDescriptor(descriptor);
            classRef.addFieldRef(fieldRef);
        }
        return fieldRef;
    }

    private boolean include(String name) {
        Iterator it;
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        if (this.excludes != null && !this.excludes.isEmpty()) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean includePlugins(String id) {
        Iterator it;
        id = id.replace('/', '.');
        id = id.replace('\\', '.');
        if (this.excludePlugins != null && !this.excludePlugins.isEmpty()) {
            it = this.excludePlugins.iterator();
            while (it.hasNext()) {
                if (!id.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includePlugins != null && !this.includePlugins.isEmpty()) {
            it = this.includePlugins.iterator();
            while (it.hasNext()) {
                if (!id.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected static String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public Object run(Object arguments) {
        String src = System.getProperty("src");
        String base = System.getProperty("base");
        String output = System.getProperty("output");
        String contactInfo = System.getProperty("contactInfo");
        String html = System.getProperty("html");
        String includes = System.getProperty("includes");
        String excludes = System.getProperty("excludes");
        String includePlugins = System.getProperty("includePlugins");
        String excludePlugins = System.getProperty("excludePlugins");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-src");
        args.addAll(this.tokenize(src));
        args.add("-base");
        args.add(base);
        args.add("-output");
        args.add(output);
        args.add("-contactInfo");
        args.add(contactInfo);
        args.add("-html");
        args.add(html);
        if (includes != null) {
            args.add("-includes");
            args.addAll(this.tokenize(includes));
        }
        if (excludes != null) {
            args.add("-excludes");
            args.addAll(this.tokenize(excludes));
        }
        if (includePlugins != null) {
            args.add("-includePlugins");
            args.addAll(this.tokenize(includePlugins));
        }
        if (excludePlugins != null) {
            args.add("-excludePlugins");
            args.addAll(this.tokenize(excludePlugins));
        }
        try {
            SimpleClass2Reference.main(args.toArray(new String[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return IPlatformRunnable.EXIT_OK;
    }

    private List tokenize(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get("src");
        Collection base = (Collection)options.get("base");
        Collection output = (Collection)options.get("output");
        Collection contactInfo = (Collection)options.get("contactInfo");
        Collection html = (Collection)options.get("html");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        Collection includePlugins = (Collection)options.get("includePlugins");
        Collection excludePlugins = (Collection)options.get("excludePlugins");
        if (src == null || base == null || output == null || contactInfo == null || src.isEmpty() || base.isEmpty() || output.isEmpty() || contactInfo.isEmpty()) {
            SimpleClass2Reference.printUsage();
            System.exit(-1);
        }
        String outputString = (String)output.iterator().next();
        int i = outputString.replace('\\', '/').lastIndexOf(47);
        String outputDir = outputString.substring(0, i + 1);
        String componentxml = String.valueOf(outputDir) + "_tmp_componentxml";
        String componentapi = String.valueOf(outputDir) + "_tmp_componentapi";
        Plugin2API plugin2API = new Plugin2API();
        plugin2API.setSrc(base);
        plugin2API.setOutputDir(componentxml);
        plugin2API.execute();
        API2ComponentAPI api2CompAPI = new API2ComponentAPI();
        api2CompAPI.setApi(componentxml);
        api2CompAPI.setSrc(base);
        api2CompAPI.setOutputDir(componentapi);
        api2CompAPI.setIncludeInnerClass(true);
        api2CompAPI.setIncludeInterfaces(true);
        api2CompAPI.execute();
        SimpleClass2Reference class2Ref = new SimpleClass2Reference();
        class2Ref.setSrc(src);
        class2Ref.setBase((String)base.iterator().next());
        class2Ref.setOutput(outputString);
        class2Ref.setContactInfo((String)contactInfo.iterator().next());
        class2Ref.setCompAPIDir(componentapi);
        if (!html.isEmpty()) {
            class2Ref.setHTML((String)html.iterator().next());
        }
        class2Ref.setIncludes(includes);
        class2Ref.setExcludes(excludes);
        class2Ref.setIncludePlugins(includePlugins);
        class2Ref.setExcludePlugins(excludePlugins);
        class2Ref.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.adopters.SimpleClass2Reference -src <src> -output <output> [-options]");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of your Eclipse-based product");
        System.out.println("\t-base\t\t<base>\t\tlocation of your base build");
        System.out.println("\t-output\t\t<output>\toutput file");
        System.out.println("\t-contactInfo\t<contactInfo>\tadopter contact information");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated packages to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated packages to exclude");
        System.out.println("\t-includePlugins\t<includePlugins>\tspace seperated plugins to include");
        System.out.println("\t-excludePlugins\t<excludePlugins>\tspace seperated plugins to exclude");
        System.out.println("\t-html\t\t\t\t<html>\toutput HTML file");
    }
}

