/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.FragmentXML;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;

public class ComponentEmitter
extends AbstractEmitter {
    public static final String OPTION_ECLIPSE_DIR = "eclipseDir";
    public static final String OPTION_COMPONENT_XML_DIR = "compXMLDir";
    public static final String OPTION_INCLUDE = "include";
    public static final String OPTION_EXCLUDE = "exclude";
    public static final String OPTION_PROPS = "props";
    private String compXMLDir;
    private List include;
    private List exclude;
    private String props;
    private Map pluginId2Plugin;
    private Map fragmentId2Fragment;

    public ComponentEmitter(String compXMLDir, String props) {
        this.compXMLDir = this.addTrailingSeperator(compXMLDir);
        this.props = props;
    }

    public void init(List eclipseDirs) {
        this.pluginId2Plugin = new HashMap();
        this.fragmentId2Fragment = new HashMap();
        Iterator it = eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.pluginId2Plugin, this.fragmentId2Fragment);
        }
        this.linkPluginsAndFragments(this.pluginId2Plugin, this.fragmentId2Fragment);
    }

    public List getInclude() {
        return this.include;
    }

    public void setInclude(List include) {
        this.include = include;
    }

    public List getExclude() {
        return this.exclude;
    }

    public void setExclude(List exclude) {
        this.exclude = exclude;
    }

    public void genComponentXML() throws IOException {
        if (this.props != null) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.props));
            Iterator<Object> it = properties.keySet().iterator();
            while (it.hasNext()) {
                String compName = (String)it.next();
                StringTokenizer pluginIds = new StringTokenizer((String)properties.get(compName), " ");
                this.genComponentXML(compName, pluginIds);
            }
        } else {
            Iterator it = this.pluginId2Plugin.keySet().iterator();
            while (it.hasNext()) {
                String pluginId = (String)it.next();
                this.genComponentXML(pluginId, new StringTokenizer(pluginId, " "));
            }
        }
    }

    public ComponentXML genComponentXML(String compName, StringTokenizer pluginIds) throws IOException {
        FileLocation location = null;
        if (this.compXMLDir != null) {
            StringBuffer sb = new StringBuffer(this.compXMLDir);
            sb.append(compName);
            sb.append('/');
            sb.append("component.xml");
            location = new FileLocation(new File(sb.toString()));
        }
        ComponentXML compXML = this.newComponentXML(compName, location);
        while (pluginIds.hasMoreTokens()) {
            String pluginId = pluginIds.nextToken();
            FragmentXML fragment = (FragmentXML)this.fragmentId2Fragment.get(pluginId);
            if (fragment != null) {
                this.addPlugin(compXML, pluginId, Boolean.TRUE);
                continue;
            }
            IPluginXML pluginXML = (IPluginXML)this.pluginId2Plugin.get(pluginId);
            if (pluginXML == null) continue;
            this.addPlugin(compXML, pluginId, Boolean.FALSE);
            List libs = pluginXML.getLibraries();
            Iterator libsIt = libs.iterator();
            while (libsIt.hasNext()) {
                ILibrary lib = (ILibrary)libsIt.next();
                Map classes = lib.getTypes();
                Iterator classesIt = classes.keySet().iterator();
                while (classesIt.hasNext()) {
                    String pkgName;
                    String className = (String)classesIt.next();
                    int index = className.lastIndexOf(46);
                    if (index == -1 || (pkgName = className.substring(0, index)).indexOf("internal") != -1 || !this.includePackage(pkgName)) continue;
                    this.addPackage(compXML, pkgName);
                }
                lib.resetTypes();
            }
        }
        if (this.compXMLDir != null) {
            System.out.println("Writing component.xml for " + compName);
            compXML.save();
        }
        return compXML;
    }

    private boolean includePackage(String pkg) {
        Iterator it;
        if (this.exclude != null) {
            it = this.exclude.iterator();
            while (it.hasNext()) {
                if (!pkg.startsWith((String)it.next())) continue;
                return false;
            }
        }
        if (this.include != null && this.include.size() > 0) {
            it = this.include.iterator();
            while (it.hasNext()) {
                if (!pkg.startsWith((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ComponentXML newComponentXML(String compName, ILocation location) {
        ComponentXML compXML = new ComponentXML();
        compXML.setName(compName);
        compXML.setLocation(location);
        ComponentDepends depends = new ComponentDepends();
        depends.setUnrestricted(Boolean.TRUE);
        compXML.setComponentDepends(depends);
        return compXML;
    }

    private Plugin addPlugin(ComponentXML compXML, String pluginId, Boolean fragment) {
        Collection plugins = compXML.getPlugins();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getId().equals(pluginId)) continue;
            return plugin;
        }
        Plugin plugin = new Plugin();
        plugin.setId(pluginId);
        plugin.setFragment(fragment);
        compXML.addPlugin(plugin);
        return plugin;
    }

    private Package addPackage(ComponentXML compXML, String pkgName) {
        Collection pkgs = compXML.getPackages();
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            Package pkg = (Package)it.next();
            if (!pkg.getName().equals(pkgName)) continue;
            return pkg;
        }
        Package pkg = new Package();
        pkg.setName(pkgName);
        compXML.addPackage(pkg);
        return pkg;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List eclipseDir = (List)options.get(OPTION_ECLIPSE_DIR);
        List compXMLDir = (List)options.get(OPTION_COMPONENT_XML_DIR);
        List include = (List)options.get(OPTION_INCLUDE);
        List exclude = (List)options.get(OPTION_EXCLUDE);
        List props = (List)options.get(OPTION_PROPS);
        if (eclipseDir == null || compXMLDir == null || eclipseDir.size() < 1 || compXMLDir.size() < 1) {
            ComponentEmitter.printUsage();
            System.exit(-1);
        }
        ComponentEmitter compEmitter = new ComponentEmitter((String)compXMLDir.get(0), props != null ? (String)props.get(0) : null);
        compEmitter.setInclude(include);
        compEmitter.setExclude(exclude);
        compEmitter.init(eclipseDir);
        try {
            compEmitter.genComponentXML();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.model.ComponentEmitter -eclipseDir <eclipseDir> -compXMLDir <compXMLDir> [-options]");
        System.out.println("");
        System.out.println("\t-eclipseDir\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-compXMLDir\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-include\t<include>\tspace seperated packages to include");
        System.out.println("\t-exclude\t<exclude>\tspace seperated packages to exclude");
        System.out.println("\t-props\t<props>\tuse this properties file to define components");
    }
}

