/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Sample;

public class OSPerformanceMeter
extends InternalPerformanceMeter {
    private PerformanceMonitor fPerformanceMonitor;
    private long fStartTime;
    private List fDataPoints = new ArrayList();

    public OSPerformanceMeter(String scenarioId) {
        super(scenarioId);
        this.fPerformanceMonitor = PerformanceMonitor.getPerformanceMonitor();
        this.fStartTime = System.currentTimeMillis();
    }

    public void dispose() {
        this.fPerformanceMonitor = null;
        this.fDataPoints = null;
        super.dispose();
    }

    public void start() {
        this.snapshot(0);
    }

    public void stop() {
        this.snapshot(1);
    }

    public Sample getSample() {
        if (this.fDataPoints != null) {
            HashMap runProperties = new HashMap();
            this.collectRunInfo(runProperties);
            return new Sample(this.getScenarioName(), this.fStartTime, runProperties, this.fDataPoints.toArray(new DataPoint[this.fDataPoints.size()]));
        }
        return null;
    }

    private void snapshot(int step) {
        HashMap map = new HashMap();
        this.fPerformanceMonitor.collectOperatingSystemCounters(map);
        this.fDataPoints.add(new DataPoint(step, map));
    }

    private void collectRunInfo(HashMap runProperties) {
        this.fPerformanceMonitor.collectGlobalPerformanceInfo(runProperties);
    }
}

