/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;

public class PortOriginal {
    private FixpTransform subrot;
    private Orientation orient;
    private Cell bottomCell;
    private ImmutableNodeInst bottomNode;
    private PortInst bottomPort;
    private NodeInst bottomNi;
    private PrimitivePort bottomPp;

    public PortOriginal(PortInst startPort) {
        this.bottomPort = startPort;
        this.traverse(startPort.getNodeInst(), startPort.getPortProto(), null);
    }

    public PortOriginal(PortInst startPort, FixpTransform pre) {
        this.bottomPort = startPort;
        this.traverse(startPort.getNodeInst(), startPort.getPortProto(), pre);
    }

    public PortOriginal(NodeInst ni, PortProto pp) {
        this.traverse(ni, pp, null);
    }

    private void traverse(NodeInst ni, PortProto pp, FixpTransform pre) {
        this.bottomCell = ni.getParent();
        this.bottomNode = ni.getD();
        this.bottomNi = ni;
        EDatabase database = this.bottomCell != null ? this.bottomCell.getDatabase() : (ni.isCellInstance() ? ((Cell)ni.getProto()).getDatabase() : null);
        this.orient = this.bottomNode.orient;
        this.subrot = new FixpTransform(this.bottomNode.anchor, this.orient);
        if (pre != null) {
            this.subrot.preConcatenate(pre);
        }
        while (this.bottomNode.protoId instanceof CellId) {
            this.bottomCell = database.getCell((CellId)this.bottomNode.protoId);
            ImmutableExport bottomExport = ((Export)pp).getD();
            this.bottomNode = this.bottomCell.backup().cellRevision.getNodeById(bottomExport.originalNodeId);
            this.bottomPort = null;
            this.bottomNi = null;
            pp = bottomExport.originalPortId.inDatabase(database);
            this.orient = this.orient.concatenate(this.bottomNode.orient);
            FixpTransform transform = new FixpTransform(this.bottomNode.anchor, this.bottomNode.orient);
            this.subrot.concatenate(transform);
        }
        this.bottomPp = (PrimitivePort)pp;
        this.subrot.translateFixp(-this.bottomNode.anchor.getFixpX(), -this.bottomNode.anchor.getFixpY());
    }

    public NodeInst getBottomNodeInst() {
        if (this.bottomNi == null) {
            this.bottomPort = this.bottomCell.getPortInst(this.bottomNode.nodeId, this.bottomPp.getId());
            this.bottomNi = this.bottomPort.getNodeInst();
        }
        return this.bottomNi;
    }

    public Cell getBottomCell() {
        return this.bottomCell;
    }

    public ImmutableNodeInst getBottomImmutableNodeInst() {
        return this.bottomNode;
    }

    public PrimitivePort getBottomPortProto() {
        return this.bottomPp;
    }

    public PortInst getBottomPort() {
        if (this.bottomPort == null) {
            this.getBottomNodeInst();
            this.bottomPort = this.bottomNi != null ? this.bottomNi.findPortInstFromProto(this.bottomPp) : null;
        }
        return this.bottomPort;
    }

    public FixpTransform getTransformToTop() {
        return this.subrot;
    }

    public Orientation getOrientToTop() {
        return this.orient;
    }
}

