/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.CalibreDrcErrors;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class CalibreRdbErrors {
    private int scale;
    private String topCellName;
    private Cell topCell;
    private ErrorLogger logger = ErrorLogger.newInst("Calibre Antenna DRC Errors");
    private BufferedReader in;
    private int lineno;
    private int errorCount = 0;
    private static final String spaces = "[\\s\\t ]+";

    public void importErrors(String filename, Map<Cell, String> mangledNames) {
        this.lineno = 1;
        try {
            System.out.println("Reading RDB file " + filename);
            FileReader reader = new FileReader(filename);
            this.in = new BufferedReader(reader);
            String line = this.in.readLine();
            if (line == null) {
                return;
            }
            String[] parts = line.trim().split(spaces);
            if (parts.length != 2) {
                System.out.println("Error: Invalid header in RDB file at line " + this.lineno + ": " + line);
                return;
            }
            this.topCellName = parts[0];
            this.topCell = CalibreDrcErrors.getCell(this.topCellName, mangledNames);
            if (this.topCell == null) {
                System.out.println("Error: Cell '" + this.topCellName + "' specified in file does not exist in current hierarchy: " + filename);
                return;
            }
            try {
                this.scale = Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException e) {
                System.out.println("Warning: Invalid scale value " + parts[1] + " at line " + this.lineno);
                this.scale = 1000;
            }
            ++this.lineno;
            boolean more = true;
            while (more) {
                more = this.readRuleViolation();
            }
            this.in.close();
        }
        catch (IOException e) {
            System.out.println("Error importing RDB database: " + e.getMessage());
            return;
        }
    }

    public void termLogging(boolean explain) {
        this.logger.termLogging(explain);
        Job.getUserInterface().showInformationMessage("Calibre Antenna DRC Imported " + this.errorCount + " errors", "Calibre Antenna DRC");
    }

    private boolean readRuleViolation() throws IOException {
        Cell cell;
        StringBuffer propLines;
        ArrayList<Property> properties;
        ArrayList<PolyBase> polyList;
        ArrayList<EPoint> lineList;
        Object ruleText;
        block23: {
            if (this.in == null) {
                return false;
            }
            double lambdaScale = this.topCell.getTechnology().getScale() / 1000.0;
            String line = this.in.readLine();
            if (line == null) {
                return false;
            }
            int ruleEnd = line.indexOf("::");
            if (ruleEnd < 0) {
                System.out.println("Error: expected :: in rule name line at " + this.lineno + ": " + line);
                return false;
            }
            String rule = line.substring(0, ruleEnd);
            ++this.lineno;
            line = this.in.readLine();
            if (line == null) {
                System.out.println("Error: premature end of file at line " + this.lineno);
                return false;
            }
            ++this.lineno;
            line = this.in.readLine();
            if (line == null) {
                System.out.println("Error: premature end of file at line " + this.lineno);
                return false;
            }
            ruleText = line;
            boolean ruleTextAnnotatedWithAR = false;
            ++this.lineno;
            lineList = new ArrayList<EPoint>();
            polyList = new ArrayList<PolyBase>();
            properties = new ArrayList<Property>();
            propLines = new StringBuffer();
            cell = null;
            while (true) {
                String[] parts;
                this.in.mark(200);
                line = this.in.readLine();
                if (line == null) break block23;
                if (line.startsWith(rule)) {
                    this.in.reset();
                    break block23;
                }
                if (line.contains("=")) {
                    parts = line.trim().split(spaces);
                    Object commonprefix = "";
                    int i = 0;
                    if (!parts[0].contains("=")) {
                        commonprefix = parts[0] + " ";
                        ++i;
                    }
                    while (i < parts.length) {
                        String[] namevalue = parts[i].split("=");
                        if (namevalue.length == 2) {
                            properties.add(new Property((String)commonprefix + namevalue[0], namevalue[1]));
                        }
                        ++i;
                    }
                    propLines.append(line);
                    propLines.append("\n");
                    ++this.lineno;
                    continue;
                }
                if (line.startsWith("p")) {
                    parts = line.trim().split(spaces);
                    if (parts.length != 3) {
                        System.out.println("Error parsing polygon list at line" + this.lineno + ": " + line);
                        return false;
                    }
                    int count = 0;
                    try {
                        count = Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error: expected number as third argument in polygon at line " + this.lineno + ": " + parts[2]);
                        return false;
                    }
                    PolyBase.Point[] points = new PolyBase.Point[count];
                    for (int i = 0; i < count; ++i) {
                        line = this.in.readLine();
                        if (line == null) {
                            System.out.println("Error: premature end of file at line " + this.lineno);
                            return false;
                        }
                        if (line.startsWith("AR")) {
                            i = -1;
                            if (ruleTextAnnotatedWithAR) continue;
                            ruleText = line + "; " + (String)ruleText;
                            ruleTextAnnotatedWithAR = true;
                            continue;
                        }
                        ++this.lineno;
                        String[] coords = line.trim().split(spaces);
                        if (coords.length != 2) {
                            System.out.println("Error: expected two fields for poly coord at " + this.lineno + ": " + line);
                            return false;
                        }
                        double x = 0.0;
                        double y = 0.0;
                        try {
                            x = Double.parseDouble(coords[0]) / (double)this.scale / lambdaScale;
                            y = Double.parseDouble(coords[1]) / (double)this.scale / lambdaScale;
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error: polygon coordinates should be numbers at line " + this.lineno + ": " + line);
                            return false;
                        }
                        points[i] = PolyBase.fromLambda(x, y);
                    }
                    polyList.add(new PolyBase(points));
                    continue;
                }
                if (line.startsWith("e")) break;
            }
            System.out.println("Error: edge spec not supported yet, didn't have example. Please tell JKG. Thanks");
            return false;
        }
        StringBuffer props = new StringBuffer();
        for (Property prop : properties) {
            props.append(prop.toString());
        }
        if (cell == null) {
            cell = this.topCell;
        }
        this.logger.logMessageWithLines((String)ruleText + "\n" + propLines.toString(), polyList, lineList, cell, 0, true);
        ++this.errorCount;
        return true;
    }

    private static class Property {
        private final String name;
        private final String value;

        private Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }
}

