/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceInstance;
import com.sun.electric.tool.io.input.spicenetlist.SpiceModel;
import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpiceSubckt {
    private final String name;
    private final List<String> ports = new ArrayList<String>();
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private final Map<String, SpiceModel> localModels = new LinkedHashMap<String, SpiceModel>();
    private final Map<String, String> localParams = new LinkedHashMap<String, String>();
    private final List<SpiceInstance> instances = new ArrayList<SpiceInstance>();
    private final Map<String, PortType> porttypes = new HashMap<String, PortType>();
    private final Map<String, SpiceSubckt> subckts = new LinkedHashMap<String, SpiceSubckt>();

    public SpiceSubckt(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addPort(String port) {
        this.ports.add(port);
    }

    public boolean hasPort(String portname) {
        return this.ports.contains(portname);
    }

    public boolean hasPortCaseInsensitive(String portname) {
        for (String port : this.ports) {
            if (!portname.equalsIgnoreCase(port)) continue;
            return true;
        }
        return false;
    }

    public List<String> getPorts() {
        return this.ports;
    }

    public String getParamValue(String name) {
        return this.params.get(name);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getLocalParams() {
        return this.localParams;
    }

    SpiceModel findModel(String modName) {
        return this.localModels.get(modName.toLowerCase());
    }

    SpiceModel addModel(String modPrefix, String modFlag) {
        String key = modPrefix.toLowerCase();
        SpiceModel model = this.localModels.get(key);
        if (model == null) {
            model = new SpiceModel(modPrefix, modFlag);
            this.localModels.put(key, model);
        }
        return model;
    }

    void addInstance(SpiceInstance inst) {
        this.instances.add(inst);
    }

    public List<SpiceInstance> getInstances() {
        return this.instances;
    }

    public void setPortType(String port, PortType type) {
        if (this.ports.contains(port) && type != null) {
            this.porttypes.put(port, type);
        }
    }

    public PortType getPortType(String port) {
        return this.porttypes.get(port);
    }

    SpiceSubckt addSubckt(SpiceSubckt subckt) {
        return this.subckts.put(subckt.name.toLowerCase(), subckt);
    }

    public SpiceSubckt findSubckt(String subcktName) {
        return this.subckts.get(subcktName.toLowerCase());
    }

    void markUsed(Set<SpiceSubckt> usedSubckts, Set<SpiceModel> usedModels) {
        if (usedSubckts.add(this)) {
            for (SpiceInstance inst : this.instances) {
                inst.markUsed(usedSubckts, usedModels);
            }
        }
    }

    public void write(PrintStream out, Set<SpiceSubckt> usedSubckts, Set<SpiceModel> usedModels) {
        if (usedSubckts != null && !usedSubckts.contains(this)) {
            return;
        }
        StringBuilder buf = new StringBuilder(".subckt ");
        buf.append(this.name);
        buf.append(" ");
        for (String port : this.ports) {
            buf.append(port);
            buf.append(" ");
        }
        for (String key : this.params.keySet()) {
            buf.append(key).append("=").append(this.params.get(key)).append(" ");
        }
        buf.append("\n");
        SpiceNetlistReader.multiLinePrint(out, false, buf.toString());
        for (String key : this.localParams.keySet()) {
            out.println(".param " + key + "=" + this.localParams.get(key));
        }
        for (SpiceModel model : this.localModels.values()) {
            model.write(out, usedModels);
        }
        for (SpiceSubckt subckt : this.subckts.values()) {
            subckt.write(out, usedSubckts, usedModels);
        }
        for (SpiceInstance inst : this.instances) {
            inst.write(out);
        }
        out.println(".ends " + this.name);
    }

    public static enum PortType {
        IN,
        OUT,
        BIDIR;

    }
}

