/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.machine;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStar;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarClosedListBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarOpenListBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.ExternalVisitor;
import com.sun.electric.tool.routing.experimentalAStar2.machine.AStarMachine;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar2.storage.AStarClosedListHashMap;
import com.sun.electric.tool.routing.experimentalAStar2.storage.AStarOpenListPriorityQueue;
import java.util.List;

public class AStarMachineSimple
implements AStarMachine<AStarNode> {
    private ObjectPool<AStarNode> nodePool;
    private AStarOpenListBase<AStarNode> openList;
    private AStarClosedListBase<AStarNode> closedList;
    private AStarMapBase<AStarNode> map = null;
    private AStarGoalBase<AStarNode> goal = null;

    public AStarMachineSimple(ObjectPool<AStarNode> nodePool) {
        this.nodePool = nodePool;
        this.openList = new AStarOpenListPriorityQueue();
        this.closedList = new AStarClosedListHashMap();
    }

    @Override
    public List<AStarNode> findPath(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        if (this.map == null) {
            throw new IllegalStateException("The searched map must be specified before path search can be done.");
        }
        if (this.goal == null) {
            throw new IllegalStateException("The goal object must be specified before path search can be done.");
        }
        AStarNode goalNode = this.map.nodeAt(endX, endY, endZ);
        int goalDistance = this.goal.getNodeCost(goalNode, startX, startY, startZ);
        goalNode.initialize(null, goalDistance, 0, goalDistance, endX, endY, endZ);
        this.goal.setGoalNode(goalNode);
        AStarNode startNode = this.map.nodeAt(startX, startY, startZ);
        startNode.initialize(null, 0, goalDistance, goalDistance, startX, startY, startZ);
        this.openList.addNodeToOpenList(startNode);
        return AStar.findPath(this.openList, this.closedList, this.map, this.goal, this.nodePool, new ExternalVisitor<AStarNode>(this.openList, this.closedList, this.map, this.goal));
    }

    @Override
    public void setUpSearchSpace(AStarMapBase<AStarNode> newMap, AStarGoalBase<AStarNode> newGoal) {
        if (newMap == null) {
            throw new IllegalArgumentException("The map to search may not be null.");
        }
        if (newGoal == null) {
            throw new IllegalArgumentException("The goal object may not be null.");
        }
        this.map = newMap;
        this.goal = newGoal;
        this.goal.setNodeStorage(this.openList);
    }
}

