/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.util.concurrent.exceptions.PoolExistsException;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.Scheduler;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.ThreadPool;
import com.sun.electric.util.CollectionFactory;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class SeaOfGatesEngineNonoverlappingBatch
extends SeaOfGatesEngine {
    private final SeaOfGatesEngineFactory.SeaOfGatesEngineType version;

    public SeaOfGatesEngineNonoverlappingBatch(SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        this.version = version;
    }

    @Override
    protected void doRoutingParallel(int numberOfThreads, List<SeaOfGatesEngine.NeededRoute> allRoutes) {
        this.debug("Do routing parallel with new parallel Infrastructure 3");
        JoinExecutor executor = switch (this.version) {
            case SeaOfGatesEngineFactory.SeaOfGatesEngineType.batchSemaphore -> new SemaphoreExecutor(numberOfThreads);
            case SeaOfGatesEngineFactory.SeaOfGatesEngineType.batchInfrastructure -> new InfrastructureExecutor(numberOfThreads);
            default -> throw new AssertionError();
        };
        ArrayList routesToDo = CollectionFactory.createArrayList();
        ArrayList<SeaOfGatesEngine.NeededRoute> myList = new ArrayList<SeaOfGatesEngine.NeededRoute>(allRoutes);
        ArrayList<Rectangle2D> blocked = new ArrayList<Rectangle2D>();
        int totalRoutes = allRoutes.size();
        int routesDone = 0;
        while (myList.size() > 0) {
            if (this.checkAbort()) {
                this.info("Sea-of-gates routing aborted");
                break;
            }
            int threadAssign = 0;
            blocked.clear();
            for (int i = 0; i < myList.size(); ++i) {
                SeaOfGatesEngine.NeededRoute nr = (SeaOfGatesEngine.NeededRoute)myList.get(i);
                boolean isBlocked = false;
                for (Rectangle2D block : blocked) {
                    if (!block.intersects(nr.getBounds())) continue;
                    isBlocked = true;
                    break;
                }
                if (isBlocked) continue;
                myList.remove(i);
                Runnable[] runnables = this.findPath(nr);
                if (runnables == null || runnables.length == 0) continue;
                blocked.add(nr.getBounds());
                routesToDo.add(nr);
                for (Runnable runnable : runnables) {
                    executor.execute(runnable);
                }
                ++threadAssign;
            }
            this.trace("process " + threadAssign + " routes in parallel");
            executor.join();
            this.flush();
            routesToDo.clear();
            this.setProgressValue(routesDone += threadAssign, totalRoutes);
        }
        routesToDo.clear();
        executor.shutdown();
    }

    private static class SemaphoreExecutor
    extends JoinExecutor {
        private final ExecutorService executor;
        private final Semaphore sem = new Semaphore(0);
        private int joinCount;

        private SemaphoreExecutor(int parallelism) {
            this.executor = Executors.newFixedThreadPool(parallelism);
        }

        @Override
        public void execute(final Runnable command) {
            ++this.joinCount;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    command.run();
                    sem.release();
                }
            });
        }

        @Override
        public void join() {
            this.sem.acquireUninterruptibly(this.joinCount);
            this.joinCount = 0;
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class InfrastructureExecutor
    extends JoinExecutor {
        private PJob seaOfGatesJob;

        InfrastructureExecutor(int parallelism) {
            try {
                ThreadPool.initialize(Scheduler.SchedulingStrategy.stack, parallelism, ThreadPool.ThreadPoolType.userDefined);
            }
            catch (PoolExistsException poolExistsException) {
            }
            catch (Scheduler.UnknownSchedulerException e) {
                e.printStackTrace();
            }
            this.seaOfGatesJob = new PJob();
            this.seaOfGatesJob.execute(false);
        }

        @Override
        public void execute(final Runnable runnable) {
            this.seaOfGatesJob.add(new PTask(this.seaOfGatesJob){

                @Override
                public void execute() {
                    runnable.run();
                }
            });
        }

        @Override
        void join() {
            this.seaOfGatesJob.join();
        }

        @Override
        void shutdown() {
            this.join();
            try {
                ThreadPool.getThreadPool().shutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static abstract class JoinExecutor
    implements Executor {
        private JoinExecutor() {
        }

        @Override
        public abstract void execute(Runnable var1);

        abstract void join();

        abstract void shutdown();
    }
}

