/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import java.math.BigInteger;
import java.util.Map;

public class Vec4ZeroExt<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> width;
    public final Svex<N> x;

    private Vec4ZeroExt(Svex<N> width, Svex<N> x) {
        super(FUNCTION, width, x);
        this.width = width;
        this.x = x;
    }

    @Override
    public Svex.MatchExt<N> matchExt() {
        Vec4 wval;
        if (this.width instanceof SvexQuote && (wval = ((SvexQuote)this.width).val).isVec2() && ((Vec2)wval).getVal().signum() >= 0) {
            return new Svex.MatchExt(((Vec2)wval).getVal().intValueExact(), this.args[1], false);
        }
        return null;
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        Svex<N> newWidth = this.width.lhsPreproc(sm);
        Svex<N> newX = this.x.lhsPreproc(sm);
        return sm.newCall(Vec4Concat.FUNCTION, newWidth, newX, SvexQuote.valueOf(0));
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_ZEROX, 2, "4vec-zero-ext");
        }

        public <N extends SvarName> Vec4ZeroExt<N> build(Svex<N>[] args) {
            return new Vec4ZeroExt<N>(args[0], args[1]);
        }

        @Override
        public <N extends SvarName> Svex<N> callStar(SvexManager<N> sm, Svex<N>[] args) {
            BigInteger wV;
            Vec4 wVal;
            assert (args.length == 2);
            Svex<N> width = args[0];
            if (width instanceof SvexQuote && (wVal = ((SvexQuote)width).val).isVec2() && (wV = ((Vec2)wVal).getVal()).signum() >= 0) {
                return args[1].zerox(sm, wV.intValueExact());
            }
            return super.callStar(sm, args);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            int wval;
            Vec4 width = args[0];
            Vec4 x = args[1];
            if (width.isVec2() && (wval = ((Vec2)width).getVal().intValueExact()) >= 0) {
                if (wval >= 0x1000000 && (x.getUpper().signum() < 0 || x.getLower().signum() < 0)) {
                    throw new IllegalArgumentException("very large integer");
                }
                BigInteger mask = BigIntegerUtil.logheadMask(wval);
                if (x.isVec2()) {
                    BigInteger xv = ((Vec2)x).getVal();
                    return Vec2.valueOf(xv.and(mask));
                }
                return Vec4.valueOf(x.getUpper().and(mask), x.getLower().and(mask));
            }
            return Vec4.X;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            Svex<N> width = args[0];
            BigInteger nMask = this.v4maskAllOrNone(mask);
            Vec4 widthVal = width.xeval(xevalMemoize);
            if (!widthVal.isVec2()) {
                return new BigInteger[]{nMask, nMask};
            }
            int widthV = ((Vec2)widthVal).getVal().intValueExact();
            if (widthV < 0) {
                return new BigInteger[]{nMask, BigInteger.ZERO};
            }
            BigInteger widthMask = BigInteger.ONE.shiftLeft(widthV).subtract(BigInteger.ONE);
            return new BigInteger[]{nMask, mask.and(widthMask)};
        }
    }
}

