/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.redisplay.AbstractLayerDrawing;
import com.sun.electric.tool.user.redisplay.AlphaBlender;
import com.sun.electric.tool.user.redisplay.ERaster;
import com.sun.electric.tool.user.redisplay.EmptyPatternedOutlinedTransparentRaster;
import com.sun.electric.tool.user.redisplay.PatternedTransparentRaster;
import com.sun.electric.tool.user.redisplay.TransparentRaster;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LayerDrawing
extends AbstractLayerDrawing {
    public static final int MINIMUMTEXTSIZE = 5;
    public static final int SINGLETONSTOADD = 5;
    public static final int MAXIMUMTEXTSIZE = 200;
    private static final boolean TAKE_STATS = false;
    private static int tinyCells;
    private static int tinyPrims;
    private static int totalCells;
    private static int totalPrims;
    private static int tinyArcs;
    private static int linedArcs;
    private static int totalArcs;
    private static int offscreensCreated;
    private static int offscreenPixelsCreated;
    private static int offscreensUsed;
    private static int offscreenPixelsUsed;
    private static int cellsRendered;
    private static Set<ExpandedCellKey> offscreensUsedSet;
    private static int boxCount;
    private static int lineCount;
    private static int polygonCount;
    private static int crossCount;
    private static int circleCount;
    private static int discCount;
    private static int arcCount;
    private static final boolean ENHANCE_EMPTY_PATTERNS = true;
    private static final boolean USE_HIGHLIGHT_RASTER = false;
    private static final Logger logger;
    private double globalTextScale;
    private String defaultFont;
    private VarContext varContext;
    private static final boolean nowDisplay = true;
    private boolean lastFullInstantiate = false;
    private BitSet inPlaceSubcellPath;
    private Cell inPlaceCurrent;
    private boolean canDrawText;
    private double canDrawRelativeText = Double.MAX_VALUE;
    private static double maxObjectSize;
    private final int total;
    private final ArrayList<RenderTextInfo> renderTextList = new ArrayList();
    private final ArrayList<GreekTextInfo> greekTextList = new ArrayList();
    private final ArrayList<CrossTextInfo> crossTextList = new ArrayList();
    private final int numIntsPerRow;
    private Map<Layer, TransparentRaster> layerRasters = new HashMap<Layer, TransparentRaster>();
    private TransparentRaster instanceRaster;
    private TransparentRaster gridRaster;
    private TransparentRaster highlightRaster;
    private List<SoftReference<TransparentRaster>> transparentRasterPool = new ArrayList<SoftReference<TransparentRaster>>();
    private boolean renderedWindow;
    private boolean periodicRefresh;
    private int objectCount;
    private long lastRefreshTime;
    private EditWindow wnd;
    private static Dimension topSz;
    private boolean patternedDisplay;
    private static boolean alphaBlendingOvercolor;
    private static Map<ExpandedCellKey, ExpandedCellInfo> expandedCells;
    private static final Set<CellId> changedCells;
    private static double expandedScale;
    private static int numberToReconcile;
    private GraphicsPreferences gp;
    private AbstractDrawing.DrawingPreferences dp;
    private Color textColor;
    private HashMap<PrimitivePort, Color> portColorsCache;
    private final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private final EditWindow0 dummyWnd = new EditWindow0(){

        @Override
        public VarContext getVarContext() {
            return LayerDrawing.this.varContext;
        }

        @Override
        public double getScale() {
            return LayerDrawing.this.scale;
        }

        @Override
        public double getGlobalTextScale() {
            return LayerDrawing.this.globalTextScale;
        }

        @Override
        public String getDefaultFont() {
            return LayerDrawing.this.defaultFont;
        }

        @Override
        public Rectangle2D getGlyphBounds(String text, Font font) {
            return LayerDrawing.this.CENTERRECT;
        }
    };
    private static Rectangle tempRect;

    static void drawTechPalette(Graphics2D g, GraphicsPreferences gp, int imgX, int imgY, Rectangle entrySize, double scale, VectorCache.VectorBase[] shapes) {
        int h;
        BufferedImage smallImg = new BufferedImage(entrySize.width, 2, 1);
        DataBufferInt smallDbi = (DataBufferInt)smallImg.getRaster().getDataBuffer();
        int[] smallOpaqueData = smallDbi.getData();
        LayerDrawing offscreen = new LayerDrawing(new Dimension(entrySize.width, entrySize.height));
        offscreen.gp = gp;
        offscreen.textColor = gp.getColor(User.ColorPrefType.TEXT);
        offscreen.initOrigin(scale, EPoint.ORIGIN);
        offscreen.renderedWindow = true;
        offscreen.patternedDisplay = true;
        offscreen.canDrawText = true;
        offscreen.canDrawRelativeText = 0.0;
        offscreen.clearImage(offscreen.setClip(null));
        offscreen.renderTextList.clear();
        offscreen.greekTextList.clear();
        offscreen.crossTextList.clear();
        ArrayList<VectorCache.VectorBase> shapeList = new ArrayList<VectorCache.VectorBase>();
        for (VectorCache.VectorBase shape : shapes) {
            shapeList.add(shape);
        }
        offscreen.drawList(0L, 0L, shapeList);
        AlphaBlender alphaBlender = new AlphaBlender();
        HashMap<Layer, int[]> layerBits = new HashMap<Layer, int[]>();
        for (Map.Entry<Layer, TransparentRaster> e : offscreen.layerRasters.entrySet()) {
            layerBits.put(e.getKey(), e.getValue().layerBitMap);
        }
        List<AbstractDrawing.LayerColor> blendingOrder = LayerDrawing.getBlendingOrderForTechPalette(gp, layerBits.keySet());
        ArrayList<AbstractDrawing.LayerColor> colors = new ArrayList<AbstractDrawing.LayerColor>();
        ArrayList<int[]> bits = new ArrayList<int[]>();
        for (AbstractDrawing.LayerColor layerColor : blendingOrder) {
            int[] b = (int[])layerBits.get(layerColor.layer);
            if (b == null) continue;
            colors.add(layerColor);
            bits.add(b);
        }
        alphaBlender.init(gp.getColor(User.ColorPrefType.BACKGROUND), colors, bits);
        int width = offscreen.sz.width;
        int height = offscreen.sz.height;
        int numIntsPerRow = offscreen.numIntsPerRow;
        int baseByteIndex = 0;
        for (int y = 0; y < height; y += h) {
            h = Math.min(2, height - y);
            int baseIndex = 0;
            for (int k = 0; k < h; ++k) {
                alphaBlender.composeLine(baseByteIndex, 0, width - 1, smallOpaqueData, baseIndex);
                baseByteIndex += numIntsPerRow;
                baseIndex += width;
            }
            g.drawImage((Image)smallImg, imgX, imgY + y, null);
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (RenderTextInfo textInfo : offscreen.renderTextList) {
            textInfo.offX += imgX;
            textInfo.offY += imgY;
            textInfo.draw(g, null);
        }
    }

    private static List<AbstractDrawing.LayerColor> getBlendingOrderForTechPalette(GraphicsPreferences gp, Set<Layer> layersAvailable) {
        boolean alphaBlendingOvercolor = true;
        ArrayList<AbstractDrawing.LayerColor> layerColors = new ArrayList<AbstractDrawing.LayerColor>();
        ArrayList<Layer> sortedLayers = new ArrayList<Layer>(layersAvailable);
        Layer.getLayersSortedByRule(sortedLayers, Layer.LayerSortingType.ByHeightContact);
        float[] backgroundComps = gp.getColor(User.ColorPrefType.BACKGROUND).getRGBColorComponents(null);
        float bRed = backgroundComps[0];
        float bGreen = backgroundComps[1];
        float bBlue = backgroundComps[2];
        for (Layer layer : sortedLayers) {
            Color color = gp.getGraphics(layer).getColor();
            float[] compArray = color.getRGBComponents(null);
            float red = compArray[0];
            float green = compArray[1];
            float blue = compArray[2];
            float opacity = 0.7f;
            float inverseAlpha = 1.0f - opacity;
            if (alphaBlendingOvercolor) {
                red -= bRed * inverseAlpha;
                green -= bGreen * inverseAlpha;
                blue -= bBlue * inverseAlpha;
            } else {
                red *= opacity;
                green *= opacity;
                blue *= opacity;
            }
            layerColors.add(new AbstractDrawing.LayerColor(layer, red, green, blue, inverseAlpha));
        }
        return layerColors;
    }

    public LayerDrawing(Dimension sz) {
        super(sz);
        this.total = sz.height * sz.width;
        this.numIntsPerRow = (sz.width + 32 - 1) / 32;
        this.renderedWindow = true;
    }

    public LayerDrawing(double scale, int lX, int hX, int lY, int hY) {
        super(new Dimension(hX - lX + 1, hY - lY + 1));
        this.initOrigin(scale, -lX, hY);
        this.setClip(null);
        this.total = this.sz.height * this.sz.width;
        this.numIntsPerRow = (this.sz.width + 32 - 1) / 32;
    }

    public Dimension getSize() {
        return this.sz;
    }

    public static void clearSubCellCache() {
        expandedCells = new HashMap<ExpandedCellKey, ExpandedCellInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(Drawing drawing, boolean fullInstantiate, ERectangle drawLimitBounds, double patternedScaleLimit, double alphaBlendingOvercolorLimit) {
        HashSet<CellId> changedCellsCopy;
        EditWindow wnd;
        Cell cell;
        long clearTime = 0L;
        long countTime = 0L;
        ElapseTimer timer = ElapseTimer.createInstance();
        long initialUsed = 0L;
        if (fullInstantiate != this.lastFullInstantiate) {
            LayerDrawing.clearSubCellCache();
            this.lastFullInstantiate = fullInstantiate;
        }
        if ((cell = (wnd = drawing.wnd).getInPlaceEditTopCell()) == null || !cell.isLinked()) {
            return;
        }
        List<NodeInst> inPlaceNodePath = wnd.getInPlaceEditNodePath();
        if (inPlaceNodePath.isEmpty()) {
            this.inPlaceSubcellPath = null;
        } else {
            this.inPlaceSubcellPath = new BitSet();
            for (NodeInst ni : inPlaceNodePath) {
                Cell subCell = (Cell)ni.getProto();
                this.inPlaceSubcellPath.set(subCell.getId().cellIndex);
            }
        }
        this.inPlaceCurrent = wnd.getCell();
        if (expandedScale != drawing.da.scale) {
            LayerDrawing.clearSubCellCache();
            expandedScale = drawing.da.scale;
        }
        this.varContext = wnd.getVarContext();
        this.globalTextScale = wnd.getGlobalTextScale();
        this.defaultFont = wnd.getDefaultFont();
        this.initOrigin(expandedScale, new Point2D.Double(drawing.da.offX, drawing.da.offY));
        this.patternedDisplay = expandedScale > patternedScaleLimit;
        alphaBlendingOvercolor = expandedScale > alphaBlendingOvercolorLimit;
        this.canDrawText = expandedScale > 1.0;
        this.canDrawRelativeText = this.canDrawText ? 0.0 : 5.0;
        maxObjectSize = 2.0 / expandedScale;
        topSz = this.sz;
        this.clearImage(this.setClip(drawLimitBounds));
        this.periodicRefresh = true;
        this.wnd = wnd;
        this.objectCount = 0;
        this.lastRefreshTime = System.currentTimeMillis();
        Set<CellId> set = changedCells;
        synchronized (set) {
            changedCellsCopy = new HashSet<CellId>(changedCells);
            changedCells.clear();
        }
        LayerDrawing.forceRedraw(changedCellsCopy);
        VectorCache.theCache.forceRedraw();
        numberToReconcile = 5;
        for (ExpandedCellInfo count : expandedCells.values()) {
            count.instanceCount = 0;
        }
        this.countCell(cell, drawLimitBounds, fullInstantiate, Orientation.IDENT, DBMath.MATID);
        this.renderTextList.clear();
        this.greekTextList.clear();
        this.crossTextList.clear();
        this.drawCell(cell, drawLimitBounds, fullInstantiate, Orientation.IDENT, 0L, 0L, 0, wnd.getVarContext());
        if (cell != null && wnd.isGrid()) {
            this.drawGrid(wnd, drawing.da);
        }
        if (cell != null) {
            // empty if block
        }
    }

    public void clearImage(Rectangle bounds) {
        if (bounds == null) {
            for (TransparentRaster raster : this.layerRasters.values()) {
                raster.eraseAll();
            }
            if (this.instanceRaster != null) {
                this.instanceRaster.eraseAll();
            }
            if (this.gridRaster != null) {
                this.gridRaster.eraseAll();
            }
            if (this.highlightRaster != null) {
                this.highlightRaster.eraseAll();
            }
        } else {
            for (TransparentRaster raster : this.layerRasters.values()) {
                raster.eraseBox(this.clipLX, this.clipHX, this.clipLY, this.clipHY);
            }
            if (this.instanceRaster != null) {
                this.instanceRaster.eraseBox(this.clipLX, this.clipHX, this.clipLY, this.clipHY);
            }
            if (this.gridRaster != null) {
                this.gridRaster.eraseBox(this.clipLX, this.clipHX, this.clipLY, this.clipHY);
            }
            if (this.highlightRaster != null) {
                this.highlightRaster.eraseBox(this.clipLX, this.clipHX, this.clipLY, this.clipHY);
            }
        }
    }

    private void drawGrid(EditWindow wnd, WindowFrame.DisplayAttributes da) {
        double spacingX = wnd.getGridXSpacing();
        double spacingY = wnd.getGridYSpacing();
        if (spacingX == 0.0 || spacingY == 0.0) {
            return;
        }
        double boldSpacingX = spacingX * this.dp.gridXBoldFrequency;
        double boldSpacingY = spacingY * this.dp.gridYBoldFrequency;
        double boldSpacingThreshX = spacingX / 4.0;
        double boldSpacingThreshY = spacingY / 4.0;
        Rectangle2D displayable = this.displayableBounds(da.getIntoCellTransform());
        double lX = displayable.getMinX();
        double lY = displayable.getMaxY();
        double hX = displayable.getMaxX();
        double hY = displayable.getMinY();
        double scaleX = (double)this.sz.width / (hX - lX);
        double scaleY = (double)this.sz.height / (lY - hY);
        double x1 = DBMath.toNearest(lX, spacingX);
        double y1 = DBMath.toNearest(lY, spacingY);
        boolean allBoldDots = false;
        if (spacingX * scaleX < 5.0 || spacingY * scaleY < 5.0) {
            x1 = DBMath.toNearest(x1, boldSpacingX);
            spacingX = boldSpacingX;
            y1 = DBMath.toNearest(y1, boldSpacingY);
            spacingY = boldSpacingY;
            if (spacingX * scaleX < 10.0 || spacingY * scaleY < 10.0) {
                wnd.printGridWarning();
                return;
            }
        } else if (spacingX * scaleX > 75.0 && spacingY * scaleY > 75.0) {
            allBoldDots = true;
        }
        Point2D.Double tmpPt = new Point2D.Double();
        FixpTransform outofCellTransform = da.getOutofCellTransform();
        ERaster raster = this.getGridRaster();
        for (double i = y1; i > hY; i -= spacingY) {
            double boldValueY = i;
            boldValueY = i < 0.0 ? (boldValueY -= boldSpacingThreshY / 2.0) : (boldValueY += boldSpacingThreshY / 2.0);
            boolean everyTenY = Math.abs(boldValueY) % boldSpacingY < boldSpacingThreshY;
            for (double j = x1; j < hX; j += spacingX) {
                boolean everyTenX;
                tmpPt.setLocation(j, i);
                outofCellTransform.transform(tmpPt, tmpPt);
                this.databaseToScreen(tmpPt.getX(), tmpPt.getY(), this.tempPt1);
                int x = this.tempPt1.x;
                int y = this.tempPt1.y;
                if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) continue;
                double boldValueX = j;
                boldValueX = j < 0.0 ? (boldValueX -= boldSpacingThreshX / 2.0) : (boldValueX += boldSpacingThreshX / 2.0);
                boolean bl = everyTenX = Math.abs(boldValueX) % boldSpacingX < boldSpacingThreshX;
                if (allBoldDots && everyTenX && everyTenY) {
                    int boxHY;
                    int boxLY;
                    int boxHX;
                    int boxLX = x - 2;
                    if (boxLX < 0) {
                        boxLX = 0;
                    }
                    if ((boxHX = x + 2) >= this.sz.width) {
                        boxHX = this.sz.width - 1;
                    }
                    if ((boxLY = y - 2) < 0) {
                        boxLY = 0;
                    }
                    if ((boxHY = y + 2) >= this.sz.height) {
                        boxHY = this.sz.height - 1;
                    }
                    raster.fillBox(boxLX, boxHX, boxLY, boxHY);
                    if (x > 1) {
                        raster.fillPoint(x - 2, y);
                    }
                    if (x < this.sz.width - 2) {
                        raster.fillPoint(x + 2, y);
                    }
                    if (y > 1) {
                        raster.fillPoint(x, y - 2);
                    }
                    if (y >= this.sz.height - 2) continue;
                    raster.fillPoint(x, y + 2);
                    continue;
                }
                if (allBoldDots || everyTenX && everyTenY) {
                    raster.fillPoint(x, y);
                    if (x > 0) {
                        raster.fillPoint(x - 1, y);
                    }
                    if (x < this.sz.width - 1) {
                        raster.fillPoint(x + 1, y);
                    }
                    if (y > 0) {
                        raster.fillPoint(x, y - 1);
                    }
                    if (y >= this.sz.height - 1) continue;
                    raster.fillPoint(x, y + 1);
                    continue;
                }
                raster.fillPoint(x, y);
            }
        }
        if (this.dp.gridAxesShown) {
            tmpPt.setLocation(0.0, 0.0);
            outofCellTransform.transform(tmpPt, tmpPt);
            this.databaseToScreen(tmpPt.getX(), tmpPt.getY(), this.tempPt1);
            int x = this.tempPt1.x;
            int y = this.tempPt1.y;
            if (x >= 0 && x < this.sz.width) {
                raster.fillVerLine(x, 0, this.sz.height - 1);
            }
            if (y >= 0 && y < this.sz.height) {
                raster.fillHorLine(y, 0, this.sz.width - 1);
            }
        }
    }

    private void drawHighlight(EditWindow wnd) {
        assert (false);
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        ERaster raster = this.getHighlightRaster();
        List<Highlight> highlights = highlighter.getHighlights();
        for (Highlight h : highlighter.getHighlights()) {
            if (!h.showInRaster()) continue;
            h.showHighlight(wnd.getInPlaceTransformOut(), this, raster);
        }
        if (highlights.size() == 1 && this.dp.highlightConnectedObjects) {
            Highlight h = highlights.get(0);
            h.showHighlightsConnected(wnd.getInPlaceTransformOut(), this, raster);
        }
    }

    private Rectangle2D displayableBounds(FixpTransform intoCellTransform) {
        Point2D.Double low = new Point2D.Double();
        this.screenToDatabase(0, 0, low);
        intoCellTransform.transform(low, low);
        Point2D.Double high = new Point2D.Double();
        this.screenToDatabase(this.sz.width - 1, this.sz.height - 1, high);
        intoCellTransform.transform(high, high);
        double lowX = Math.min(((Point2D)low).getX(), ((Point2D)high).getX());
        double lowY = Math.min(((Point2D)low).getY(), ((Point2D)high).getY());
        double sizeX = Math.abs(((Point2D)high).getX() - ((Point2D)low).getX());
        double sizeY = Math.abs(((Point2D)high).getY() - ((Point2D)low).getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, sizeX, sizeY);
        return bounds;
    }

    private void periodicRefresh() {
        if (this.periodicRefresh) {
            ++this.objectCount;
            if (this.objectCount > 100) {
                this.objectCount = 0;
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastRefreshTime > 1000L) {
                    this.wnd.repaint();
                }
            }
        }
    }

    private void drawCell(Cell cell, ERectangle drawLimitBounds, boolean fullInstantiate, Orientation orient, long oX, long oY, int level, VarContext context) {
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                sb.append("  ");
            }
            sb.append(cell);
            logger.trace(sb.toString());
        }
        boolean topLevel = level == 0;
        VectorCache.VectorCell vc = VectorCache.theCache.drawCell(cell.getId(), orient, context, this.scale, topLevel);
        Iterator<VectorCache.VectorSubCell> sea = vc.getSubCellTree() == null ? vc.getSubCells().iterator() : new RTNode.Search<VectorCache.VectorSubCell>(this.getSearchBounds(oX, oY, orient), vc.getSubCellTree(), true);
        while (sea.hasNext()) {
            boolean expanded;
            VectorCache.VectorSubCell vsc = sea.next();
            ImmutableNodeInst ini = vsc.getNode();
            if (logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i <= level; ++i) {
                    sb.append("  ");
                }
                sb.append("NODE ");
                sb.append(ini.name);
                logger.trace(sb.toString());
            }
            ++totalCells;
            long soX = vsc.getOffsetX() + oX;
            long soY = vsc.getOffsetY() + oY;
            VectorCache.VectorCell subVC = VectorCache.theCache.findVectorCell(vsc.getCellId(), vc.getOrientation().concatenate(ini.orient));
            this.gridToScreen(subVC.getLX() + soX, subVC.getHY() + soY, this.tempPt1);
            this.gridToScreen(subVC.getHX() + soX, subVC.getLY() + soY, this.tempPt2);
            int lX = this.tempPt1.x;
            int lY = this.tempPt1.y;
            int hX = this.tempPt2.x;
            int hY = this.tempPt2.y;
            if (vc.getSubCellTree() == null && (hX < this.clipLX || lX > this.clipHX || hY < this.clipLY || lY > this.clipHY)) continue;
            boolean onPathDown = this.inPlaceSubcellPath != null && this.inPlaceSubcellPath.get(vsc.getCellId().cellIndex);
            boolean isExpanded = cell.isExpanded(ini.nodeId);
            boolean bl = expanded = isExpanded || fullInstantiate;
            if (!expanded && onPathDown) {
                expanded = true;
            }
            CellId subCellId = vsc.getCellId();
            Cell subCell = VectorCache.theCache.database.getCell(subCellId);
            if (expanded) {
                long soY_;
                long soX_;
                Orientation subOrient = orient.concatenate(ini.orient);
                if (!this.expandedCellCached(subCell, subOrient, soX_ = vsc.getOffsetX() + oX, soY_ = vsc.getOffsetY() + oY, level, context, fullInstantiate)) {
                    ++cellsRendered;
                    this.drawCell(subCell, drawLimitBounds, fullInstantiate, subOrient, soX_, soY_, level + 1, context.push(cell, ini));
                }
            } else {
                long[] op = subVC.getOutlinePoints();
                int p1x = (int)(op[0] + soX);
                int p1y = (int)(op[1] + soY);
                int p2x = (int)(op[2] + soX);
                int p2y = (int)(op[3] + soY);
                int p3x = (int)(op[4] + soX);
                int p3y = (int)(op[5] + soY);
                int p4x = (int)(op[6] + soX);
                int p4y = (int)(op[7] + soY);
                ERaster instanceRaster = this.getInstanceRaster();
                this.drawLine(p1x, p1y, p2x, p2y, 0, instanceRaster);
                this.drawLine(p2x, p2y, p3x, p3y, 0, instanceRaster);
                this.drawLine(p3x, p3y, p4x, p4y, 0, instanceRaster);
                this.drawLine(p1x, p1y, p4x, p4y, 0, instanceRaster);
                if (this.canDrawText && this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) {
                    tempRect.setBounds(lX, lY, hX - lX, hY - lY);
                    TextDescriptor descript = ini.protoDescriptor;
                    Cell np = VectorCache.theCache.database.getCell(vsc.getCellId());
                    this.drawText(tempRect, Poly.Type.TEXTBOX, descript, np.describe(false), this.textColor, null);
                }
            }
            if (!this.canDrawText || !topLevel && !onPathDown && this.inPlaceCurrent != cell) continue;
            this.drawPortList(vsc, subVC, soX, soY, expanded, onPathDown);
        }
        List<Layer> knownLayers = vc.getKnownLayers();
        for (Layer layer : knownLayers) {
            this.drawList(oX, oY, layer, vc.getShapes(layer));
        }
        if (topLevel) {
            this.drawList(oX, oY, vc.getTopOnlyShapes());
        }
    }

    private boolean expandedCellCached(Cell subCell, Orientation orient, long oX, long oY, int level, VarContext context, boolean fullInstantiate) {
        if (expandedCells == null) {
            return false;
        }
        if (subCell.isIcon()) {
            return false;
        }
        ExpandedCellKey expansionKey = new ExpandedCellKey(subCell.getId(), orient);
        ExpandedCellInfo expandedCellCount = expandedCells.get(expansionKey);
        if (expandedCellCount != null && expandedCellCount.offscreen == null) {
            if (expandedCellCount.tooLarge) {
                return false;
            }
            if (expandedCellCount.singleton && expandedCellCount.instanceCount < 2) {
                if (numberToReconcile > 0) {
                    --numberToReconcile;
                    expandedCellCount.singleton = false;
                } else {
                    return false;
                }
            }
        }
        if (expandedCellCount == null || expandedCellCount.offscreen == null) {
            Rectangle2D textBounds;
            FixpRectangle cellBounds = FixpRectangle.from(subCell.getBounds());
            if (this.canDrawText && (textBounds = subCell.getTextBounds(this.dummyWnd)) != null) {
                ((Rectangle2D)cellBounds).add(textBounds);
            }
            FixpTransform rotTrans = orient.pureRotate();
            DBMath.transformRect((Rectangle2D)cellBounds, rotTrans);
            int lX = (int)Math.ceil(((RectangularShape)cellBounds).getMinX() * this.scale - 0.5);
            int hX = (int)Math.floor(((RectangularShape)cellBounds).getMaxX() * this.scale + 0.5);
            int lY = (int)Math.ceil(((RectangularShape)cellBounds).getMinY() * this.scale - 0.5);
            int hY = (int)Math.floor(((RectangularShape)cellBounds).getMaxY() * this.scale + 0.5);
            assert (lX <= hX && lY <= hY);
            if (expandedCellCount == null) {
                expandedCellCount = new ExpandedCellInfo();
                expandedCells.put(expansionKey, expandedCellCount);
            }
            if (hX - lX >= LayerDrawing.topSz.width / 32 && hY - lY >= LayerDrawing.topSz.height / 32) {
                expandedCellCount.tooLarge = true;
                return false;
            }
            expandedCellCount.offscreen = new LayerDrawing(this.scale, lX, hX, lY, hY);
            expandedCellCount.offscreen.gp = this.gp;
            expandedCellCount.offscreen.drawCell(subCell, null, fullInstantiate, orient, 0L, 0L, level + 1, context);
            ++offscreensCreated;
            offscreenPixelsCreated += expandedCellCount.offscreen.total;
            if (logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i <= level; ++i) {
                    sb.append("  ");
                }
                sb.append("EXPANDED ");
                sb.append(subCell);
                sb.append(" ");
                sb.append(orient);
                sb.append(" rendered in ");
                sb.append(expandedCellCount.offscreen.total);
                sb.append(" pixels ");
                for (Layer lay : expandedCellCount.offscreen.layerRasters.keySet()) {
                    sb.append(' ');
                    sb.append(lay.getName());
                }
                logger.trace(sb.toString());
            }
        }
        this.copyBits(expandedCellCount.offscreen, oX, oY);
        ++offscreensUsed;
        offscreenPixelsUsed += expandedCellCount.offscreen.total;
        return true;
    }

    private void countCell(Cell cell, ERectangle drawLimitBounds, boolean fullInstantiate, Orientation orient, FixpTransform prevTrans) {
        FixpRectangle bounds = FixpRectangle.from(ERectangle.ORIGIN);
        for (ImmutableNodeInst n : cell.backup().cellRevision.nodes) {
            if (!(n.protoId instanceof CellId)) continue;
            if (drawLimitBounds != null) {
                Cell subCell = cell.getDatabase().getCell((CellId)n.protoId);
                n.orient.rectangleBounds(subCell.getBounds(), n.anchor, bounds);
                DBMath.transformRect(bounds, prevTrans);
                if (!DBMath.rectsIntersect(bounds, drawLimitBounds)) {
                    return;
                }
            }
            this.countNode(cell, n, fullInstantiate, orient, prevTrans);
        }
    }

    private void countNode(Cell parent, ImmutableNodeInst n, boolean fullInstantiate, Orientation orient, FixpTransform trans) {
        CellId subCellId = (CellId)n.protoId;
        Cell subCell = parent.getDatabase().getCell(subCellId);
        AbstractFixpRectangle cellBounds = subCell.getBounds();
        double objWidth = Math.max(((RectangularShape)cellBounds).getWidth(), ((RectangularShape)cellBounds).getHeight());
        if (objWidth < maxObjectSize) {
            return;
        }
        Orientation subOrient = orient.concatenate(n.orient);
        FixpTransform subTrans = new FixpTransform(n.anchor, n.orient);
        subTrans.preConcatenate(trans);
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        cellBounds = poly.getBounds2D();
        Rectangle screenBounds = this.databaseToScreen(cellBounds);
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (screenBounds.x > this.sz.width || screenBounds.x + screenBounds.width < 0) {
            return;
        }
        if (screenBounds.y > this.sz.height || screenBounds.y + screenBounds.height < 0) {
            return;
        }
        boolean expanded = parent.isExpanded(n.nodeId);
        if (fullInstantiate) {
            expanded = true;
        }
        boolean bl = expanded = expanded || this.inPlaceSubcellPath != null && this.inPlaceSubcellPath.get(subCell.getId().cellIndex);
        if (!expanded) {
            return;
        }
        if (screenBounds.width < this.sz.width / 2 || screenBounds.height <= this.sz.height / 2) {
            ExpandedCellKey expansionKey = new ExpandedCellKey(subCell.getId(), subOrient);
            ExpandedCellInfo expansionCount = expandedCells.get(expansionKey);
            if (expansionCount == null) {
                expansionCount = new ExpandedCellInfo();
                expansionCount.instanceCount = 1;
                expandedCells.put(expansionKey, expansionCount);
            } else {
                ++expansionCount.instanceCount;
                if (expansionCount.instanceCount > 1) {
                    return;
                }
            }
        }
        this.countCell(subCell, null, fullInstantiate, subOrient, subTrans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRedraw(Cell cell) {
        if (cell == null) {
            return;
        }
        Set<CellId> set = changedCells;
        synchronized (set) {
            changedCells.add(cell.getId());
        }
    }

    private static void forceRedraw(Set<CellId> changedCells) {
        if (expandedCells == null) {
            return;
        }
        ArrayList<ExpandedCellKey> keys = new ArrayList<ExpandedCellKey>();
        for (ExpandedCellKey eck : expandedCells.keySet()) {
            keys.add(eck);
        }
        for (ExpandedCellKey expansionKey : keys) {
            if (!changedCells.contains(expansionKey.cellId)) continue;
            expandedCells.remove(expansionKey);
        }
    }

    private void copyBits(LayerDrawing srcOffscreen, long gridCenterX, long gridCenterY) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        int centerX = this.tempPt1.x;
        int centerY = this.tempPt1.y;
        if (srcOffscreen == null) {
            return;
        }
        Dimension dim = srcOffscreen.sz;
        int cornerX = centerX - (int)srcOffscreen.originX;
        int cornerY = centerY - (int)srcOffscreen.originY;
        int minSrcX = Math.max(0, this.clipLX - cornerX);
        int maxSrcX = Math.min(dim.width - 1, this.clipHX - cornerX);
        int minSrcY = Math.max(0, this.clipLY - cornerY);
        int maxSrcY = Math.min(dim.height - 1, this.clipHY - cornerY);
        if (minSrcX > maxSrcX || minSrcY > maxSrcY) {
            return;
        }
        for (Map.Entry<Layer, TransparentRaster> e : srcOffscreen.layerRasters.entrySet()) {
            Layer layer = e.getKey();
            ERaster raster = this.getRaster(layer, null, false);
            if (raster == null) continue;
            TransparentRaster polSrc = e.getValue();
            raster.copyBits(polSrc, minSrcX, maxSrcX, minSrcY, maxSrcY, cornerX, cornerY);
        }
        if (srcOffscreen.instanceRaster != null) {
            ERaster raster = this.getInstanceRaster();
            raster.copyBits(srcOffscreen.instanceRaster, minSrcX, maxSrcX, minSrcY, maxSrcY, cornerX, cornerY);
        }
        assert (srcOffscreen.gridRaster == null);
    }

    ERaster getRaster(Layer layer, EGraphics graphics, boolean forceVisible) {
        boolean isPatterned;
        TransparentRaster raster;
        if (layer == null) {
            layer = Artwork.tech().defaultLayer;
        }
        if ((raster = this.layerRasters.get(layer)) == null) {
            raster = this.allocateTransparentRaster();
            this.layerRasters.put(layer, raster);
        }
        if (graphics == null && layer != null) {
            graphics = this.gp.getGraphics(layer);
        }
        if ((isPatterned = graphics.isPatternedOnDisplay()) && graphics.isEmptyPattern()) {
            EGraphics.Outline o = graphics.getOutlined();
            if (o == EGraphics.Outline.NOPAT) {
                o = null;
            }
            raster = new EmptyPatternedOutlinedTransparentRaster(raster.layerBitMap, raster.intsPerRow, o);
        } else if (this.patternedDisplay && this.renderedWindow) {
            int[] pattern = null;
            if (isPatterned) {
                pattern = graphics.getReversedPattern();
            }
            if (pattern != null) {
                EGraphics.Outline o = graphics.getOutlined();
                if (o == EGraphics.Outline.NOPAT) {
                    o = null;
                }
                raster = new PatternedTransparentRaster(raster.layerBitMap, raster.intsPerRow, pattern, o);
            }
        }
        return raster;
    }

    ERaster getInstanceRaster() {
        if (this.instanceRaster == null) {
            this.instanceRaster = this.allocateTransparentRaster();
        }
        return this.instanceRaster;
    }

    ERaster getGridRaster() {
        if (this.gridRaster == null) {
            this.gridRaster = this.allocateTransparentRaster();
        }
        return this.gridRaster;
    }

    ERaster getHighlightRaster() {
        assert (false);
        if (this.highlightRaster == null) {
            this.highlightRaster = this.allocateTransparentRaster();
        }
        return this.highlightRaster;
    }

    private synchronized TransparentRaster allocateTransparentRaster() {
        while (!this.transparentRasterPool.isEmpty()) {
            TransparentRaster raster = this.transparentRasterPool.remove(0).get();
            if (raster == null) continue;
            raster.eraseAll();
            return raster;
        }
        return new TransparentRaster(this.numIntsPerRow, this.sz.height);
    }

    private synchronized void recycleTransparentRaster(TransparentRaster raster) {
        if (raster == null) {
            return;
        }
        assert (raster.intsPerRow == this.numIntsPerRow);
        assert (raster.layerBitMap.length == this.numIntsPerRow * this.sz.height);
        this.transparentRasterPool.add(new SoftReference<TransparentRaster>(raster));
    }

    private void drawList(long oX, long oY, List<VectorCache.VectorBase> shapes) {
        for (VectorCache.VectorBase vb : shapes) {
            this.periodicRefresh();
            if (vb instanceof VectorCache.VectorText) {
                this.drawText(oX, oY, (VectorCache.VectorText)vb);
                continue;
            }
            ERaster raster = this.getRaster(vb.getLayer(), vb.getGraphics(), false);
            if (raster == null) continue;
            this.drawShape(oX, oY, raster, vb);
        }
    }

    private void drawList(long oX, long oY, Layer layer, List<VectorCache.VectorBase> shapes) {
        if (shapes == null) {
            return;
        }
        if (layer == Generic.tech().glyphLay) {
            this.drawList(oX, oY, shapes);
            return;
        }
        ERaster raster = this.getRaster(layer, null, false);
        if (raster == null) {
            return;
        }
        for (VectorCache.VectorBase vb : shapes) {
            assert (vb.getLayer() == layer);
            EGraphics graphics = vb.getGraphics();
            ERaster r = raster;
            if (graphics != null && (this.patternedDisplay && this.renderedWindow || graphics.isEmptyPattern())) {
                r = this.getRaster(layer, graphics, false);
            }
            this.drawShape(oX, oY, r, vb);
        }
    }

    private void drawText(long oX, long oY, VectorCache.VectorText vt) {
        EditWindow0 textWnd;
        double size;
        TextDescriptor td = vt.getTextDescriptor();
        if (td != null && !td.isAbsoluteSize() ? (size = td.getTrueSize(this.scale, textWnd = this.wnd != null ? this.wnd : this.dummyWnd)) <= this.canDrawRelativeText : !this.canDrawText) {
            return;
        }
        switch (vt.getTextType()) {
            case 4: {
                if (this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC)) break;
                return;
            }
            case 3: {
                if (this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) break;
                return;
            }
            case 1: {
                if (this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL)) break;
                return;
            }
            case 2: {
                if (this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT)) break;
                return;
            }
            case 5: {
                if (this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ANNOTATION)) break;
                return;
            }
        }
        if (vt.isTempName() && !this.gp.isShowTempNames()) {
            return;
        }
        String drawString = vt.getString();
        long lX = vt.getCX();
        long lY = vt.getCY();
        long hX = lX + vt.getWid();
        long hY = lY + vt.getHei();
        this.gridToScreen(lX + oX, hY + oY, this.tempPt1);
        this.gridToScreen(hX + oX, lY + oY, this.tempPt2);
        lX = this.tempPt1.x;
        lY = this.tempPt1.y;
        hX = this.tempPt2.x;
        hY = this.tempPt2.y;
        Color color = this.textColor;
        if (vt.getLayer() != null) {
            color = this.gp.getGraphics(vt.getLayer()).getColor();
        }
        PrimitiveNode baseNode = null;
        if (vt.getTextType() == 2 && vt.getBasePort() != null) {
            baseNode = vt.getBasePort().getParent();
            int exportDisplayLevel = this.gp.exportDisplayLevel;
            if (exportDisplayLevel == 2) {
                int cX = (int)((lX + hX) / 2L);
                int cY = (int)((lY + hY) / 2L);
                this.crossTextList.add(new CrossTextInfo(cX, cY, this.textColor, baseNode));
                return;
            }
            if (exportDisplayLevel == 1) {
                drawString = Export.getShortName(drawString);
            }
            color = this.textColor;
        }
        tempRect.setBounds((int)lX, (int)lY, (int)(hX - lX), (int)(hY - lY));
        this.drawText(tempRect, vt.getStyle(), vt.getTextDescriptor(), drawString, color, baseNode);
    }

    private void drawShape(long oX, long oY, ERaster raster, VectorCache.VectorBase vb) {
        if (vb instanceof VectorCache.VectorManhattan) {
            ++boxCount;
            VectorCache.VectorManhattan vm = (VectorCache.VectorManhattan)vb;
            long[] coords = vm.getCoords();
            assert (coords.length == 4);
            long lX = coords[0] + oX;
            long lY = coords[1] + oY;
            long hX = coords[2] + oX;
            long hY = coords[3] + oY;
            this.drawBox(lX, lY, hX, hY, raster);
        } else if (vb instanceof VectorCache.VectorPolygon) {
            ++polygonCount;
            VectorCache.VectorPolygon vp = (VectorCache.VectorPolygon)vb;
            this.drawPolygon(oX, oY, vp.getPoints(), raster);
        } else if (vb instanceof VectorCache.VectorLine) {
            ++lineCount;
            VectorCache.VectorLine vl = (VectorCache.VectorLine)vb;
            this.drawLine(vl.getFromX() + oX, vl.getFromY() + oY, vl.getToX() + oX, vl.getToY() + oY, vl.getTexture(), raster);
        } else if (vb instanceof VectorCache.VectorCross) {
            ++crossCount;
            VectorCache.VectorCross vcr = (VectorCache.VectorCross)vb;
            int size = vcr.isSmall() ? 3 : 5;
            this.drawCross(vcr.getCenterX() + oX, vcr.getCenterY() + oY, size, raster);
        } else if (vb instanceof VectorCache.VectorCircle) {
            VectorCache.VectorCircle vci = (VectorCache.VectorCircle)vb;
            long cX = vci.getCenterX() + oX;
            long cY = vci.getCenterY() + oY;
            long eX = vci.getEdgeX() + oX;
            long eY = vci.getEdgeY() + oY;
            switch (vci.getNature()) {
                case 0: {
                    ++circleCount;
                    this.drawCircle(cX, cY, eX, eY, raster);
                    break;
                }
                case 1: {
                    ++circleCount;
                    this.drawThickCircle(cX, cY, eX, eY, raster);
                    break;
                }
                case 2: {
                    ++discCount;
                    this.drawDisc(cX, cY, eX, eY, raster);
                }
            }
        } else if (vb instanceof VectorCache.VectorCircleArc) {
            ++arcCount;
            VectorCache.VectorCircleArc vca = (VectorCache.VectorCircleArc)vb;
            this.drawCircleArc(vca.getCenterX() + oX, vca.getCenterY() + oY, vca.getEdge1X() + oX, vca.getEdge1Y() + oY, vca.getEdge2X() + oX, vca.getEdge2Y() + oY, vca.isThick(), raster);
        }
    }

    private void drawPortList(VectorCache.VectorSubCell vsc, VectorCache.VectorCell subVC_, long oX, long oY, boolean expanded, boolean onPathDown) {
        if (!this.gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT)) {
            return;
        }
        List<VectorCache.VectorCellExport> portShapes = subVC_.getCellDef().getPortShapes();
        int[] portCenters = subVC_.getPortCenters();
        assert (portShapes.size() * 2 == portCenters.length);
        for (int i = 0; i < portShapes.size(); ++i) {
            Color portColor;
            VectorCache.VectorCellExport vce = portShapes.get(i);
            if (!onPathDown && vsc.isPortShown(vce.getChronIndex())) continue;
            int cX = portCenters[i * 2];
            int cY = portCenters[i * 2 + 1];
            this.gridToScreen((long)cX + oX, (long)cY + oY, this.tempPt1);
            cX = this.tempPt1.x;
            cY = this.tempPt1.y;
            int portDisplayLevel = this.gp.portDisplayLevel;
            if (expanded) {
                portColor = this.textColor;
            } else {
                PrimitivePort basePort = vce.getBasePort();
                portColor = this.portColorsCache.get(basePort);
                if (portColor == null) {
                    portColor = basePort.getPortColor(this.gp);
                    if (portColor == null) {
                        portColor = this.textColor;
                    }
                    this.portColorsCache.put(basePort, portColor);
                }
            }
            if (portDisplayLevel == 2) {
                this.crossTextList.add(new CrossTextInfo(cX, cY, portColor, null));
                continue;
            }
            boolean shortName = portDisplayLevel == 1;
            String drawString = vce.getName(shortName);
            tempRect.setBounds(cX, cY, 0, 0);
            Poly.Type style = vce.getStyle().transformAnchorOfType(subVC_.getOrientation());
            this.drawText(tempRect, style, vce.getTextDescriptor(), drawString, portColor, null);
        }
    }

    public void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, Color color, PrimitiveNode baseNode) {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        int size = EditWindow.getDefaultFontSize();
        String fontName = this.gp.defaultFont;
        boolean italic = false;
        boolean bold = false;
        boolean underline = false;
        int rotation = 0;
        int greekScale = 0;
        if (descript != null) {
            AbstractTextDescriptor.ActiveFont af;
            double dSize;
            Color full;
            rotation = descript.getRotation().getIndex();
            int colorIndex = descript.getColorIndex();
            if (colorIndex != 0 && (full = EGraphics.getColorFromIndex(colorIndex, null)) != null) {
                color = full;
            }
            if ((size = Math.min((int)(dSize = descript.getTrueSize(this.scale, this.wnd)), 200)) < 5) {
                greekScale = 2;
                while ((size = (int)(dSize * (double)greekScale)) < 5) {
                    greekScale *= 2;
                }
            }
            italic = descript.isItalic();
            bold = descript.isBold();
            underline = descript.isUnderline();
            int fontIndex = descript.getFace();
            if (fontIndex != 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        if (style == Poly.Type.TEXTBOX && (rect.x >= this.sz.width || rect.x + rect.width < 0 || rect.y >= this.sz.height || rect.y + rect.height < 0)) {
            return;
        }
        RenderTextInfo renderInfo = new RenderTextInfo(color, baseNode);
        if (!renderInfo.buildInfo(s, fontName, size, italic, bold, underline, rect, style, rotation)) {
            return;
        }
        if (greekScale != 0) {
            int lY;
            int width = (int)renderInfo.bounds.getWidth() / greekScale;
            int sizeIndent = (size / greekScale + 1) / 4;
            Point pt = LayerDrawing.getTextCorner(width, size / greekScale, style, rect, rotation);
            int lX = pt.x;
            int hX = lX + width;
            int hY = lY = pt.y + sizeIndent;
            if (lX < 0) {
                lX = 0;
            }
            if (hX >= this.sz.width) {
                hX = this.sz.width - 1;
            }
            if (lY < 0) {
                lY = 0;
            }
            if (hY >= this.sz.height) {
                hY = this.sz.height - 1;
            }
            if (lX > hX || lY > hY) {
                return;
            }
            this.greekTextList.add(new GreekTextInfo(lX, hX, lY, hY, color, baseNode));
            return;
        }
        if (renderInfo.bounds.getMinX() >= (double)this.sz.width || renderInfo.bounds.getMaxX() < 0.0 || renderInfo.bounds.getMinY() >= (double)this.sz.height || renderInfo.bounds.getMaxY() < 0.0) {
            return;
        }
        this.renderTextList.add(renderInfo);
    }

    private static Point getTextCorner(int rasterWidth, int rasterHeight, Poly.Type style, Rectangle rect, int rotation) {
        int textWidth = rasterWidth;
        int textHeight = rasterHeight;
        int offX = 0;
        int offY = 0;
        if (style == Poly.Type.TEXTCENT) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTTOP) {
            offX = -textWidth / 2;
        } else if (style == Poly.Type.TEXTBOT) {
            offX = -textWidth / 2;
            offY = -textHeight;
        } else if (style == Poly.Type.TEXTLEFT) {
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTRIGHT) {
            offX = -textWidth;
            offY = -textHeight / 2;
        } else if (style != Poly.Type.TEXTTOPLEFT) {
            if (style == Poly.Type.TEXTBOTLEFT) {
                offY = -textHeight;
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                offX = -textWidth;
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                offX = -textWidth;
                offY = -textHeight;
            }
        }
        if (style == Poly.Type.TEXTBOX) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        }
        if (rotation != 0) {
            int saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = -saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = -offY;
                    offY = saveOffX;
                }
            }
        }
        int cX = (int)rect.getCenterX() + offX;
        int cY = (int)rect.getCenterY() + offY;
        return new Point(cX, cY);
    }

    public static Font getFont(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline) {
        Font theFont;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(font, fontStyle, tSize)) == null) {
            System.out.println("Could not find font " + font + " to render text: " + msg);
            return null;
        }
        return theFont;
    }

    static {
        offscreensUsedSet = new HashSet<ExpandedCellKey>();
        logger = LoggerFactory.getLogger(LayerDrawing.class);
        expandedCells = null;
        changedCells = new HashSet<CellId>();
        expandedScale = 0.0;
        tempRect = new Rectangle();
    }

    static class Drawing
    extends AbstractDrawing {
        private static final int SMALL_IMG_HEIGHT = 2;
        private VolatileImage vImg;
        private BufferedImage smallImg;
        private int[] smallOpaqueData;
        private final AlphaBlender alphaBlender = new AlphaBlender();
        private volatile boolean needComposite;
        private volatile DrawingData drawingData;
        boolean highlightingLayers;
        private final double patternedScaleLimit = User.getPatternedScaleLimit();
        private final double alphaBlendingOvercolorLimit = User.getAlphaBlendingOvercolorLimit();
        private double[] hsvTempArray = new double[3];
        private static boolean joglChecked = false;
        private static Class<?> layerDrawerClass;
        private static Method joglShowLayerMethod;

        Drawing(EditWindow wnd) {
            super(wnd);
        }

        @Override
        public boolean paintComponent(Graphics2D g, LayerVisibility lv, Dimension sz) {
            assert (SwingUtilities.isEventDispatchThread());
            GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();
            assert (sz.equals(this.wnd.getSize()));
            DrawingData drawingData = this.drawingData;
            if (drawingData == null || !drawingData.offscreen.getSize().equals(sz)) {
                return false;
            }
            if (this.vImg == null || this.vImg.getWidth() != sz.width || this.vImg.getHeight() != sz.height) {
                if (this.vImg != null) {
                    this.vImg.flush();
                }
                this.vImg = this.wnd.createVolatileImage(sz.width, sz.height);
                logger.debug("LayerDrawing vImg initialized");
            }
            if (this.smallImg == null || this.smallImg.getWidth() != sz.width) {
                this.smallImg = new BufferedImage(sz.width, 2, 1);
                DataBufferInt smallDbi = (DataBufferInt)this.smallImg.getRaster().getDataBuffer();
                this.smallOpaqueData = smallDbi.getData();
                logger.debug("LayerDrawing smallImg initialized");
            }
            do {
                int returnCode;
                if ((returnCode = this.vImg.validate(this.wnd.getGraphicsConfiguration())) == 1) {
                    this.renderOffscreen(gp, lv, drawingData);
                    logger.debug("layerDrawing renderOffscreen because IMAGE_RESTORED");
                } else if (returnCode == 2) {
                    this.vImg.flush();
                    this.vImg = this.wnd.createVolatileImage(sz.width, sz.height);
                    this.renderOffscreen(gp, lv, drawingData);
                    logger.debug("layerDrawing renderOffscreen because IMAGE_INCOMPATIBLE");
                } else if (this.needComposite) {
                    this.renderOffscreen(gp, lv, drawingData);
                    logger.debug("layerDrawing renderOffscreen because needComposite");
                }
                g.drawImage(this.vImg, 0, 0, this.wnd);
            } while (this.vImg.contentsLost());
            this.setupEditWindowCoordinates(sz, this.da);
            logger.debug("layerDrawing drawImage done");
            Font f = new Font(User.getDefaultFont(), 0, (int)(10.0 * this.wnd.getGlobalTextScale()));
            g.setFont(f);
            this.wnd.getMouseOverHighlighter().showHighlights(this.wnd, g, false);
            assert (drawingData.highlightRaster == null);
            this.wnd.getHighlighter().showHighlights(this.wnd, g, drawingData.highlightRaster != null);
            return true;
        }

        private void renderOffscreen(GraphicsPreferences gp, LayerVisibility lv, DrawingData dd) {
            this.needComposite = false;
            do {
                if (this.vImg.validate(this.wnd.getGraphicsConfiguration()) == 2) {
                    this.vImg = this.wnd.createVolatileImage(dd.width, dd.height);
                }
                long startTime = System.currentTimeMillis();
                Graphics2D g = this.vImg.createGraphics();
                this.highlightingLayers = false;
                Iterator<Layer> it = Technology.getCurrent().getLayers();
                while (it.hasNext()) {
                    Layer layer = it.next();
                    if (!lv.isHighlighted(layer)) continue;
                    this.highlightingLayers = true;
                }
                if (User.isLegacyComposite()) {
                    this.legacyLayerComposite(g, gp, lv, dd);
                } else {
                    this.layerComposite(g, gp, lv, dd);
                }
                long compositeTime = System.currentTimeMillis();
                for (GreekTextInfo greekTextInfo : dd.greekText) {
                    greekTextInfo.draw(g, lv);
                }
                for (TextInfo textInfo : dd.crossText) {
                    ((CrossTextInfo)textInfo).draw(g, lv);
                }
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                for (TextInfo textInfo : dd.renderText) {
                    ((RenderTextInfo)textInfo).draw(g, lv);
                }
                g.dispose();
            } while (this.vImg.contentsLost());
        }

        @Override
        public void opacityChanged() {
            assert (SwingUtilities.isEventDispatchThread());
            this.needComposite = true;
        }

        @Override
        public boolean visibilityChanged() {
            assert (SwingUtilities.isEventDispatchThread());
            this.needComposite = true;
            return true;
        }

        @Override
        public boolean hasOpacity() {
            return !User.isLegacyComposite();
        }

        private void layerComposite(Graphics2D g, GraphicsPreferences gp, LayerVisibility lv, DrawingData dd) {
            int h;
            HashMap<Layer, int[]> layerBits = new HashMap<Layer, int[]>();
            for (Map.Entry<Layer, TransparentRaster> e : dd.layerRasters.entrySet()) {
                layerBits.put(e.getKey(), e.getValue().layerBitMap);
            }
            List<AbstractDrawing.LayerColor> blendingOrder = this.getBlendingOrder(layerBits.keySet(), gp, lv, dd.patternedDisplay, alphaBlendingOvercolor);
            ArrayList<AbstractDrawing.LayerColor> colors = new ArrayList<AbstractDrawing.LayerColor>();
            ArrayList<int[]> bits = new ArrayList<int[]>();
            for (AbstractDrawing.LayerColor layerColor : blendingOrder) {
                int[] b = (int[])layerBits.get(layerColor.layer);
                if (b == null) continue;
                colors.add(layerColor);
                bits.add(b);
            }
            if (dd.instanceRaster != null) {
                colors.add(new AbstractDrawing.LayerColor(gp.getColor(User.ColorPrefType.INSTANCE)));
                bits.add(dd.instanceRaster.layerBitMap);
            }
            if (dd.gridRaster != null) {
                colors.add(new AbstractDrawing.LayerColor(gp.getColor(User.ColorPrefType.GRID)));
                bits.add(dd.gridRaster.layerBitMap);
            }
            if (dd.highlightRaster != null) {
                colors.add(new AbstractDrawing.LayerColor(gp.getColor(User.ColorPrefType.HIGHLIGHT)));
                bits.add(dd.highlightRaster.layerBitMap);
            }
            this.alphaBlender.init(gp.getColor(User.ColorPrefType.BACKGROUND), colors, bits);
            int width = dd.width;
            int height = dd.height;
            int numIntsPerRow = dd.numIntsPerRow;
            int baseByteIndex = 0;
            for (int y = 0; y < height; y += h) {
                h = Math.min(2, height - y);
                int baseIndex = 0;
                for (int k = 0; k < h; ++k) {
                    this.alphaBlender.composeLine(baseByteIndex, 0, width - 1, this.smallOpaqueData, baseIndex);
                    baseByteIndex += numIntsPerRow;
                    baseIndex += width;
                }
                g.drawImage((Image)this.smallImg, 0, y, null);
            }
        }

        private void legacyLayerComposite(Graphics2D g, GraphicsPreferences gp, LayerVisibility lv, DrawingData dd) {
            this.getBlendingOrder(dd.layerRasters.keySet(), gp, lv, false, false);
            Technology curTech = Technology.getCurrent();
            if (curTech == null) {
                for (Layer layer : dd.layerRasters.keySet()) {
                    int transparentDepth = gp.getGraphics(layer).getTransparentLayer();
                    if (transparentDepth == 0 || layer.getTechnology() == null) continue;
                    curTech = layer.getTechnology();
                }
            }
            if (curTech == null) {
                curTech = Generic.tech();
            }
            Color[] colorMap = gp.getColorMap(curTech);
            boolean dimmedTransparentLayers = false;
            Iterator<Layer> it = curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (!this.highlightingLayers || lv.isHighlighted(layer) || gp.getGraphics(layer).getTransparentLayer() == 0) continue;
                dimmedTransparentLayers = true;
                break;
            }
            if (dimmedTransparentLayers) {
                Color[] newColorMap = new Color[colorMap.length];
                int numTransparents = curTech.getNumTransparentLayers();
                Object dimLayer = new boolean[numTransparents];
                for (int i = 0; i < numTransparents; ++i) {
                    dimLayer[i] = true;
                }
                Iterator<Layer> it2 = curTech.getLayers();
                while (it2.hasNext()) {
                    int tIndex;
                    Layer layer = it2.next();
                    if (!lv.isHighlighted(layer) || (tIndex = gp.getGraphics(layer).getTransparentLayer()) == 0) continue;
                    dimLayer[tIndex - 1] = false;
                }
                for (int i = 0; i < colorMap.length; ++i) {
                    newColorMap[i] = colorMap[i];
                    if (i == 0) continue;
                    boolean dimThisEntry = true;
                    for (int j = 0; j < numTransparents; ++j) {
                        if ((i & 1 << j) == 0 || dimLayer[j] != false) continue;
                        dimThisEntry = false;
                        break;
                    }
                    newColorMap[i] = dimThisEntry ? new Color(this.dimColor(colorMap[i].getRGB())) : new Color(this.brightenColor(colorMap[i].getRGB()));
                }
                colorMap = newColorMap;
            }
            int numTransparent = 0;
            int numOpaque = 0;
            for (Layer layer : dd.layerRasters.keySet()) {
                if (!lv.isVisible(layer)) continue;
                if (gp.getGraphics(layer).getTransparentLayer() == 0) {
                    ++numOpaque;
                    continue;
                }
                ++numTransparent;
            }
            TransparentRaster[] transparentRasters = new TransparentRaster[numTransparent];
            int[] transparentMasks = new int[numTransparent];
            TransparentRaster[] opaqueRasters = new TransparentRaster[numOpaque];
            int[] opaqueCols = new int[numOpaque];
            numOpaque = 0;
            numTransparent = 0;
            for (Map.Entry<Layer, TransparentRaster> e : dd.layerRasters.entrySet()) {
                Layer layer = e.getKey();
                if (!lv.isVisible(layer)) continue;
                TransparentRaster raster = e.getValue();
                int transparentNum = gp.getGraphics(layer).getTransparentLayer();
                if (transparentNum != 0) {
                    transparentMasks[numTransparent] = 1 << transparentNum - 1 & colorMap.length - 1;
                    transparentRasters[numTransparent++] = raster;
                    continue;
                }
                opaqueCols[numOpaque] = this.getTheColor(gp.getGraphics(layer), !lv.isHighlighted(layer));
                opaqueRasters[numOpaque++] = raster;
            }
            int numIntsPerRow = dd.numIntsPerRow;
            int backgroundColor = gp.getColor(User.ColorPrefType.BACKGROUND).getRGB() & 0xFFFFFF;
            int hx = dd.width - 1;
            int ly = 0;
            int hy = dd.height - 1;
            for (int y = ly; y <= hy; ++y) {
                int baseByteIndex = y * numIntsPerRow;
                for (int x = 0; x <= hx; ++x) {
                    int pixelValue;
                    int entry = baseByteIndex + (x >> 5);
                    int maskBit = 1 << (x & 0x1F);
                    int opaqueIndex = -1;
                    for (int i = 0; i < opaqueRasters.length; ++i) {
                        if ((opaqueRasters[i].layerBitMap[entry] & maskBit) == 0) continue;
                        opaqueIndex = i;
                    }
                    if (opaqueIndex >= 0) {
                        pixelValue = opaqueCols[opaqueIndex];
                    } else {
                        int bits = 0;
                        for (int i = 0; i < transparentRasters.length; ++i) {
                            if ((transparentRasters[i].layerBitMap[entry] & maskBit) == 0) continue;
                            bits |= transparentMasks[i];
                        }
                        pixelValue = bits != 0 ? colorMap[bits].getRGB() & 0xFFFFFF : backgroundColor;
                    }
                    this.smallOpaqueData[x] = pixelValue;
                }
                g.drawImage((Image)this.smallImg, 0, y, null);
            }
        }

        int getTheColor(EGraphics desc, boolean dimmed) {
            int col = desc.getRGB();
            if (this.highlightingLayers) {
                col = dimmed ? this.dimColor(col) : this.brightenColor(col);
            }
            return col;
        }

        private int dimColor(int col) {
            int r = col & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col >> 16 & 0xFF;
            this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
            this.hsvTempArray[1] = this.hsvTempArray[1] * 0.2;
            col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
            return col;
        }

        private int brightenColor(int col) {
            int r = col & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col >> 16 & 0xFF;
            this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
            this.hsvTempArray[1] = this.hsvTempArray[1] * 1.5;
            if (this.hsvTempArray[1] > 1.0) {
                this.hsvTempArray[1] = 1.0;
            }
            col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
            return col;
        }

        private void fromRGBtoHSV(int ir, int ig, int ib, double[] hsi) {
            double r = (float)ir / 255.0f;
            double g = (float)ig / 255.0f;
            double b = (float)ib / 255.0f;
            hsi[2] = Math.max(Math.max(r, g), b);
            double x = Math.min(Math.min(r, g), b);
            hsi[1] = hsi[2] == 0.0 ? 0.0 : (hsi[2] - x) / hsi[2];
            hsi[0] = 0.0;
            if (hsi[1] != 0.0) {
                double rdot = (hsi[2] - r) / (hsi[2] - x);
                double gdot = (hsi[2] - g) / (hsi[2] - x);
                double bdot = (hsi[2] - b) / (hsi[2] - x);
                if (b == x && r == hsi[2]) {
                    hsi[0] = (1.0 - gdot) / 6.0;
                } else if (b == x && g == hsi[2]) {
                    hsi[0] = (1.0 + rdot) / 6.0;
                } else if (r == x && g == hsi[2]) {
                    hsi[0] = (3.0 - bdot) / 6.0;
                } else if (r == x && b == hsi[2]) {
                    hsi[0] = (3.0 + gdot) / 6.0;
                } else if (g == x && b == hsi[2]) {
                    hsi[0] = (5.0 - rdot) / 6.0;
                } else if (g == x && r == hsi[2]) {
                    hsi[0] = (5.0 + bdot) / 6.0;
                } else {
                    System.out.println("Cannot convert (" + ir + "," + ig + "," + ib + "), for x=" + x + " i=" + hsi[2] + " s=" + hsi[1]);
                }
            }
        }

        private int fromHSVtoRGB(double h, double s, double v) {
            int i = (int)(h *= 6.0);
            double f = h - (double)i;
            double m = v * (1.0 - s);
            double n = v * (1.0 - s * f);
            double k = v * (1.0 - s * (1.0 - f));
            int r = 0;
            int g = 0;
            int b = 0;
            switch (i) {
                case 0: {
                    r = (int)(v * 255.0);
                    g = (int)(k * 255.0);
                    b = (int)(m * 255.0);
                    break;
                }
                case 1: {
                    r = (int)(n * 255.0);
                    g = (int)(v * 255.0);
                    b = (int)(m * 255.0);
                    break;
                }
                case 2: {
                    r = (int)(m * 255.0);
                    g = (int)(v * 255.0);
                    b = (int)(k * 255.0);
                    break;
                }
                case 3: {
                    r = (int)(m * 255.0);
                    g = (int)(n * 255.0);
                    b = (int)(v * 255.0);
                    break;
                }
                case 4: {
                    r = (int)(k * 255.0);
                    g = (int)(m * 255.0);
                    b = (int)(v * 255.0);
                    break;
                }
                case 5: {
                    r = (int)(v * 255.0);
                    g = (int)(m * 255.0);
                    b = (int)(n * 255.0);
                }
            }
            if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                System.out.println("(" + h + "," + s + "," + v + ") -> (" + r + "," + g + "," + b + ") (i=" + i + ")");
                if (r < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
            }
            return b << 16 | g << 8 | r;
        }

        private List<AbstractDrawing.LayerColor> getBlendingOrder(Set<Layer> layersAvailable, GraphicsPreferences gp, LayerVisibility lv, boolean patternedDisplay, boolean alphaBlendingOvercolor) {
            ArrayList<AbstractDrawing.LayerColor> layerColors = new ArrayList<AbstractDrawing.LayerColor>();
            ArrayList<Layer> sortedLayers = new ArrayList<Layer>(layersAvailable);
            Layer.getLayersSortedByRule(sortedLayers, Layer.LayerSortingType.ByHeightContact);
            float[] backgroundComps = gp.getColor(User.ColorPrefType.BACKGROUND).getRGBColorComponents(null);
            float bRed = backgroundComps[0];
            float bGreen = backgroundComps[1];
            float bBlue = backgroundComps[2];
            for (Layer layer : sortedLayers) {
                if (!lv.isVisible(layer) || layer == Generic.tech().glyphLay && !patternedDisplay) continue;
                Color color = gp.getGraphics(layer).getColor();
                float[] compArray = color.getRGBComponents(null);
                float red = compArray[0];
                float green = compArray[1];
                float blue = compArray[2];
                float opacity = lv.getOpacity(layer);
                if (opacity <= 0.0f) continue;
                float inverseAlpha = 1.0f - opacity;
                if (alphaBlendingOvercolor) {
                    red -= bRed * inverseAlpha;
                    green -= bGreen * inverseAlpha;
                    blue -= bBlue * inverseAlpha;
                } else {
                    red *= opacity;
                    green *= opacity;
                    blue *= opacity;
                }
                layerColors.add(new AbstractDrawing.LayerColor(layer, red, green, blue, inverseAlpha));
            }
            return layerColors;
        }

        @Override
        public void render(Dimension sz, WindowFrame.DisplayAttributes da, GraphicsPreferences gp, AbstractDrawing.DrawingPreferences dp, boolean fullInstantiate, ERectangle bounds) {
            LayerDrawing offscreen = null;
            if (this.drawingData != null && this.drawingData.offscreen.getSize().equals(sz)) {
                offscreen = this.drawingData.offscreen;
            }
            if (offscreen == null) {
                offscreen = new LayerDrawing(sz);
            }
            this.da = da;
            offscreen.gp = gp;
            offscreen.dp = dp;
            offscreen.textColor = gp.getColor(User.ColorPrefType.TEXT);
            offscreen.portColorsCache = new HashMap();
            offscreen.drawImage(this, false, null, this.patternedScaleLimit, this.alphaBlendingOvercolorLimit);
            if (fullInstantiate) {
                offscreen.drawImage(this, true, bounds, this.patternedScaleLimit, this.alphaBlendingOvercolorLimit);
            }
            this.needComposite = true;
            if (this.drawingData != null) {
                this.drawingData.recycleRasters();
            }
            this.drawingData = new DrawingData(da, offscreen);
        }

        public static boolean hasJogl() {
            if (!joglChecked) {
                joglChecked = true;
                try {
                    layerDrawerClass = Class.forName("com.sun.electric.plugins.jogl.LayerDrawer");
                    joglShowLayerMethod = layerDrawerClass.getMethod("showLayer", Dimension.class, new int[0].getClass(), Double.TYPE, Double.TYPE, Double.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return joglShowLayerMethod != null;
        }

        @Override
        public void testJogl() {
            if (Drawing.hasJogl()) {
                try {
                    int numBoxes = 1000000;
                    int[] boxes = new int[numBoxes * 4];
                    for (int i = 0; i < numBoxes; ++i) {
                        int x = i * 5 % 501 - 100;
                        int y = i * 7 % 500 - 200;
                        boxes[i * 4 + 0] = x;
                        boxes[i * 4 + 1] = y;
                        boxes[i * 4 + 2] = x + 10;
                        boxes[i * 4 + 3] = y + 10;
                    }
                }
                catch (Exception e) {
                    System.out.println("Unable to run the LayerDrawer input module (" + e.getClass() + ")");
                    e.printStackTrace(System.out);
                }
                return;
            }
        }
    }

    private static class RenderTextInfo
    extends TextInfo {
        private GlyphVector gv;
        private LineMetrics lm;
        private Rectangle2D rasBounds;
        private Rectangle2D bounds;
        private boolean underline;
        private int rotation;
        private Rectangle rect;
        private int offX;
        private int offY;

        private RenderTextInfo(Color color, PrimitiveNode baseNode) {
            super(color, baseNode);
        }

        private boolean buildInfo(String msg, String fontName, int tSize, boolean italic, boolean bold, boolean underline, Rectangle probableBoxedBounds, Poly.Type style, int rotation) {
            double scale;
            Font font = LayerDrawing.getFont(msg, fontName, tSize, italic, bold, underline);
            this.underline = underline;
            this.rotation = rotation;
            this.rect = (Rectangle)probableBoxedBounds.clone();
            FontRenderContext frc = new FontRenderContext(null, true, true);
            this.gv = font.createGlyphVector(frc, msg);
            this.lm = font.getLineMetrics(msg, frc);
            Rectangle2D rasRect = this.gv.getLogicalBounds();
            int width = (int)rasRect.getWidth();
            int height = (int)((double)this.lm.getHeight() + 0.5);
            if (width <= 0 || height <= 0) {
                return false;
            }
            int fontStyle = font.getStyle();
            int boxedWidth = (int)probableBoxedBounds.getWidth();
            int boxedHeight = (int)probableBoxedBounds.getHeight();
            if (boxedWidth > 1 && boxedHeight > 1 && (width > boxedWidth || height > boxedHeight) && (font = new Font(fontName, fontStyle, (int)((double)tSize * (scale = Math.min((double)boxedWidth / (double)width, (double)boxedHeight / (double)height))))) != null) {
                this.gv = font.createGlyphVector(frc, msg);
                this.lm = font.getLineMetrics(msg, frc);
                rasRect = this.gv.getLogicalBounds();
                height = (int)((double)this.lm.getHeight() + 0.5);
                if (height <= 0) {
                    return false;
                }
                width = (int)rasRect.getWidth();
            }
            if (underline) {
                ++height;
            }
            this.rasBounds = new Rectangle2D.Double(0.0, this.lm.getAscent() - this.lm.getLeading(), width, height);
            Point anchorPoint = LayerDrawing.getTextCorner(width, height, style, probableBoxedBounds, rotation);
            this.bounds = rotation == 1 || rotation == 3 ? new Rectangle2D.Double(((Point2D)anchorPoint).getX(), ((Point2D)anchorPoint).getY(), height, width) : new Rectangle2D.Double(((Point2D)anchorPoint).getX(), ((Point2D)anchorPoint).getY(), width, height);
            int textWidth = (int)this.rasBounds.getWidth();
            int textHeight = (int)this.rasBounds.getHeight();
            if (style == Poly.Type.TEXTCENT) {
                this.offX = -textWidth / 2;
                this.offY = -textHeight / 2;
            } else if (style == Poly.Type.TEXTTOP) {
                this.offX = -textWidth / 2;
            } else if (style == Poly.Type.TEXTBOT) {
                this.offX = -textWidth / 2;
                this.offY = -textHeight;
            } else if (style == Poly.Type.TEXTLEFT) {
                this.offY = -textHeight / 2;
            } else if (style == Poly.Type.TEXTRIGHT) {
                this.offX = -textWidth;
                this.offY = -textHeight / 2;
            } else if (style != Poly.Type.TEXTTOPLEFT) {
                if (style == Poly.Type.TEXTBOTLEFT) {
                    this.offY = -textHeight;
                } else if (style == Poly.Type.TEXTTOPRIGHT) {
                    this.offX = -textWidth;
                } else if (style == Poly.Type.TEXTBOTRIGHT) {
                    this.offX = -textWidth;
                    this.offY = -textHeight;
                }
            }
            if (style == Poly.Type.TEXTBOX) {
                this.offX = -textWidth / 2;
                this.offY = -textHeight / 2;
            }
            return true;
        }

        private void draw(Graphics2D g, LayerVisibility lv) {
            if (!this.isDrawn(g, lv)) {
                return;
            }
            int width = (int)this.rasBounds.getWidth();
            int height = (int)this.rasBounds.getHeight();
            if (this.rotation == 0) {
                int atX = (int)this.rect.getCenterX() + this.offX;
                int atY = (int)this.rect.getCenterY() + this.offY;
                g.drawGlyphVector(this.gv, (float)((double)atX - this.rasBounds.getX()), (float)atY + (this.lm.getAscent() - this.lm.getLeading()));
                if (this.underline) {
                    g.drawLine(atX, atY + height - 1, atX + width - 1, atY + height - 1);
                }
            } else {
                AffineTransform saveAT = g.getTransform();
                g.translate(this.rect.getCenterX(), this.rect.getCenterY());
                g.rotate((double)(-this.rotation) * Math.PI / 2.0);
                g.drawGlyphVector(this.gv, (float)((double)this.offX - this.rasBounds.getX()), (float)this.offY + (this.lm.getAscent() - this.lm.getLeading()));
                if (this.underline) {
                    g.drawLine(this.offX, this.offY + height - 1, this.offX + width - 1, this.offY + height - 1);
                }
                g.setTransform(saveAT);
            }
        }
    }

    private static class ExpandedCellInfo {
        private boolean singleton = true;
        private int instanceCount;
        private boolean tooLarge;
        private LayerDrawing offscreen = null;

        ExpandedCellInfo() {
        }
    }

    private static class ExpandedCellKey {
        private CellId cellId;
        private Orientation orient;

        private ExpandedCellKey(CellId cellId, Orientation orient) {
            this.cellId = cellId;
            this.orient = orient;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExpandedCellKey) {
                ExpandedCellKey that = (ExpandedCellKey)obj;
                return this.cellId == that.cellId && this.orient.equals(that.orient);
            }
            return false;
        }

        public int hashCode() {
            return this.cellId.hashCode() ^ this.orient.hashCode();
        }
    }

    private class CrossTextInfo
    extends TextInfo {
        int x;
        int y;

        private CrossTextInfo(int x, int y, Color color, PrimitiveNode baseNode) {
            super(color, baseNode);
            this.x = x;
            this.y = y;
        }

        private void draw(Graphics2D g, LayerVisibility lv) {
            if (!this.isDrawn(g, lv)) {
                return;
            }
            g.drawLine(this.x - 3, this.y, this.x + 3, this.y);
            g.drawLine(this.x, this.y - 3, this.x, this.y + 3);
        }
    }

    private class GreekTextInfo
    extends TextInfo {
        int lX;
        int hX;
        int lY;
        int hY;

        private GreekTextInfo(int lX, int hX, int lY, int hY, Color color, PrimitiveNode baseNode) {
            super(color, baseNode);
            this.lX = lX;
            this.hX = hX;
            this.lY = lY;
            this.hY = hY;
        }

        private void draw(Graphics2D g, LayerVisibility lv) {
            if (!this.isDrawn(g, lv)) {
                return;
            }
            g.drawLine(this.lX, this.lY, this.hX, this.hY);
        }
    }

    private static class TextInfo {
        private Color color;
        private PrimitiveNode baseNode;

        private TextInfo(Color color, PrimitiveNode baseNode) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.color = color;
            this.baseNode = baseNode;
        }

        boolean isDrawn(Graphics2D g, LayerVisibility lv) {
            if (this.baseNode != null && !lv.isVisible(this.baseNode)) {
                return false;
            }
            g.setColor(this.color);
            return true;
        }
    }

    private static class DrawingData {
        private final LayerDrawing offscreen;
        private final int width;
        private final int height;
        private final int numIntsPerRow;
        private final boolean patternedDisplay;
        private final Map<Layer, TransparentRaster> layerRasters;
        private final TransparentRaster instanceRaster;
        private final TransparentRaster highlightRaster;
        private final TransparentRaster gridRaster;
        private final GreekTextInfo[] greekText;
        private final RenderTextInfo[] renderText;
        private final CrossTextInfo[] crossText;

        DrawingData(WindowFrame.DisplayAttributes da, LayerDrawing offscreen) {
            this.offscreen = offscreen;
            this.width = offscreen.sz.width;
            this.height = offscreen.sz.height;
            this.numIntsPerRow = offscreen.numIntsPerRow;
            this.patternedDisplay = offscreen.patternedDisplay;
            this.layerRasters = new HashMap<Layer, TransparentRaster>(offscreen.layerRasters);
            this.instanceRaster = offscreen.instanceRaster;
            this.gridRaster = offscreen.gridRaster;
            this.highlightRaster = offscreen.highlightRaster;
            this.greekText = offscreen.greekTextList.toArray(new GreekTextInfo[offscreen.greekTextList.size()]);
            this.crossText = offscreen.crossTextList.toArray(new CrossTextInfo[offscreen.crossTextList.size()]);
            this.renderText = offscreen.renderTextList.toArray(new RenderTextInfo[offscreen.renderTextList.size()]);
            offscreen.layerRasters.clear();
            offscreen.instanceRaster = null;
            offscreen.gridRaster = null;
            offscreen.highlightRaster = null;
            offscreen.greekTextList.clear();
            offscreen.crossTextList.clear();
            offscreen.renderTextList.clear();
        }

        private void recycleRasters() {
            for (TransparentRaster raster : this.layerRasters.values()) {
                this.offscreen.recycleTransparentRaster(raster);
            }
            this.offscreen.recycleTransparentRaster(this.instanceRaster);
            this.offscreen.recycleTransparentRaster(this.gridRaster);
            this.offscreen.recycleTransparentRaster(this.highlightRaster);
        }
    }
}

