/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.lang.EvalJython;
import com.sun.electric.tool.simulation.irsim.IRSIM;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.tool.user.tests.CompactionTest;
import com.sun.electric.tool.user.tests.DRCTest;
import com.sun.electric.tool.user.tests.ERCTest;
import com.sun.electric.tool.user.tests.ExportForeignTest;
import com.sun.electric.tool.user.tests.ExtractionTest;
import com.sun.electric.tool.user.tests.FakeTestJob;
import com.sun.electric.tool.user.tests.GenerationTest;
import com.sun.electric.tool.user.tests.IOTest;
import com.sun.electric.tool.user.tests.ImportForeignTest;
import com.sun.electric.tool.user.tests.JobsTest;
import com.sun.electric.tool.user.tests.LayerCoverageToolTest;
import com.sun.electric.tool.user.tests.LogicalEffortTest;
import com.sun.electric.tool.user.tests.NCCTest;
import com.sun.electric.tool.user.tests.PlacementTest;
import com.sun.electric.tool.user.tests.PrefTest;
import com.sun.electric.tool.user.tests.RoutingTest;
import com.sun.electric.tool.user.tests.ScriptingTest;
import com.sun.electric.tool.user.tests.TechnologyEditTest;
import com.sun.electric.tool.user.tests.TechnologyTest;
import com.sun.electric.tool.user.tests.WaveformTest;
import com.sun.electric.util.ClientOS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TestMenu {
    static List<AbstractTest> totalList = new ArrayList<AbstractTest>();
    static Set<String> outputDirectories = new HashSet<String>();

    public static EMenu makeMenu() {
        ArrayList<EMenuItem> items = new ArrayList<EMenuItem>();
        items.add(new EveryTestMenuItem());
        items.add(new CleanTestMenuItem());
        items.add(EMenuItem.SEPARATOR);
        items.add(TestMenu.testSubMenu("Compaction", CompactionTest.getTests(), CompactionTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("DRC", DRCTest.getTests(), DRCTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("ERC", ERCTest.getTests(), ERCTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Export", ExportForeignTest.getTests(), ExportForeignTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Extraction", ExtractionTest.getTests(), ExtractionTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Generation", GenerationTest.getTests(), GenerationTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("I-O", IOTest.getTests(), IOTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Import", ImportForeignTest.getTests(), ImportForeignTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Jobs", JobsTest.getTests(), JobsTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Layer Coverage", LayerCoverageToolTest.getTests(), LayerCoverageToolTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Logical Effort", LogicalEffortTest.getTests(), LogicalEffortTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("NCC", NCCTest.getTests(), NCCTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Placement", PlacementTest.getTests(), PlacementTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Preferences", PrefTest.getTests(), PrefTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Routing", RoutingTest.getTests(), RoutingTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Scripting", ScriptingTest.getTests(), ScriptingTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Technology", TechnologyTest.getTests(), TechnologyTest.getOutputDirectory()));
        items.add(TestMenu.testSubMenu("Technology Edit", TechnologyEditTest.getTests(), TechnologyEditTest.getOutputDirectory()));
        if (ClientOS.isOSWindows()) {
            items.add(TestMenu.testSubMenu("Waveform Window", WaveformTest.getTests(), WaveformTest.getOutputDirectory()));
        }
        return new EMenu("Test", items);
    }

    private static EMenu testSubMenu(String menuName, List<AbstractTest> list, String outputDir) {
        for (AbstractTest at : list) {
            at.setGroupName(menuName);
            if (at.isInteractive()) continue;
            totalList.add(at);
        }
        if (outputDir != null) {
            outputDirectories.add(outputDir);
        }
        int testSize = list.size() + 2;
        EMenuItem[] tests = new EMenuItem[testSize];
        int fill = 0;
        tests[fill++] = new AllMenuItems(list);
        tests[fill++] = EMenuItem.SEPARATOR;
        for (AbstractTest t : list) {
            tests[fill++] = new TestMenuItem(t);
        }
        return new EMenu(menuName, tests);
    }

    private static class EveryTestMenuItem
    extends EMenuItem {
        EveryTestMenuItem() {
            super("Run Every Test");
        }

        @Override
        public void run() {
            if (!EvalJavaBsh.hasBeanShell()) {
                System.out.println("WARNING: Bean Shell is not installed, so some tests will not be run");
            }
            if (!EvalJython.hasJython()) {
                System.out.println("WARNING: Jython is not installed, so some tests will not be run");
            }
            if (!IRSIM.hasIRSIM()) {
                System.out.println("WARNING: IRSIM is not installed, so some tests will not be run");
            }
            new FakeTestJob(totalList);
        }
    }

    private static class CleanTestMenuItem
    extends EMenuItem {
        CleanTestMenuItem() {
            super("Clean Test Menu Directory");
        }

        @Override
        public void run() {
            System.out.println("Cleaning up test area");
            for (String dir : outputDirectories) {
                File f = new File(dir);
                if (!f.exists()) continue;
                String[] subFiles = f.list();
                int deletedFiles = 0;
                for (int i = 0; i < subFiles.length; ++i) {
                    File sf = new File(dir + File.separator + subFiles[i]);
                    if (!sf.exists() || !sf.delete()) continue;
                    ++deletedFiles;
                }
                if (f.delete()) {
                    System.out.println("Deleted directory " + dir + " (" + deletedFiles + " files)");
                    continue;
                }
                System.out.println("ERROR deleting directory " + dir + " (did delete " + deletedFiles + " files)");
            }
        }
    }

    private static class AllMenuItems
    extends EMenuItem {
        private final List<AbstractTest> list;

        AllMenuItems(List<AbstractTest> list) {
            super("Run All Tests");
            this.list = list;
        }

        @Override
        public void run() {
            new FakeTestJob(this.list);
        }
    }

    private static class TestMenuItem
    extends EMenuItem {
        final AbstractTest t;

        TestMenuItem(AbstractTest t) {
            super(t.getFullTestName());
            this.t = t;
        }

        @Override
        public void run() {
            new FakeTestJob(this.t);
        }
    }
}

