/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.concurrent;

import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.IStructure;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeQueue<T>
extends IStructure<T> {
    public LockFreeQueue() {
        IStructure.Node<Object> dummy = new IStructure.Node<Object>(null);
        this.tail = new AtomicReference<IStructure.Node<Object>>(dummy);
        this.head = new AtomicReference<IStructure.Node<Object>>(dummy);
    }

    @Override
    public void add(T item) {
        IStructure.Node<T> node = new IStructure.Node<T>(item);
        while (true) {
            IStructure.Node last = (IStructure.Node)this.tail.get();
            IStructure.Node next = last.next.get();
            if (last != this.tail.get()) continue;
            if (next == null) {
                if (!last.next.compareAndSet(next, node)) continue;
                this.tail.compareAndSet(last, node);
                this.size = this.size + 1;
                return;
            }
            this.tail.compareAndSet(last, next);
        }
    }

    @Override
    public T get() throws EmptyException {
        Object value;
        while (true) {
            IStructure.Node first = (IStructure.Node)this.head.get();
            IStructure.Node last = (IStructure.Node)this.tail.get();
            IStructure.Node next = first.next.get();
            if (first != this.head.get()) continue;
            if (first == last) {
                if (next == null) {
                    throw new EmptyException();
                }
                this.tail.compareAndSet(last, next);
                continue;
            }
            value = next.value;
            if (this.head.compareAndSet(first, next)) break;
        }
        this.size = this.size - 1;
        return value;
    }

    @Override
    public boolean isEmpty() {
        IStructure.Node first = (IStructure.Node)this.head.get();
        IStructure.Node last = (IStructure.Node)this.tail.get();
        IStructure.Node next = first.next.get();
        return first == this.head.get() && first == last && next == null;
    }
}

