/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import com.izforge.izpack.adaptator.IXMLElement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElementImpl
implements IXMLElement {
    private Element element;
    private boolean hasChanged = true;
    private Vector<IXMLElement> childrenVector;

    public XMLElementImpl(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
            this.element = document.createElement(string);
            document.appendChild(this.element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public XMLElementImpl(String string, Document document) {
        this.element = document.createElement(string);
    }

    public XMLElementImpl(String string, IXMLElement iXMLElement) {
        this.element = iXMLElement.getElement().getOwnerDocument().createElement(string);
    }

    public XMLElementImpl(Node node) {
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException("The node should be an instance of Element");
        }
        this.element = (Element)node;
    }

    @Override
    public String getName() {
        return this.element.getNodeName();
    }

    @Override
    public void addChild(IXMLElement iXMLElement) {
        this.hasChanged = true;
        this.element.appendChild(iXMLElement.getElement());
    }

    @Override
    public void removeChild(IXMLElement iXMLElement) {
        this.hasChanged = true;
        this.element.removeChild(iXMLElement.getElement());
    }

    @Override
    public boolean hasChildren() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private void initChildrenVector() {
        if (this.hasChanged) {
            this.hasChanged = false;
            this.childrenVector = new Vector();
            for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                this.childrenVector.add(new XMLElementImpl(node));
            }
        }
    }

    @Override
    public int getChildrenCount() {
        this.initChildrenVector();
        return this.childrenVector.size();
    }

    @Override
    public Vector<IXMLElement> getChildren() {
        this.initChildrenVector();
        return this.childrenVector;
    }

    @Override
    public IXMLElement getChildAtIndex(int n) {
        this.initChildrenVector();
        return this.childrenVector.get(n);
    }

    @Override
    public IXMLElement getFirstChildNamed(String string) {
        XMLElementImpl xMLElementImpl = null;
        NodeList nodeList = this.element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            xMLElementImpl = new XMLElementImpl(nodeList.item(0));
        }
        return xMLElementImpl;
    }

    @Override
    public Vector<IXMLElement> getChildrenNamed(String string) {
        Vector<IXMLElement> vector = new Vector<IXMLElement>();
        NodeList nodeList = this.element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            vector.add(new XMLElementImpl(element));
        }
        return vector;
    }

    @Override
    public String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    @Override
    public String getAttribute(String string, String string2) {
        Node node = this.element.getAttributes().getNamedItem(string);
        if (node != null) {
            return node.getNodeValue();
        }
        return string2;
    }

    @Override
    public void setAttribute(String string, String string2) {
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        Attr attr = this.element.getOwnerDocument().createAttribute(string);
        attr.setValue(string2);
        namedNodeMap.setNamedItem(attr);
    }

    @Override
    public void removeAttribute(String string) {
        this.element.getAttributes().removeNamedItem(string);
    }

    @Override
    public Enumeration enumerateAttributeNames() {
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        Properties properties = new Properties();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            properties.put(node.getNodeName(), node.getNodeValue());
        }
        return properties.keys();
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.element.getAttributes().getNamedItem(string) != null;
    }

    @Override
    public Properties getAttributes() {
        Properties properties = new Properties();
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            properties.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
        }
        return properties;
    }

    @Override
    public int getLineNr() {
        Object object = this.element.getUserData("ln");
        if (object == null) {
            return -1;
        }
        try {
            return (Integer)this.element.getUserData("ln");
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
    }

    @Override
    public String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this.element.getFirstChild();
        boolean bl = node == null;
        Pattern pattern = Pattern.compile("^\\s+$");
        while (!bl && node != null) {
            String string = node.getNodeValue();
            if (node.getNodeType() == 3) {
                if (string != null && !pattern.matcher(string).matches()) {
                    stringBuilder.append(string);
                }
            } else if (node.getNodeType() == 4) {
                stringBuilder.append(string);
            } else {
                bl = true;
            }
            node = node.getNextSibling();
        }
        return bl ? null : stringBuilder.toString().trim();
    }

    @Override
    public void setContent(String string) {
        Node node;
        while ((node = this.element.getFirstChild()) != null) {
            this.element.removeChild(node);
        }
        this.element.appendChild(this.element.getOwnerDocument().createTextNode(string));
    }

    @Override
    public Node getElement() {
        return this.element;
    }

    public String toString() {
        return this.element.getNodeName() + " " + this.element.getNodeValue();
    }

    public boolean equals(Object object) {
        if (object instanceof IXMLElement) {
            IXMLElement iXMLElement = (IXMLElement)object;
            Element element = (Element)iXMLElement.getElement();
            Node node = element.getFirstChild();
            for (Node node2 = this.element.getFirstChild(); node2 != null && node != null; node2 = node2.getNextSibling()) {
                if (!node2.equals(node)) {
                    return false;
                }
                node.getNextSibling();
            }
            return true;
        }
        return false;
    }
}

