// Copyright 2007 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.beaneditor;

/**
 * Controls the position of newly added <a href="https://tapestry.apache.org/current/apidocs/org/apache/tapestry5/beanmodel/PropertyModel.html">PropertyModel</a> inside a 
 * <a href="https://tapestry.apache.org/current/apidocs/org/apache/tapestry5/beanmodel/BeanModel.html">BeanModel</a>.
 */
public enum RelativePosition
{
    /**
     * The new <a href="https://tapestry.apache.org/current/apidocs/org/apache/tapestry5/beanmodel/PropertyModel.html">PropertyModel</a> goes before the existing model.
     */
    BEFORE,

    /**
     * The new <a href="https://tapestry.apache.org/current/apidocs/org/apache/tapestry5/beanmodel/PropertyModel.html">PropertyModel</a> goes after the existing model.
     */
    AFTER
}
